/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.IDistinctFilter;
import com.bigdata.relation.accesspath.IBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class JVMDistinctFilter
implements IDistinctFilter {
    private static final Logger log = Logger.getLogger(JVMDistinctFilter.class);
    private final IVariable<?>[] vars;
    private final ConcurrentHashMap<Solution, Solution> map;

    public JVMDistinctFilter(IVariable<?>[] vars, int initialCapacity, float loadFactor, int concurrencyLevel) {
        if (vars == null) {
            throw new IllegalArgumentException();
        }
        this.vars = vars;
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public void release() {
        this.map.clear();
    }

    @Override
    public IVariable<?>[] getProjectedVars() {
        return this.vars;
    }

    private IConstant<?>[] _accept(IBindingSet bset) {
        boolean distinct;
        Object[] r = new IConstant[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            r[i] = bset.get(this.vars[i]);
        }
        Solution s = new Solution((IConstant<?>[])r);
        if (log.isTraceEnabled()) {
            log.trace((Object)("considering: " + Arrays.toString(r)));
        }
        boolean bl = distinct = this.map.putIfAbsent(s, s) == null;
        if (distinct && log.isDebugEnabled()) {
            log.debug((Object)("accepted: " + Arrays.toString(r)));
        }
        return distinct ? r : null;
    }

    @Override
    public IBindingSet accept(IBindingSet bset) {
        IConstant<?>[] vals = this._accept(bset);
        if (vals == null) {
            return null;
        }
        ListBindingSet tmp = new ListBindingSet();
        for (int i = 0; i < this.vars.length; ++i) {
            if (vals[i] == null) continue;
            tmp.set(this.vars[i], vals[i]);
        }
        return tmp;
    }

    @Override
    public long filterSolutions(ICloseableIterator<IBindingSet[]> itr, BOpStats stats, IBuffer<IBindingSet> sink) {
        long n = 0L;
        while (itr.hasNext()) {
            IBindingSet[] a = (IBindingSet[])itr.next();
            stats.chunksIn.increment();
            stats.unitsIn.add(a.length);
            for (IBindingSet bset : a) {
                if ((bset = this.accept(bset)) == null) continue;
                sink.add(bset);
                ++n;
            }
        }
        return n;
    }

    private static class Solution {
        private final int hash;
        private final IConstant<?>[] vals;

        public Solution(IConstant<?>[] vals) {
            this.vals = vals;
            this.hash = Arrays.hashCode(vals);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Solution)) {
                return false;
            }
            Solution t = (Solution)o;
            if (this.vals.length != t.vals.length) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == t.vals[i]) continue;
                if (this.vals[i] == null) {
                    return false;
                }
                if (this.vals[i].equals(t.vals[i])) continue;
                return false;
            }
            return true;
        }
    }
}

