/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.LockManager;
import info.aduna.concurrent.locks.Properties;

public class ExclusiveLockManager {
    private final LockManager lock;

    public ExclusiveLockManager() {
        this(false);
    }

    public ExclusiveLockManager(boolean trackLocks) {
        this.lock = new LockManager(trackLocks || Properties.lockTrackingEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock tryExclusiveLock() {
        if (this.lock.isActiveLock()) {
            return null;
        }
        ExclusiveLockManager exclusiveLockManager = this;
        synchronized (exclusiveLockManager) {
            if (this.lock.isActiveLock()) {
                return null;
            }
            return this.createLock();
        }
    }

    public synchronized Lock getExclusiveLock() throws InterruptedException {
        while (this.lock.isActiveLock()) {
            this.lock.waitForActiveLocks();
        }
        return this.createLock();
    }

    private Lock createLock() {
        return this.lock.createLock("Exclusive");
    }
}

