/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.IRemoteTx;
import com.bigdata.rdf.sail.webapp.client.IRemoteTxState0;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.sail.webapp.client.RemoteTransactionNotFoundException;
import com.bigdata.rdf.sail.webapp.client.RemoteTransactionValidationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class RemoteTransactionManager {
    public static final long UNISOLATED = 0L;
    public static final long READ_COMMITTED = -1L;
    private final RemoteRepositoryManager mgr;

    public static boolean isReadWriteTx(long txId) {
        return txId < -1L;
    }

    public RemoteTransactionManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException();
        }
        this.mgr = remoteRepositoryManager;
    }

    public IRemoteTx createTx(long timestamp) {
        ConnectOptions opts = new ConnectOptions(this.mgr.getBaseServiceURL() + "/tx");
        opts.method = "POST";
        opts.addRequestParam("timestamp", Long.toString(timestamp));
        JettyResponseListener response = null;
        try {
            response = this.mgr.doConnect(opts);
            JettyResponseListener listener = RemoteRepository.checkResponseCode(response);
            switch (listener.getStatus()) {
                case 201: {
                    RemoteTx remoteTx = new RemoteTx(this.singleTxResponse(response));
                    return remoteTx;
                }
            }
            try {
                throw new HttpException(listener.getStatus(), "status=" + listener.getStatus() + ", reason" + listener.getReason());
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public Iterator<IRemoteTxState0> listTx() {
        ConnectOptions opts = new ConnectOptions(this.mgr.getBaseServiceURL() + "/tx");
        opts.method = "GET";
        JettyResponseListener response = null;
        try {
            response = this.mgr.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            Iterator<IRemoteTxState0> iterator = this.multiTxResponse(response).iterator();
            return iterator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public IRemoteTxState0 statusTx(long txId) throws RemoteTransactionNotFoundException {
        ConnectOptions opts = new ConnectOptions(this.mgr.getBaseServiceURL() + "/tx/" + Long.toString(txId));
        opts.method = "POST";
        opts.addRequestParam("STATUS");
        JettyResponseListener response = null;
        try {
            response = this.mgr.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            IRemoteTxState0 iRemoteTxState0 = this.singleTxResponse(response);
            return iRemoteTxState0;
        }
        catch (HttpException ex) {
            switch (ex.getStatusCode()) {
                case 404: {
                    throw new RemoteTransactionNotFoundException(txId, this.mgr.getBaseServiceURL());
                }
            }
            throw new RuntimeException(ex);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    private boolean prepareTx(long txId) throws RemoteTransactionNotFoundException {
        if (!RemoteTransactionManager.isReadWriteTx(txId)) {
            return true;
        }
        ConnectOptions opts = new ConnectOptions(this.mgr.getBaseServiceURL() + "/tx/" + Long.toString(txId));
        opts.method = "POST";
        opts.addRequestParam("PREPARE");
        JettyResponseListener response = null;
        try {
            response = this.mgr.doConnect(opts);
            JettyResponseListener listener = RemoteRepository.checkResponseCode(response);
            switch (listener.getStatus()) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
            }
            try {
                throw new HttpException(listener.getStatus(), "status=" + listener.getStatus() + ", reason" + listener.getReason());
            }
            catch (HttpException ex) {
                switch (ex.getStatusCode()) {
                    case 404: {
                        throw new RemoteTransactionNotFoundException(txId, this.mgr.getBaseServiceURL());
                    }
                    case 409: {
                        boolean bl = false;
                        return bl;
                    }
                }
                throw new RuntimeException(ex);
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    private void abortTx(long txId) throws RemoteTransactionNotFoundException {
        ConnectOptions opts = new ConnectOptions(this.mgr.getBaseServiceURL() + "/tx/" + Long.toString(txId));
        opts.method = "POST";
        opts.addRequestParam("ABORT");
        JettyResponseListener response = null;
        try {
            response = this.mgr.doConnect(opts);
            JettyResponseListener listener = RemoteRepository.checkResponseCode(response);
            switch (listener.getStatus()) {
                case 200: {
                    return;
                }
            }
            try {
                throw new HttpException(listener.getStatus(), "status=" + listener.getStatus() + ", reason" + listener.getReason());
            }
            catch (HttpException ex) {
                switch (ex.getStatusCode()) {
                    case 404: {
                        throw new RemoteTransactionNotFoundException(txId, this.mgr.getBaseServiceURL());
                    }
                }
                throw new RuntimeException(ex);
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    private void commitTx(long txId) throws RemoteTransactionNotFoundException, RemoteTransactionValidationException {
        ConnectOptions opts = new ConnectOptions(this.mgr.getBaseServiceURL() + "/tx/" + Long.toString(txId));
        opts.method = "POST";
        opts.addRequestParam("COMMIT");
        JettyResponseListener response = null;
        try {
            response = this.mgr.doConnect(opts);
            JettyResponseListener listener = RemoteRepository.checkResponseCode(response);
            switch (listener.getStatus()) {
                case 200: {
                    return;
                }
            }
            try {
                throw new HttpException(listener.getStatus(), "status=" + listener.getStatus() + ", reason" + listener.getReason());
            }
            catch (HttpException ex) {
                switch (ex.getStatusCode()) {
                    case 404: {
                        throw new RemoteTransactionNotFoundException(txId, this.mgr.getBaseServiceURL());
                    }
                    case 409: {
                        throw new RemoteTransactionValidationException(txId, this.mgr.getBaseServiceURL());
                    }
                }
                throw new RuntimeException(ex);
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteTxState0 singleTxResponse(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final AtomicLong txId = new AtomicLong();
            final AtomicLong readsOnCommitTime = new AtomicLong();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if ("response".equals(qName)) {
                        return;
                    }
                    if (!"tx".equals(qName)) {
                        throw new RuntimeException("Expecting: 'tx', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    txId.set(Long.valueOf(attributes.getValue("txId")));
                    readsOnCommitTime.set(Long.valueOf(attributes.getValue("readsOnCommitTime")));
                }
            });
            RemoteTxState0 remoteTxState0 = new RemoteTxState0(txId.get(), readsOnCommitTime.get());
            return remoteTxState0;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IRemoteTxState0> multiTxResponse(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final LinkedList<IRemoteTxState0> list = new LinkedList<IRemoteTxState0>();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if ("response".equals(qName)) {
                        return;
                    }
                    if (!"tx".equals(qName)) {
                        throw new RuntimeException("Expecting: 'tx', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    long txId = Long.valueOf(attributes.getValue("txId"));
                    long readsOnCommitTime = Long.valueOf(attributes.getValue("readsOnCommitTime"));
                    list.add(new RemoteTxState0(txId, readsOnCommitTime));
                }
            });
            LinkedList<IRemoteTxState0> linkedList = list;
            return linkedList;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    private class RemoteTx
    implements IRemoteTx {
        private final long txId;
        private final long readsOnCommitTime;
        private final AtomicBoolean active = new AtomicBoolean(true);
        private Object lock = this;

        private RemoteTx(IRemoteTxState0 tmp) {
            long txId = tmp.getTxId();
            if (txId == -1L) {
                throw new IllegalArgumentException();
            }
            if (txId == 0L) {
                throw new IllegalArgumentException();
            }
            this.txId = txId;
            this.readsOnCommitTime = tmp.getReadsOnCommitTime();
        }

        @Override
        public long getTxId() {
            return this.txId;
        }

        @Override
        public long getReadsOnCommitTime() {
            return this.readsOnCommitTime;
        }

        @Override
        public boolean isReadOnly() {
            return this.txId > 0L;
        }

        private void assertClientThinksTxActive() {
            if (!this.active.get()) {
                throw new RemoteTransactionNotFoundException(this.txId, RemoteTransactionManager.this.mgr.getBaseServiceURL());
            }
        }

        @Override
        public boolean isActive() {
            return this.active.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prepare() throws RemoteTransactionNotFoundException {
            Object object = this.lock;
            synchronized (object) {
                this.assertClientThinksTxActive();
                return RemoteTransactionManager.this.prepareTx(this.txId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() throws RemoteTransactionNotFoundException {
            Object object = this.lock;
            synchronized (object) {
                this.assertClientThinksTxActive();
                RemoteTransactionManager.this.abortTx(this.txId);
                this.active.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws RemoteTransactionValidationException, RemoteTransactionNotFoundException {
            Object object = this.lock;
            synchronized (object) {
                this.assertClientThinksTxActive();
                RemoteTransactionManager.this.commitTx(this.txId);
                this.active.set(false);
            }
        }
    }

    private class RemoteTxState0
    implements IRemoteTxState0 {
        private final long txId;
        private final long readsOnCommitTime;

        private RemoteTxState0(long txId, long readsOnCommitTime) {
            if (txId == -1L) {
                throw new IllegalArgumentException();
            }
            if (txId == 0L) {
                throw new IllegalArgumentException();
            }
            this.txId = txId;
            this.readsOnCommitTime = readsOnCommitTime;
        }

        @Override
        public long getTxId() {
            return this.txId;
        }

        @Override
        public long getReadsOnCommitTime() {
            return this.readsOnCommitTime;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }
}

