/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailException;

public class DistinctModelReducingUnionIteration
extends LookAheadIteration<Statement, SailException> {
    private final CloseableIteration<? extends Statement, SailException> iterator;
    private final Model model;
    private final Function<Model, Model> filterable;
    private Iterator<Statement> filteredStatementsIterator;

    DistinctModelReducingUnionIteration(CloseableIteration<? extends Statement, SailException> iterator, Model model, Function<Model, Model> filterable) {
        this.iterator = iterator;
        this.model = model;
        this.filterable = filterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement getNextElement() throws SailException {
        Statement next = null;
        if (this.iterator.hasNext()) {
            next = (Statement)this.iterator.next();
            Model model = this.model;
            synchronized (model) {
                this.model.remove((Object)next);
            }
        }
        if (this.filteredStatementsIterator == null) {
            Model model = this.model;
            synchronized (model) {
                this.filteredStatementsIterator = new ArrayList((Collection)this.filterable.apply(this.model)).iterator();
            }
        }
        if (this.filteredStatementsIterator.hasNext()) {
            next = this.filteredStatementsIterator.next();
        }
        return next;
    }

    protected void handleClose() throws SailException {
        try {
            this.iterator.close();
        }
        finally {
            super.handleClose();
        }
    }
}

