/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.upload;

import com.bigdata.rdf.sail.webapp.SD;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.rio.RDFFormat;
import uk.ac.cam.cares.jps.base.query.SparqlOverHttpService;
import uk.ac.cam.cares.jps.base.util.FileUtil;

public class KnowledgeRepository {
    Logger log = Logger.getLogger(KnowledgeRepository.class.getName());
    private String endPointURL;
    private String repositoryName;
    private SparqlOverHttpService.RDFStoreType storeType;
    private String ontologyFilePath;
    private String ontologyDirectory;
    private String query;
    private List<File> files = new ArrayList<File>();

    public KnowledgeRepository() {
    }

    public KnowledgeRepository(String endPointURL, String repositoryName, SparqlOverHttpService.RDFStoreType storeType) {
        this.endPointURL = endPointURL;
        this.repositoryName = repositoryName;
        this.storeType = storeType;
    }

    public KnowledgeRepository(String endPointURL, String repositoryName, String ontologyFilePath, String ontologyDirectory) {
        this.endPointURL = endPointURL;
        this.repositoryName = repositoryName;
        this.ontologyFilePath = ontologyFilePath;
        this.ontologyDirectory = ontologyDirectory;
    }

    public KnowledgeRepository(String endPointURL, String repositoryName, SparqlOverHttpService.RDFStoreType storeType, String query) {
        this.endPointURL = endPointURL;
        this.repositoryName = repositoryName;
        this.storeType = storeType;
        this.query = query;
    }

    public RemoteRepository getRepository() throws Exception {
        RemoteRepositoryManager repositoryManager;
        try {
            this.checkRepositoryDataAvailability(this.endPointURL, this.repositoryName);
            this.checkStoreTypeDataAvailability(this.storeType);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        RemoteRepository repository = null;
        if (this.storeType.toString().equals(SparqlOverHttpService.RDFStoreType.BLAZEGRAPH.toString()) && this.repositoryExists(this.endPointURL, this.repositoryName, repositoryManager = new RemoteRepositoryManager(this.endPointURL, false))) {
            repository = repositoryManager.getRepositoryForNamespace(this.repositoryName);
            repositoryManager.close();
            return repository;
        }
        return repository;
    }

    public void uploadAnOntology() throws Exception {
        try {
            this.checkRepositoryDataAvailability(this.endPointURL, this.repositoryName);
            this.checkOntologyUploadDataAvailability(this.ontologyFilePath);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        RemoteRepository repository = this.getRepository(this.endPointURL, this.repositoryName, SparqlOverHttpService.RDFStoreType.BLAZEGRAPH);
        if (repository != null) {
            try (FileInputStream is = new FileInputStream(new File(this.ontologyFilePath));){
                repository.add(new RemoteRepository.AddOp((InputStream)is, RDFFormat.forMIMEType((String)"application/xml")));
            }
        } else {
            this.log.info("The following repository does not exist: " + this.endPointURL + this.repositoryName);
            this.log.info("Create a repository with this name and try again.");
        }
    }

    public void uploadOntology() throws Exception {
        try {
            this.checkRepositoryDataAvailability(this.endPointURL, this.repositoryName);
            this.checkOntologyUploadDataAvailability(this.ontologyFilePath);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        RemoteRepository repository = this.getRepository(this.endPointURL, this.repositoryName, SparqlOverHttpService.RDFStoreType.BLAZEGRAPH);
        if (repository != null) {
            try (FileInputStream is = new FileInputStream(new File(this.ontologyFilePath));){
                repository.add(new RemoteRepository.AddOp((InputStream)is, RDFFormat.forMIMEType((String)"application/xml")));
            }
        } else {
            this.log.info("The following repository does not exist: " + this.endPointURL + this.repositoryName);
            this.log.info("Create a repository with this name and try again.");
        }
    }

    public void uploadOntologies() throws Exception {
        String importedFileLog = "imported-file.log";
        String importErrorDetailedLog = "import-error-detailed.log";
        String nonRdfOrOwlFileLog = "non-rdf-or-owl-file.log";
        FileWriter fWDetailedLog = new FileWriter(importErrorDetailedLog, true);
        BufferedWriter bWDetailedLog = new BufferedWriter(fWDetailedLog);
        FileWriter fW = new FileWriter(importedFileLog, true);
        BufferedWriter bWImported = new BufferedWriter(fW);
        FileWriter fWNonRdfOrOwlFile = new FileWriter(nonRdfOrOwlFileLog, true);
        BufferedWriter bWNonRdfOrOwlFile = new BufferedWriter(fWNonRdfOrOwlFile);
        BufferedReader br = FileUtil.openSourceFile(importedFileLog);
        ArrayList<String> listOfImportedFiles = new ArrayList<String>();
        String line = "";
        while ((line = br.readLine()) != null) {
            listOfImportedFiles.add(line.trim());
        }
        br.close();
        System.out.println("No of already imported files: " + listOfImportedFiles.size());
        int n_of_problematic_abox = 0;
        int non_ref_owl_file = 0;
        try {
            this.checkRepositoryDataAvailability(this.endPointURL, this.repositoryName);
            this.checkOntologyDiretoryAvailability(this.ontologyDirectory);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        File dir = new File(this.ontologyDirectory);
        if (dir.isDirectory()) {
            int i = 0;
            FileUtil fileUtil = new FileUtil();
            List<File> files = fileUtil.getDirectoryFiles(dir, Arrays.asList(".owl", ".rdf"));
            System.out.println("Total number of files to upload: " + files.size());
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                if (listOfImportedFiles.contains(file.getAbsolutePath())) {
                    System.out.println("Already imported file: " + file.getAbsolutePath() + ", so skipping.");
                    continue;
                }
                try {
                    if (!this.isOwlOrRdf(file.getAbsolutePath())) {
                        bWNonRdfOrOwlFile.write("[" + ++non_ref_owl_file + "] File " + file.getName() + " is not imported as it is not in OWL or RDF format.");
                        System.out.println("[" + non_ref_owl_file + "] File " + file.getName() + " is not imported as it is not in OWL or RDF format.");
                        continue;
                    }
                    this.uploadOntology(this.endPointURL, this.repositoryName, file.getAbsolutePath());
                    bWImported.write(file.getAbsolutePath() + "\n");
                    this.log.info("[" + ++i + "] Uploaded " + file.getAbsolutePath());
                    if (i % 1000 != 0) continue;
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (Exception e) {
                    bWDetailedLog.write("[" + ++n_of_problematic_abox + "] File " + file.getName() + " could not be imported due to " + e.getMessage());
                    System.out.println("[" + n_of_problematic_abox + "] File " + file.getName() + " could not be imported due to " + e.getMessage());
                    System.out.println("Now the tool will stop. Run it again to finish the import.");
                    TimeUnit.MILLISECONDS.sleep(500L);
                    bWDetailedLog.close();
                    bWImported.close();
                    bWNonRdfOrOwlFile.close();
                    System.exit(0);
                }
            }
        }
        bWImported.close();
        bWNonRdfOrOwlFile.close();
    }

    public boolean isOwlOrRdf(String path) throws IOException {
        String line;
        BufferedReader br = FileUtil.openSourceFile(path);
        String xmlDeclaration = "^<\\?xml.*?\\?>";
        String rdfStartingTag = "^<rdf:RDF.*?";
        String rdfClosingTag = "^</rdf:RDF>";
        boolean isXmlDeclarationAppears = false;
        boolean isRdfStartingTagAppears = false;
        boolean isRdfClosingTagAppears = false;
        while ((line = br.readLine()) != null) {
            if (line.trim().matches(xmlDeclaration)) {
                isXmlDeclarationAppears = true;
            }
            if (line.trim().matches(rdfStartingTag)) {
                isRdfStartingTagAppears = true;
            }
            if (!line.trim().matches(rdfClosingTag)) continue;
            isRdfClosingTagAppears = true;
        }
        return isXmlDeclarationAppears && isRdfStartingTagAppears && isRdfClosingTagAppears;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query() throws Exception {
        try {
            this.checkRepositoryDataAvailability(this.endPointURL, this.repositoryName);
            this.checkStoreTypeDataAvailability(this.storeType);
            this.checkQueryAvailability(this.query);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        StringBuilder json = new StringBuilder();
        RemoteRepository repository = this.getRepository(this.endPointURL, this.repositoryName, this.storeType);
        IPreparedTupleQuery tupleQuery = repository.prepareTupleQuery(this.query);
        TupleQueryResult result = tupleQuery.evaluate();
        this.log.info("Query Result: " + result);
        System.out.println("Query Result: " + result);
        try {
            json = this.getResultInJson(json, result);
        }
        finally {
            result.close();
        }
        return json.toString();
    }

    public RemoteRepository getRepository(String endPointURL, String repositoryName, SparqlOverHttpService.RDFStoreType storeType) throws Exception {
        RemoteRepositoryManager repositoryManager;
        try {
            this.checkRepositoryDataAvailability(endPointURL, repositoryName);
            this.checkStoreTypeDataAvailability(storeType);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        RemoteRepository repository = null;
        if (storeType.toString().equals(SparqlOverHttpService.RDFStoreType.BLAZEGRAPH.toString()) && this.repositoryExists(endPointURL, repositoryName, repositoryManager = new RemoteRepositoryManager(endPointURL, false))) {
            repository = repositoryManager.getRepositoryForNamespace(repositoryName);
            repositoryManager.close();
            return repository;
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean repositoryExists(String endPointURL, String repositoryName, RemoteRepositoryManager repositoryManager) throws Exception {
        try (GraphQueryResult res = repositoryManager.getRepositoryDescriptions();){
            while (res.hasNext()) {
                Statement stmt = (Statement)res.next();
                if (!stmt.getPredicate().toString().equals(SD.KB_NAMESPACE.stringValue()) || !repositoryName.equals(stmt.getObject().stringValue())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadOntology(String endPointURL, String repositoryName, String ontologyFilePath) throws Exception {
        block8: {
            try {
                this.checkRepositoryDataAvailability(endPointURL, repositoryName);
                this.checkOntologyUploadDataAvailability(ontologyFilePath);
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            try {
                RemoteRepository repository = this.getRepository(endPointURL, repositoryName, SparqlOverHttpService.RDFStoreType.BLAZEGRAPH);
                if (repository != null) {
                    try (FileInputStream is = new FileInputStream(new File(ontologyFilePath));){
                        repository.add(new RemoteRepository.AddOp((InputStream)is, RDFFormat.forMIMEType((String)"application/xml")));
                        break block8;
                    }
                }
                this.log.info("The following repository does not exist: " + endPointURL + repositoryName);
                this.log.info("Create a repository with this name and try again.");
            }
            catch (Exception e) {
                System.out.println("UploadOntology:" + e.getMessage());
                System.out.println("UploadOntology: uploading the file " + ontologyFilePath);
                throw new Exception(e.getMessage());
            }
        }
    }

    public void uploadOntologies(String endPointURL, String repositoryName, String ontologyDirectory) throws Exception {
        try {
            this.checkRepositoryDataAvailability(endPointURL, repositoryName);
            this.checkOntologyDiretoryAvailability(ontologyDirectory);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        File dir = new File(ontologyDirectory);
        if (dir.isDirectory()) {
            int i = 0;
            FileUtil fileUtil = new FileUtil();
            List<File> files = fileUtil.getDirectoryFiles(dir, Arrays.asList(".owl", ".rdf"));
            System.out.println("Total number of files to upload: " + files.size());
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                this.uploadOntology(endPointURL, repositoryName, file.getAbsolutePath());
                this.log.info("[" + ++i + "] Uploaded " + file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(String endPointURL, String repositoryName, SparqlOverHttpService.RDFStoreType storeType, String query) throws Exception {
        try {
            this.checkRepositoryDataAvailability(endPointURL, repositoryName);
            this.checkStoreTypeDataAvailability(storeType);
            this.checkQueryAvailability(query);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        StringBuilder json = new StringBuilder();
        RemoteRepository repository = this.getRepository(endPointURL, repositoryName, storeType);
        IPreparedTupleQuery tupleQuery = repository.prepareTupleQuery(query);
        System.out.println(result);
        try (TupleQueryResult result = tupleQuery.evaluate();){
            json = this.getResultInJson(json, result);
        }
        return json.toString();
    }

    private StringBuilder getResultInJson(StringBuilder json, TupleQueryResult result) {
        json.append("{\n");
        json.append("  \"head\" : {\n");
        json.append("    \"vars\" : [\n");
        try {
            boolean flag = true;
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                int count = 0;
                int size = solution.getBindingNames().size();
                if (flag) {
                    for (String bindingName : solution.getBindingNames()) {
                        json.append("      \"");
                        json.append(bindingName);
                        json.append("\"");
                        if (++count < size) {
                            json.append(",");
                        }
                        json.append("\n");
                    }
                    json.append("    ]\n");
                    json.append("  },\n");
                    json.append("  \"results\" : {\n");
                    json.append("    \"bindings\" : [\n");
                    flag = false;
                }
                count = 0;
                json.append("      {\n");
                for (String bindingName : solution.getBindingNames()) {
                    json.append("        \"");
                    json.append(bindingName);
                    json.append("\" : {\n");
                    json.append("          \"value\" : ");
                    json.append(this.jsonifyString(solution.getValue(bindingName).toString()));
                    json.append("\n        }");
                    if (++count < size) {
                        json.append(",\n");
                        continue;
                    }
                    json.append("\n");
                }
                json.append("      },\n");
            }
            if (json.toString().contains(",")) {
                json.replace(json.lastIndexOf(","), json.lastIndexOf(",") + 1, "");
            }
        }
        catch (QueryEvaluationException e) {
            this.log.info(e.getMessage());
        }
        json.append("    ]\n");
        json.append("  }\n");
        json.append("}\n");
        return json;
    }

    private String jsonifyString(String value) {
        String stringType = "^^<http://www.w3.org/2001/XMLSchema#string>";
        String integerType = "^^<http://www.w3.org/2001/XMLSchema#integer>";
        String floatType = "^^<http://www.w3.org/2001/XMLSchema#float>";
        if (value.contains(stringType)) {
            value = value.replace(stringType, "");
        } else if (value.contains(integerType)) {
            value = value.replace(integerType, "");
            value = this.replaceInvertedComma(value);
        } else if (value.contains(floatType)) {
            value = value.replace(floatType, "");
            value = this.replaceInvertedComma(value);
        } else {
            value = "\"" + value + "\"";
        }
        return value;
    }

    private String replaceInvertedComma(String value) {
        if (value.startsWith("\"")) {
            value = value.replaceFirst("\"", "");
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public String getEndPointURL() {
        return this.endPointURL;
    }

    public void setEndPointURL(String endPointURL) {
        this.endPointURL = endPointURL;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public SparqlOverHttpService.RDFStoreType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(SparqlOverHttpService.RDFStoreType storeType) {
        this.storeType = storeType;
    }

    public String getOntologyFilePath() {
        return this.ontologyFilePath;
    }

    public void setOntologyFilePath(String ontologyFilePath) {
        this.ontologyFilePath = ontologyFilePath;
    }

    public String getOntologyDirectory() {
        return this.ontologyDirectory;
    }

    public void setOntologyDirectory(String ontologyDirectory) {
        this.ontologyDirectory = ontologyDirectory;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private void checkRepositoryDataAvailability(String endPointURL, String repositoryName) throws Exception {
        if (endPointURL == null) {
            throw new Exception("The value of endPointURL is null.");
        }
        if (endPointURL.trim().isEmpty()) {
            throw new Exception("The value of endPointURL is empty.");
        }
        if (repositoryName == null) {
            throw new Exception("The value of repositoryName is null.");
        }
        if (repositoryName.isEmpty()) {
            throw new Exception("The value of repositoryName is emptry.");
        }
    }

    private void checkStoreTypeDataAvailability(SparqlOverHttpService.RDFStoreType storeType) throws Exception {
        if (storeType == null) {
            throw new Exception("The value of storeType is null.");
        }
    }

    private void checkOntologyUploadDataAvailability(String ontologyFilePath) throws Exception {
        if (ontologyFilePath == null) {
            throw new Exception("The value of ontologyFilePath is null.");
        }
        if (ontologyFilePath == null) {
            throw new Exception("The value of ontologyFilePath is empty.");
        }
    }

    private void checkOntologyDiretoryAvailability(String ontologyDirectory) throws Exception {
        if (ontologyDirectory == null) {
            throw new Exception("The value of ontologyDirectory is null.");
        }
        if (ontologyDirectory == null) {
            throw new Exception("The value of ontologyDirectory is empty.");
        }
    }

    private void checkQueryAvailability(String query) throws Exception {
        if (query == null) {
            throw new Exception("The value of query is null.");
        }
        if (query == null) {
            throw new Exception("The value of query is empty.");
        }
    }

    public static void main(String[] args) {
        if (args.length >= 3) {
            if (args[0].isEmpty()) {
                System.out.println("The first argument is empty. Provide an Endpoint URL like 'http://localhost:8080/blazegraph'");
                System.exit(0);
            }
            if (args[1].isEmpty()) {
                System.out.println("The second argument is empty. Provide a repository name like 'ontokin'");
                System.exit(0);
            }
            if (args[2].isEmpty()) {
                System.out.println("The third argument is empty. Provide the path to the directory where ontologies reside like C:\\data\\kb");
                System.exit(0);
            }
            KnowledgeRepository kr = new KnowledgeRepository();
            kr.endPointURL = args[0];
            kr.repositoryName = args[1];
            kr.ontologyDirectory = args[2];
            try {
                kr.uploadOntologies();
                System.out.println("To upload the already uploaded files, please delete the imported-file.log file.");
                System.exit(0);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println("For uploading ontologies from a directory provide the URL of Endpoint, name of repository and absolute path of the ontology directory as follows:");
            System.out.println("http://localhost:8080/blazegraph ontokin C:\\data\\kb");
        }
    }
}

