/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.tools;

import java.sql.SQLException;
import java.time.LocalDateTime;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.ConstructBuilder;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class CloningTool {
    String strTag = "_Tag";
    boolean splitUpdate = true;
    int stepSize;
    int countTotal;
    boolean quads = true;
    static ExprFactory exprFactory = new ExprFactory();
    static String varCount = "count";
    static Var newS = Var.alloc((String)"newS");
    static Var varS = Var.alloc((String)"s");
    static Var varP = Var.alloc((String)"p");
    static Var varO = Var.alloc((String)"o");
    static Var varG = Var.alloc((String)"g");
    static ExprVar exprS = new ExprVar(varS);
    static ExprVar exprP = new ExprVar(varP);
    static ExprVar exprO = new ExprVar(varO);
    static ExprVar exprG = new ExprVar(varG);
    static Expr exprStrS = exprFactory.str((Object)exprS);

    public CloningTool() {
        this.stepSize = 1000000;
    }

    public CloningTool(int stepSize) {
        this.stepSize = stepSize;
    }

    public void setCloneSize(int stepSize) {
        this.stepSize = stepSize;
    }

    public void setSingleStepClone() {
        this.splitUpdate = false;
    }

    public void setTripleStore() {
        this.quads = false;
    }

    public void setQuadsStore() {
        this.quads = true;
    }

    public void clone(StoreClientInterface sourceKB, StoreClientInterface targetKB) {
        this.clone(sourceKB, null, targetKB, null);
    }

    public void clone(StoreClientInterface sourceKB, StoreClientInterface targetKB, String graph) {
        this.clone(sourceKB, graph, targetKB, graph);
    }

    public void clone(StoreClientInterface sourceKB, String sourceGraph, StoreClientInterface targetKB, String targetGraph) {
        WhereBuilder whereCountAll = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO);
        this.countTotal = this.countTriples(sourceKB, sourceGraph, whereCountAll);
        if (!this.splitUpdate) {
            this.singleStepClone(sourceKB, sourceGraph, targetKB, targetGraph);
        } else if (this.countTotal <= this.stepSize) {
            this.singleStepClone(sourceKB, sourceGraph, targetKB, targetGraph);
        } else {
            this.performClone(sourceKB, sourceGraph, targetKB, targetGraph);
        }
    }

    public void singleStepClone(StoreClientInterface sourceKB, String sourceGraph, StoreClientInterface targetKB, String targetGraph) {
        Query construct = CloningTool.buildSparqlConstruct(sourceGraph);
        Model results = sourceKB.executeConstruct(construct);
        UpdateRequest update = CloningTool.buildSparqlUpdate(targetGraph, results);
        targetKB.executeUpdate(update);
    }

    private void performClone(StoreClientInterface sourceKB, String sourceGraph, StoreClientInterface targetKB, String targetGraph) {
        this.createTag(sourceKB);
        WhereBuilder whereCount = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addFilter(this.exprFilterOutBlanks());
        int count = this.countTriples(sourceKB, sourceGraph, whereCount);
        int steps = count / this.stepSize;
        if (count % this.stepSize > 0) {
            ++steps;
        }
        for (int i = 0; i < steps; ++i) {
            Expr exprTagN = this.buildExprTagN(i);
            WhereBuilder whereNotTagged = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addFilter(this.exprFilterOutBlanks()).addFilter(this.exprNotTagged()).addBind((Expr)exprFactory.iri((Object)exprFactory.concat(new Object[]{exprStrS, exprTagN})), (Object)newS);
            UpdateRequest tagUpdate = this.buildTagUpdate(sourceGraph, whereNotTagged, this.stepSize, this.quads);
            try {
                sourceKB.executeUpdate(tagUpdate);
            }
            catch (Exception e) {
                if (e.getCause() instanceof SQLException) {
                    throw new JPSRuntimeException("CloningTool: tagging update failed! SourceKB might not be quads. Try setTripleStore().", e);
                }
                throw e;
            }
            WhereBuilder whereConstructTagged = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addFilter((Expr)exprFactory.strends((Object)exprStrS, (Object)exprTagN));
            Query constructQuery = this.buildConstruct(sourceGraph, whereConstructTagged);
            Model triples = sourceKB.executeConstruct(constructQuery);
            WhereBuilder whereRemoveTag = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addBind(this.exprBindIriRemoveTag(exprTagN), (Object)newS);
            UpdateRequest removeTagUpdate = this.buildTagUpdate(null, whereRemoveTag, 0, false);
            Dataset dataset = DatasetFactory.create((Model)triples);
            UpdateProcessor updateExec = UpdateExecutionFactory.create((UpdateRequest)removeTagUpdate, (Dataset)dataset);
            updateExec.execute();
            UpdateRequest update = CloningTool.buildInsert(targetGraph, dataset.getDefaultModel());
            targetKB.executeUpdate(update);
        }
        E_LogicalOr filterTag = exprFactory.or((Object)this.exprNotTagged(), (Object)exprFactory.isBlank((Object)exprS));
        WhereBuilder whereConstruct = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addFilter((Expr)filterTag);
        Query constructQuery = this.buildConstruct(sourceGraph, whereConstruct);
        Model triples = sourceKB.executeConstruct(constructQuery);
        UpdateRequest update = CloningTool.buildInsert(targetGraph, triples);
        targetKB.executeUpdate(update);
        for (int i = 0; i < steps; ++i) {
            Expr exprTagN = this.buildExprTagN(i);
            WhereBuilder whereTagged = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addFilter((Expr)exprFactory.strends((Object)exprStrS, (Object)exprTagN)).addBind(this.exprBindIriRemoveTag(exprTagN), (Object)newS);
            UpdateRequest tagUpdate = this.buildTagUpdate(sourceGraph, whereTagged, this.stepSize, this.quads);
            sourceKB.executeUpdate(tagUpdate);
        }
    }

    private void createTag(StoreClientInterface kbClient) {
        LocalDateTime dateTime = LocalDateTime.now();
        String name = kbClient.getQueryEndpoint() + dateTime.toString();
        int hash = name.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        this.strTag = this.strTag + String.valueOf(hash);
    }

    public boolean checkCount(StoreClientInterface kbClient, String graph) {
        WhereBuilder whereCount = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO);
        int count = this.countTriples(kbClient, graph, whereCount);
        return count == this.countTotal;
    }

    public boolean checkNoTags(StoreClientInterface kbClient, String graph) {
        WhereBuilder whereCount = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO).addFilter(this.exprTagged());
        int count = this.countTriples(kbClient, graph, whereCount);
        return count == 0;
    }

    private int countTriples(StoreClientInterface kbClient, String graph, WhereBuilder where) {
        String query = this.countQuery(graph, where);
        JSONArray result = kbClient.executeQuery(query);
        JSONObject jsonobject = result.getJSONObject(0);
        return jsonobject.getInt(varCount);
    }

    private String countQuery(String graph, WhereBuilder whereFilter) {
        WhereBuilder where = null;
        if (graph != null) {
            where = new WhereBuilder();
            String graphURI = "<" + graph + ">";
            where.addGraph((Object)graphURI, (AbstractQueryBuilder)whereFilter);
        } else {
            where = whereFilter;
        }
        String query = "SELECT (COUNT(*) AS ?" + varCount + ") ";
        query = query + where.toString();
        return query;
    }

    private Query buildConstruct(String graph, WhereBuilder where) {
        ConstructBuilder builder = new ConstructBuilder().addConstruct((Object)varS, (Object)varP, (Object)varO);
        if (graph == null) {
            builder.addWhere((AbstractQueryBuilder)where);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addGraph((Object)graphURI, (AbstractQueryBuilder)where);
        }
        return builder.build();
    }

    private static UpdateRequest buildInsert(String graph, Model triples) {
        UpdateBuilder builder = new UpdateBuilder();
        if (graph == null) {
            builder.addInsert(triples);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addInsert((Object)graphURI, triples);
        }
        return builder.buildRequest();
    }

    private UpdateRequest buildTagUpdate(String graph, WhereBuilder where, int limit, boolean quads) {
        SelectBuilder select = new SelectBuilder();
        select.addVar((Object)varS).addVar((Object)varP).addVar((Object)varO).addVar((Object)newS);
        if (limit > 0) {
            select.setLimit(limit);
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (quads) {
            if (graph == null) {
                select.addVar((Object)varG);
                select.addGraph((Object)varG, (AbstractQueryBuilder)where);
                builder.addInsert((Object)varG, (Object)newS, (Object)varP, (Object)varO).addDelete((Object)varG, (Object)varS, (Object)varP, (Object)varO).addSubQuery((AbstractQueryBuilder)select);
            } else {
                String graphURI = "<" + graph + ">";
                select.addGraph((Object)graphURI, (AbstractQueryBuilder)where);
                builder.addInsert((Object)graphURI, (Object)newS, (Object)varP, (Object)varO).addDelete((Object)graphURI, (Object)varS, (Object)varP, (Object)varO).addSubQuery((AbstractQueryBuilder)select);
            }
        } else {
            select.addWhere((AbstractQueryBuilder)where);
            builder.addInsert((Object)newS, (Object)varP, (Object)varO).addDelete((Object)varS, (Object)varP, (Object)varO).addSubQuery((AbstractQueryBuilder)select);
        }
        return builder.buildRequest();
    }

    private Expr buildExprTagN(int i) {
        return exprFactory.asExpr((Object)("_" + Integer.toString(i) + this.strTag));
    }

    private Expr exprFilterOutBlanks() {
        return exprFactory.and((Object)exprFactory.not((Object)exprFactory.isBlank((Object)exprS)), (Object)exprFactory.and((Object)exprFactory.not((Object)exprFactory.isBlank((Object)exprP)), (Object)exprFactory.not((Object)exprFactory.isBlank((Object)exprO))));
    }

    private Expr exprNotTagged() {
        return exprFactory.not((Object)this.exprTagged());
    }

    private Expr exprTagged() {
        return exprFactory.strends((Object)exprStrS, (Object)this.strTag);
    }

    private Expr exprBindIriRemoveTag(Expr exprTagN) {
        return exprFactory.iri((Object)exprFactory.replace((Object)exprStrS, (Object)exprTagN, (Object)""));
    }

    private static Query buildSparqlConstruct(String graph) {
        ConstructBuilder builder = new ConstructBuilder().addConstruct((Object)varS, (Object)varP, (Object)varO);
        if (graph == null) {
            builder.addWhere((Object)varS, (Object)varP, (Object)varO);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addGraph((Object)graphURI, (Object)varS, (Object)varP, (Object)varO);
        }
        return builder.build();
    }

    private static UpdateRequest buildSparqlUpdate(String graph, Model results) {
        UpdateBuilder builder = new UpdateBuilder();
        if (graph == null) {
            builder.addInsert(results);
        } else {
            String graphURI = "<" + graph + ">";
            builder.addInsert((Object)graphURI, results);
        }
        return builder.buildRequest();
    }
}

