/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.slurm.job;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.slurm.job.Property;
import uk.ac.cam.cares.jps.base.slurm.job.Status;
import uk.ac.cam.cares.jps.base.slurm.job.Workspace;
import uk.ac.cam.cares.jps.base.slurm.job.configuration.SlurmJobProperty;

public class Utils {
    private static Logger LOGGER = LogManager.getLogger(Utils.class);
    public static long previousTimeStamp;
    protected static boolean isStatusFileOpen;

    public static long getTimeStamp() {
        long currentTimeStamp = System.nanoTime();
        while (currentTimeStamp <= previousTimeStamp) {
            currentTimeStamp = System.nanoTime();
        }
        previousTimeStamp = currentTimeStamp;
        return currentTimeStamp;
    }

    public static BufferedWriter openBufferedWriter(String filePathPlusName) throws IOException {
        return new BufferedWriter(new FileWriter(filePathPlusName));
    }

    public static BufferedReader openSourceFile(String filePathPlusName) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePathPlusName), "UTF-8"));
    }

    public static boolean isJobCompleted(File jobFolder) throws IOException {
        return Utils.isJobFinished(jobFolder, jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()));
    }

    public static boolean isJobCompleted(File jobFolder, SlurmJobProperty slurmJobProperty) throws IOException {
        boolean status = false;
        try {
            status = Utils.isJobFinished(jobFolder, jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()), slurmJobProperty);
        }
        catch (Exception e) {
            LOGGER.info("SlurmJobAPI: failed to check the status of the job with ID " + jobFolder.getName());
        }
        return status;
    }

    public static boolean isJobErroneouslyCompleted(File jobFolder) throws IOException {
        return Utils.isJobErroneouslyCompleted(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()));
    }

    public static boolean isJobRunning(File jobFolder) throws IOException {
        boolean status = false;
        try {
            status = Utils.isJobRunning(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()));
        }
        catch (Exception e) {
            LOGGER.info("SlurmJobAPI: failed to check the status of the job with ID " + jobFolder.getName());
        }
        return status;
    }

    public static boolean isJobNotStarted(File jobFolder) throws IOException {
        return Utils.isJobNotStarted(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()));
    }

    public static boolean isJobFinished(File jobFolder, String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName())) continue;
            if (line.contains(Status.STATUS_JOB_COMPLETED.getName())) {
                statusFile.close();
                return true;
            }
            if (!line.contains(Status.STATUS_JOB_ERROR_TERMINATED.getName())) continue;
            statusFile.close();
            return true;
        }
        statusFile.close();
        return false;
    }

    public static boolean isJobFinished(File jobFolder, String statusFilePath, SlurmJobProperty slurmJobProperty) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName())) continue;
            if (line.contains(Status.STATUS_JOB_COMPLETED.getName())) {
                statusFile.close();
                if (Utils.isJobPostProcessed(jobFolder, statusFilePath)) {
                    Utils.moveToCompletedJobsFolder(jobFolder, slurmJobProperty);
                }
                return true;
            }
            if (!line.contains(Status.STATUS_JOB_ERROR_TERMINATED.getName())) continue;
            statusFile.close();
            Utils.moveToFailedJobsFolder(jobFolder, slurmJobProperty);
            return true;
        }
        statusFile.close();
        return false;
    }

    public static boolean isJobPostProcessed(File jobFolder, String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_OUTPUT.getName()) || !line.contains(Status.OUTPUT_PROCESSED.getName())) continue;
            statusFile.close();
            return true;
        }
        statusFile.close();
        return false;
    }

    public static boolean isJobErroneouslyCompleted(String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName()) || !line.contains(Status.STATUS_JOB_ERROR_TERMINATED.getName())) continue;
            statusFile.close();
            return true;
        }
        statusFile.close();
        return false;
    }

    public static boolean isJobOutputProcessed(File jobFolder) throws IOException {
        return Utils.isJobOutputProcessed(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()));
    }

    public static boolean isJobOutputProcessed(String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_OUTPUT.getName()) || !line.contains(Status.OUTPUT_PROCESSED.getName())) continue;
            statusFile.close();
            return true;
        }
        statusFile.close();
        return false;
    }

    public static boolean isJobRunning(String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName()) || !line.contains(Status.STATUS_JOB_RUNNING.getName()) && !line.contains(Status.STATUS_JOB_COMPLETING.getName()) && !line.contains(Status.STATUS_JOB_PENDING.getName())) continue;
            statusFile.close();
            return true;
        }
        statusFile.close();
        return false;
    }

    public static boolean isJobNotStarted(String statusFilePath) throws IOException {
        String line;
        if (isStatusFileOpen) {
            return false;
        }
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        isStatusFileOpen = true;
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName()) || !line.contains(Status.STATUS_JOB_NOT_STARTED.getName())) continue;
            statusFile.close();
            isStatusFileOpen = false;
            return true;
        }
        statusFile.close();
        isStatusFileOpen = false;
        return false;
    }

    public static String getJobId(String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            String[] tokens;
            if (!line.trim().toLowerCase().startsWith(Status.ATTRIBUTE_JOB_ID.getName().toLowerCase()) || (tokens = line.trim().split(":")).length < 2 || tokens[1].trim().length() <= 0) continue;
            statusFile.close();
            return tokens[1].trim();
        }
        statusFile.close();
        return null;
    }

    public static void addJobId(String filePath, String jobId) throws IOException {
        String line;
        ArrayList<String> fileContent = new ArrayList<String>();
        BufferedReader br = Utils.openSourceFile(filePath);
        while ((line = br.readLine()) != null) {
            if (line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName())) {
                line = Status.ATTRIBUTE_JOB_STATUS.getName().concat(" ").concat(Status.STATUS_JOB_RUNNING.getName());
            }
            if (line.trim().startsWith(Status.ATTRIBUTE_JOB_ID.getName())) {
                line = Status.ATTRIBUTE_JOB_ID.getName().concat(" ").concat(jobId);
            }
            fileContent.add(line);
        }
        br.close();
        BufferedWriter bw = Utils.openBufferedWriter(filePath);
        for (String lineContent : fileContent) {
            bw.write(lineContent.concat("\n"));
        }
        bw.flush();
        bw.close();
    }

    public static void modifyStatus(String filePath, String status) throws IOException {
        String line;
        ArrayList<String> fileContent = new ArrayList<String>();
        BufferedReader br = Utils.openSourceFile(filePath);
        while ((line = br.readLine()) != null) {
            if (line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName())) {
                line = Status.ATTRIBUTE_JOB_STATUS.getName().concat(" ").concat(status);
            }
            fileContent.add(line);
        }
        br.close();
        BufferedWriter bw = Utils.openBufferedWriter(filePath);
        for (String lineContent : fileContent) {
            bw.write(lineContent.concat("\n"));
        }
        bw.flush();
        bw.close();
    }

    public static File getStatusFile(File jobFolder) {
        if (jobFolder.isDirectory() && new File(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName())).isFile()) {
            return new File(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName()));
        }
        return null;
    }

    public static String getLogFilePathOnHPC(String runningJob, String userName, File taskSpace, String hpcAddress) throws UnknownHostException {
        String jobFolderOnHPC = runningJob.replace(hpcAddress, Utils.getMachineAddress());
        String logFilePath = Utils.getJobFolderPathOnHPC(runningJob, userName, taskSpace, hpcAddress).concat("/").concat(jobFolderOnHPC).concat(Status.EXTENSION_LOG_FILE.getName());
        return logFilePath;
    }

    public static String getOutputFilePathOnHPC(String runningJob, String userName, File taskSpace, String hpcAddress, String outputFileNameWithExtension) throws UnknownHostException {
        String outputFilePath = Utils.getJobFolderPathOnHPC(runningJob, userName, taskSpace, hpcAddress).concat("/").concat(outputFileNameWithExtension);
        return outputFilePath;
    }

    public static String getJobFolderPathOnHPC(String runningJob, String userName, File taskSpace, String hpcAddress) throws UnknownHostException {
        String jobFolderOnHPC = runningJob.replace(hpcAddress, Utils.getMachineAddress());
        String jobFolderPath = "/home/".concat(userName).concat("/").concat(taskSpace.getName()).concat("/").concat(jobFolderOnHPC);
        return jobFolderPath;
    }

    public static String getJobOutputFilePathOnAgentPC(String runningJob, File taskSpace, String outputFileName, String outputFileExtension) {
        return taskSpace.getAbsolutePath().concat(File.separator).concat(runningJob).concat(File.separator).concat(outputFileName).concat(outputFileExtension);
    }

    public static boolean isErrorTermination(String logFileOnAgentPC) throws IOException {
        String line;
        BufferedReader logFile = Utils.openSourceFile(logFileOnAgentPC);
        while ((line = logFile.readLine()) != null) {
            if (!line.trim().toLowerCase().startsWith(Status.JOB_LOG_MSG_ERROR_TERMINATION.getName().toLowerCase())) continue;
            logFile.close();
            return true;
        }
        logFile.close();
        return false;
    }

    public static String getMachineAddress() throws UnknownHostException {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.toString().replace("/", "_");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            LOGGER.error("SlurmJobAPI: The host address is unknown as InetAddress.getLocalHost() threw an exception.");
            return null;
        }
    }

    public static void translateLineEndingIntoUnix(File file) throws IOException {
        File recreatedFile = new File(System.getProperty("user.home").replace("\\", "/").concat("/").concat(file.getName()));
        Utils.copyModifiedContentForUnix(file, recreatedFile);
        Utils.copyModifiedContentForUnix(recreatedFile, file);
    }

    private static void copyModifiedContentForUnix(File source, File destination) throws IOException {
        String line;
        BufferedReader receivedFile = Utils.openSourceFile(source.getAbsolutePath());
        BufferedWriter recreatedFile = Utils.openBufferedWriter(destination.getAbsolutePath());
        while ((line = receivedFile.readLine()) != null) {
            recreatedFile.write(line.concat("\n"));
        }
        recreatedFile.close();
        receivedFile.close();
    }

    public static void moveToCompletedJobsFolder(File jobFolder, SlurmJobProperty slurmJobProperty) {
        try {
            File destDir = Utils.getCompletedJobsDirectory(jobFolder, slurmJobProperty);
            if (destDir != null) {
                FileUtils.copyDirectory((File)jobFolder, (File)destDir);
                FileUtils.deleteDirectory((File)jobFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getCompletedJobsDirectory(File jobFolder, SlurmJobProperty slurmJobProperty) throws IOException {
        File workspace = Workspace.getWorkspace(Property.JOB_WORKSPACE_PARENT_DIR.getPropertyName(), slurmJobProperty.getAgentClass());
        String completedJobsDirectory = Property.JOB_WORKSPACE_PARENT_DIR.getPropertyName().concat(File.separator).concat(slurmJobProperty.getAgentCompletedJobsSpacePrefix()).concat(workspace.getName()).concat(File.separator).concat(jobFolder.getName());
        File jobFolderInCompletedJobs = new File(completedJobsDirectory);
        jobFolderInCompletedJobs.mkdirs();
        if (jobFolderInCompletedJobs.exists()) {
            return jobFolderInCompletedJobs;
        }
        return null;
    }

    public static void moveToFailedJobsFolder(File jobFolder, SlurmJobProperty slurmJobProperty) {
        try {
            File destDir = Utils.getFailedJobsDirectory(jobFolder, slurmJobProperty);
            if (destDir != null) {
                FileUtils.copyDirectory((File)jobFolder, (File)destDir);
                FileUtils.deleteDirectory((File)jobFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getFailedJobsDirectory(File jobFolder, SlurmJobProperty slurmJobProperty) throws IOException {
        File workspace = Workspace.getWorkspace(Property.JOB_WORKSPACE_PARENT_DIR.getPropertyName(), slurmJobProperty.getAgentClass());
        String failedJobsDirectory = Property.JOB_WORKSPACE_PARENT_DIR.getPropertyName().concat(File.separator).concat(slurmJobProperty.getAgentFailedJobsSpacePrefix()).concat(workspace.getName()).concat(File.separator).concat(jobFolder.getName());
        File jobFolderInFailedJobs = new File(failedJobsDirectory);
        jobFolderInFailedJobs.mkdirs();
        if (jobFolderInFailedJobs.exists()) {
            return jobFolderInFailedJobs;
        }
        return null;
    }

    static {
        isStatusFileOpen = false;
    }
}

