/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.sparql;

import java.util.HashMap;
import java.util.Map;
import uk.ac.cam.cares.jps.base.query.sparql.Prefixes;

public class PrefixToUrlMap
implements Prefixes {
    private static PrefixToUrlMap instance;
    private Map<String, String> mapPrefixToUrl = new HashMap<String, String>();

    private PrefixToUrlMap() {
    }

    public static synchronized PrefixToUrlMap getInstance() {
        if (instance == null) {
            instance = new PrefixToUrlMap();
            instance.init();
        }
        return instance;
    }

    private synchronized void init() {
        this.mapPrefixToUrl.put("dbpediao", "http://dbpedia.org/ontology/");
        this.mapPrefixToUrl.put("dbpediap", "http://dbpedia.org/property/");
        this.mapPrefixToUrl.put("dbpediar", "http://dbpedia.org/resource/");
        this.mapPrefixToUrl.put("dc", "http://purl.org/dc/elements/1.1/");
        this.mapPrefixToUrl.put("dcam", "http://purl.org/dc/dcam/");
        this.mapPrefixToUrl.put("dcterms", "http://purl.org/dc/terms/");
        this.mapPrefixToUrl.put("foaf", "http://xmlns.com/foaf/0.1/");
        this.mapPrefixToUrl.put("owl", "http://www.w3.org/2002/07/owl#");
        this.mapPrefixToUrl.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.mapPrefixToUrl.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.mapPrefixToUrl.put("skos", "http://www.w3.org/2004/02/skos/core#");
        this.mapPrefixToUrl.put("time", "https://www.w3.org/2006/time#");
        this.mapPrefixToUrl.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.mapPrefixToUrl.put("OCPBEHA", "http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#");
        this.mapPrefixToUrl.put("OCPGEOM", "http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/geometry/geometry.owl#");
        this.mapPrefixToUrl.put("OCPMATE", "http://www.theworldavatar.com/ontology/ontocape/material/material.owl#");
        this.mapPrefixToUrl.put("OCPMATH", "http://www.theworldavatar.com/ontology/ontocape/model/mathematical_model.owl#");
        this.mapPrefixToUrl.put("OCPPHAS", "http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#");
        this.mapPrefixToUrl.put("OCPSPAC", "http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/space_and_time/space_and_time_extended.owl#");
        this.mapPrefixToUrl.put("OCPSYST", "http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#");
        this.mapPrefixToUrl.put("OCPTECH", "http://www.theworldavatar.com/ontology/ontocape/upper_level/technical_system.owl#");
        this.mapPrefixToUrl.put("OCPTOPO", "http://www.theworldavatar.com/ontology/meta_model/topology/topology.owl#");
        this.mapPrefixToUrl.put("OPSBEHA", "http://www.theworldavatar.com/ontology/ontopowsys/PowSysBehavior.owl#");
        this.mapPrefixToUrl.put("OPSMODE", "http://www.theworldavatar.com/ontology/ontopowsys/model/PowerSystemModel.owl#");
        this.mapPrefixToUrl.put("OPSREAL", "http://www.theworldavatar.com/ontology/ontopowsys/PowSysRealization.owl#");
        this.mapPrefixToUrl.put("JPSAGEN", "http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#");
        this.mapPrefixToUrl.put("JPSLAND", "http://www.theworldavatar.com/ontology/ontoland/OntoLand.owl#");
    }

    public static String getPrefixUrl(String prefix) {
        return PrefixToUrlMap.getInstance().mapPrefixToUrl.get(prefix);
    }

    public static String getPrefixForSPARQL(String prefix) {
        return "PREFIX " + prefix + ":<" + PrefixToUrlMap.getPrefixUrl(prefix) + "> \r\n";
    }
}

