/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.discovery;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.config.AgentLocator;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.util.InputValidator;

public class AgentCaller {
    private static final Logger LOGGER = LogManager.getLogger(AgentCaller.class);
    private static final String JSON_PARAMETER_KEY = "query";
    private static String hostPort = null;

    private static synchronized String getHostPort() {
        if (hostPort == null) {
            hostPort = AgentLocator.getProperty("host") + ":" + AgentLocator.getProperty("port");
        }
        return hostPort;
    }

    public static String executeGet(String path) {
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        try {
            HttpGet request = new HttpGet(builder.build());
            return AgentCaller.executeGet(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static String executeGet(String path, String ... keyOrValue) {
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        for (int i = 0; i < keyOrValue.length; i += 2) {
            String key = keyOrValue[i];
            String value = keyOrValue[i + 1];
            builder.setParameter(key, value);
        }
        try {
            HttpGet request = new HttpGet(builder.build());
            return AgentCaller.executeGet(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static String executePost(String path, String body) {
        String response_body;
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(builder.build());
            request.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new JPSRuntimeException(response.getStatusLine().toString());
            }
            HttpEntity rsp_entity = response.getEntity();
            response_body = EntityUtils.toString((HttpEntity)rsp_entity, (String)"UTF-8");
        }
        catch (IOException | URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return response_body;
    }

    public static String executePut(String path, String body) {
        return AgentCaller.executePut(path, body, null);
    }

    public static String executePut(String path, String body, String jsonParam) {
        String response_body;
        URIBuilder builder = AgentCaller.getUriBuilderForPath(path);
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        if (jsonParam != null) {
            builder.setParameter(JSON_PARAMETER_KEY, jsonParam);
        }
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPut request = new HttpPut(builder.build());
            request.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new JPSRuntimeException(response.getStatusLine().toString());
            }
            HttpEntity rsp_entity = response.getEntity();
            response_body = EntityUtils.toString((HttpEntity)rsp_entity, (String)"UTF-8");
        }
        catch (IOException | URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return response_body;
    }

    private static URIBuilder getUriBuilderForPath(String path) {
        URIBuilder builder;
        try {
            builder = new URIBuilder(AgentCaller.createURI(path, new String[0]));
        }
        catch (Exception e) {
            builder = new URIBuilder().setScheme("http").setHost(AgentCaller.getHostPort()).setPath(path);
        }
        return builder;
    }

    public static String executeGetWithURL(String url) {
        URI uri = AgentCaller.createURI(url, new String[0]);
        HttpGet request = new HttpGet(uri);
        return AgentCaller.executeGet(request);
    }

    public static String executeGetWithURLAndJSON(String url, String json) {
        URI uri = AgentCaller.createURIWithURLandJSON(url, json);
        HttpGet request = new HttpGet(uri);
        LOGGER.info("REQUEST HERE= " + request);
        return AgentCaller.executeGet(request);
    }

    public static URI createURIWithURLandJSON(String url, String json) {
        return AgentCaller.createURI(url, JSON_PARAMETER_KEY, json);
    }

    public static URI createURI(String url, String ... keyOrValue) {
        int j = url.indexOf(58);
        String scheme = url.substring(0, j);
        URIBuilder builder = new URIBuilder().setScheme(scheme);
        url = url.substring(j + 3);
        j = url.indexOf(47);
        String path = url.substring(j);
        builder.setPath(path);
        String host = url.substring(0, j);
        j = host.indexOf(58);
        if (j == -1) {
            builder.setHost(host);
        } else {
            String[] split = host.split(":");
            builder.setHost(split[0]);
            int port = Integer.valueOf(split[1]);
            builder.setPort(port);
        }
        if (!ArrayUtils.isEmpty((Object[])keyOrValue)) {
            for (int i = 0; i < keyOrValue.length; i += 2) {
                String key = keyOrValue[i];
                String value = keyOrValue[i + 1];
                builder.setParameter(key, value);
            }
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static String executeGetWithURLKey(String urlKey, MediaType type, String ... keyOrValue) {
        String url = KeyValueManager.get(urlKey);
        URI uri = AgentCaller.createURI(url, keyOrValue);
        HttpGet request = new HttpGet(uri);
        if (type != null) {
            request.setHeader("Accept", type.type);
        }
        return AgentCaller.executeGet(request);
    }

    public static String executeGetWithJsonParameter(String path, String json) {
        URIBuilder builder = new URIBuilder().setScheme("http").setHost(AgentCaller.getHostPort()).setPath(path);
        builder.setParameter(JSON_PARAMETER_KEY, json);
        try {
            HttpGet request = new HttpGet(builder.build());
            request.setHeader("Accept", "application/json");
            request.setHeader("Content-type", "application/json");
            return AgentCaller.executeGet(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static JSONObject readJsonParameter(HttpServletRequest request) {
        try {
            String json = null;
            if (request.getMethod().equals("GET") && (json = request.getParameter(JSON_PARAMETER_KEY)) != null) {
                JSONObject jo = new JSONObject();
                if (InputValidator.checkIfValidJSONObject(json)) {
                    jo = new JSONObject(json);
                } else {
                    jo.put("body", (Object)json);
                }
                jo.put("acceptHeaders", (Object)AgentCaller.getAccept(request)).put("method", (Object)request.getMethod()).put("path", (Object)request.getPathInfo()).put("contentType", (Object)request.getContentType()).put("requestUrl", (Object)request.getRequestURL().toString());
                return jo;
            }
            JSONObject jsonobject = Http.readJsonParameter(request);
            if (request.getMethod().equals("PUT") || request.getMethod().equals("POST")) {
                JSONObject jo;
                json = IOUtils.toString((Reader)request.getReader());
                String json2 = request.getParameter(JSON_PARAMETER_KEY);
                if (json2 != null) {
                    jo = new JSONObject(json2);
                    for (String key : JSONObject.getNames((JSONObject)jo)) {
                        jsonobject.put(key, jo.get(key));
                    }
                }
                if (InputValidator.checkIfValidJSONObject(json)) {
                    jo = new JSONObject(json);
                    for (String key : JSONObject.getNames((JSONObject)jo)) {
                        jsonobject.put(key, jo.get(key));
                    }
                }
            }
            jsonobject.put("method", (Object)request.getMethod()).put("acceptHeaders", (Object)AgentCaller.getAccept(request)).put("body", (Object)json).put("path", (Object)request.getPathInfo()).put("contentType", (Object)request.getContentType()).put("requestUrl", (Object)request.getRequestURL().toString());
            return jsonobject;
        }
        catch (IOException | JSONException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    protected static String getAccept(HttpServletRequest req) {
        String accept = null;
        Enumeration acceptList = req.getHeaders("Accept");
        if (acceptList.hasMoreElements()) {
            accept = (String)acceptList.nextElement();
        }
        LOGGER.info("accept = " + accept);
        return accept;
    }

    public static void writeJsonParameter(HttpServletResponse response, JSONObject json) throws IOException {
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        String message = json.toString();
        out.print(message);
    }

    public static String executeGet(HttpGet request) {
        CloseableHttpResponse httpResponse = null;
        try {
            StringBuffer buf = new StringBuffer(request.getMethod()).append(" ").append(request.getURI().getScheme()).append("://").append(request.getURI().getHost());
            int port = request.getURI().getPort();
            if (port > -1) {
                buf.append(":").append(request.getURI().getPort());
            }
            buf.append(request.getURI().getPath());
            String requestAsString = buf.toString();
            String query = request.getURI().getQuery();
            if (query != null) {
                int length = query.length();
                if (length > 100) {
                    query = query.substring(0, 99);
                }
                buf.append("?").append(query);
            }
            LOGGER.info(buf.toString());
            httpResponse = HttpClientBuilder.create().build().execute((HttpUriRequest)request);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                LOGGER.error(body);
                String message = "original request = " + requestAsString;
                if (request.getURI().getQuery() != null) {
                    message = message + "?" + request.getURI().getQuery();
                }
                LOGGER.info(message);
                throw new JPSRuntimeException("HTTP response with error = " + httpResponse.getStatusLine() + ", " + message);
            }
            String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            LOGGER.debug(body);
            String string = body;
            return string;
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String getRequestBody(String url) {
        try {
            URL urlForGetRequest = new URL(url);
            HttpURLConnection conection = (HttpURLConnection)urlForGetRequest.openConnection();
            conection.setRequestMethod("GET");
            String readLine = null;
            int responseCode = conection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(conection.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((readLine = in.readLine()) != null) {
                    response.append(readLine);
                }
                in.close();
                return response.toString();
            }
            throw new JPSRuntimeException("Failure to connect");
        }
        catch (MalformedURLException e) {
            throw new JPSRuntimeException("Malformed URL " + url + "; try again.");
        }
        catch (ProtocolException e) {
            throw new JPSRuntimeException("Protocol Exception " + url + "; try again.");
        }
        catch (IOException e) {
            throw new JPSRuntimeException("IO Exception " + url + "; try again.");
        }
    }

    public static void printToResponse(Object object, HttpServletResponse resp) {
        if (object == null) {
            return;
        }
        String message = AgentCaller.serializeForResponse(object);
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        try {
            resp.getWriter().print(message);
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static String serializeForResponse(Object object) {
        String message = null;
        message = object instanceof String ? (String)object : (object instanceof JSONObject || object instanceof JSONArray ? object.toString() : new Gson().toJson(object));
        return message;
    }

    public static String encodePercentage(String s) {
        Charset charset = Charset.forName("UTF-8");
        List<BasicNameValuePair> params = Arrays.asList(new BasicNameValuePair(JSON_PARAMETER_KEY, s));
        String encoded = URLEncodedUtils.format(params, (Charset)charset);
        return encoded.substring(6);
    }

    public static String decodePercentage(String s) {
        Charset charset = Charset.forName("UTF-8");
        List pair = URLEncodedUtils.parse((String)("query=" + s), (Charset)charset);
        return ((NameValuePair)pair.get(0)).getValue();
    }
}

