/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Operand;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.PropertyPaths;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.ModifyQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatternNotTriples;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.SubSelect;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.json.JSONArray;
import org.json.JSONException;
import uk.ac.cam.cares.jps.base.derivation.ValuesPattern;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class DerivationSparql {
    private StoreClientInterface storeClient;
    public static String derivednamespace = "https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontoderivation/OntoDerivation.owl#";
    private static Prefix p_agent = SparqlBuilder.prefix((String)"agent", (Iri)Rdf.iri((String)"http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#"));
    private static Prefix p_derived = SparqlBuilder.prefix((String)"derived", (Iri)Rdf.iri((String)derivednamespace));
    private static Prefix p_time = SparqlBuilder.prefix((String)"time", (Iri)Rdf.iri((String)"http://www.w3.org/2006/time#"));
    private static Iri Service = p_agent.iri("Service");
    private static Iri Operation = p_agent.iri("Operation");
    private static Iri TimePosition = p_time.iri("TimePosition");
    private static Iri Derivation = p_derived.iri("Derivation");
    private static Iri DerivationWithTimeSeries = p_derived.iri("DerivationWithTimeSeries");
    private static Iri InstantClass = p_time.iri("Instant");
    private static Iri hasHttpUrl = p_agent.iri("hasHttpUrl");
    private static Iri hasOperation = p_agent.iri("hasOperation");
    private static Iri isDerivedFrom = p_derived.iri("isDerivedFrom");
    private static Iri isDerivedUsing = p_derived.iri("isDerivedUsing");
    private static Iri belongsTo = p_derived.iri("belongsTo");
    private static Iri hasTime = p_time.iri("hasTime");
    private static Iri numericPosition = p_time.iri("numericPosition");
    private static Iri hasTRS = p_time.iri("hasTRS");
    private static Iri inTimePosition = p_time.iri("inTimePosition");
    private static List<Iri> classesToIgnore = Arrays.asList(Rdf.iri((IRI)OWL.THING), Rdf.iri((IRI)OWL.NAMEDINDIVIDUAL));
    private static final Logger LOGGER = LogManager.getLogger(DerivationSparql.class);

    public DerivationSparql(StoreClientInterface storeClient) {
        this.storeClient = storeClient;
    }

    String createDerivation(List<String> entities, String agentIRI, String agentURL, List<String> inputs) {
        ModifyQuery modify = Queries.MODIFY();
        String derivedQuantity = derivednamespace + "derived" + UUID.randomUUID().toString();
        while (this.checkInstanceExists(derivedQuantity)) {
            derivedQuantity = derivednamespace + "derived" + UUID.randomUUID().toString();
        }
        Iri derived_iri = Rdf.iri((String)derivedQuantity);
        modify.insert(new TriplePattern[]{derived_iri.isA(new RdfObject[]{Derivation})});
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(new TriplePattern[]{Rdf.iri((String)entity).has((RdfPredicate)belongsTo, new RdfObject[]{derived_iri})});
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        modify.insert(new TriplePattern[]{derived_iri.has((RdfPredicate)isDerivedUsing, new RdfObject[]{Rdf.iri((String)agentIRI)})});
        String operation_iri = derivednamespace + UUID.randomUUID().toString();
        modify.insert(new TriplePattern[]{Rdf.iri((String)agentIRI).isA(new RdfObject[]{Service}).andHas((RdfPredicate)hasOperation, new RdfObject[]{Rdf.iri((String)operation_iri)})});
        modify.insert(new TriplePattern[]{Rdf.iri((String)operation_iri).isA(new RdfObject[]{Operation}).andHas((RdfPredicate)hasHttpUrl, new RdfObject[]{Rdf.iri((String)agentURL)})});
        for (String input : inputs) {
            modify.insert(new TriplePattern[]{derived_iri.has((RdfPredicate)isDerivedFrom, new RdfObject[]{Rdf.iri((String)input)})});
        }
        modify.prefix(new Prefix[]{p_time, p_derived, p_agent});
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(new Prefix[]{p_time, p_derived, p_agent})).getQueryString());
        this.storeClient.executeUpdate();
        return derivedQuantity;
    }

    String createDerivationWithTimeSeries(List<String> entities, String agentIRI, String agentURL, List<String> inputs) {
        ModifyQuery modify = Queries.MODIFY();
        String derivedQuantity = derivednamespace + "derived" + UUID.randomUUID().toString();
        while (this.checkInstanceExists(derivedQuantity)) {
            derivedQuantity = derivednamespace + "derived" + UUID.randomUUID().toString();
        }
        Iri derived_iri = Rdf.iri((String)derivedQuantity);
        modify.insert(new TriplePattern[]{derived_iri.isA(new RdfObject[]{DerivationWithTimeSeries})});
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(new TriplePattern[]{Rdf.iri((String)entity).has((RdfPredicate)belongsTo, new RdfObject[]{derived_iri})});
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        modify.insert(new TriplePattern[]{derived_iri.has((RdfPredicate)isDerivedUsing, new RdfObject[]{Rdf.iri((String)agentIRI)})});
        String operation_iri = derivednamespace + UUID.randomUUID().toString();
        modify.insert(new TriplePattern[]{Rdf.iri((String)agentIRI).isA(new RdfObject[]{Service}).andHas((RdfPredicate)hasOperation, new RdfObject[]{Rdf.iri((String)operation_iri)})});
        modify.insert(new TriplePattern[]{Rdf.iri((String)operation_iri).isA(new RdfObject[]{Operation}).andHas((RdfPredicate)hasHttpUrl, new RdfObject[]{Rdf.iri((String)agentURL)})});
        for (String input : inputs) {
            modify.insert(new TriplePattern[]{derived_iri.has((RdfPredicate)isDerivedFrom, new RdfObject[]{Rdf.iri((String)input)})});
        }
        modify.prefix(new Prefix[]{p_time, p_derived, p_agent});
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(new Prefix[]{p_time, p_derived, p_agent})).getQueryString());
        this.storeClient.executeUpdate();
        return derivedQuantity;
    }

    boolean hasBelongsTo(String entity) {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        TriplePattern queryPattern = Rdf.iri((String)entity).has((RdfPredicate)belongsTo, new RdfObject[]{query.var()});
        ((SelectQuery)query.prefix(new Prefix[]{p_derived})).where(new GraphPattern[]{queryPattern});
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        return !queryResult.isEmpty();
    }

    private boolean checkInstanceExists(String instance) {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        GraphPatternNotTriples queryPattern = GraphPatterns.and((GraphPattern[])new GraphPattern[]{Rdf.iri((String)instance).has((RdfPredicate)query.var(), new RdfObject[]{query.var()}).optional(), query.var().has((RdfPredicate)query.var(), new RdfObject[]{Rdf.iri((String)instance)}).optional()});
        query.where(new GraphPattern[]{queryPattern});
        JSONArray queryresult = this.storeClient.executeQuery(query.getQueryString());
        return !queryresult.getJSONObject(0).isEmpty();
    }

    void addTimeInstance(String entity) {
        ModifyQuery modify = Queries.MODIFY();
        String time_instant = derivednamespace + "time" + UUID.randomUUID().toString();
        String time_unix = derivednamespace + "time" + UUID.randomUUID().toString();
        long timestamp = 0L;
        Iri time_instant_iri = Rdf.iri((String)time_instant);
        Iri time_unix_iri = Rdf.iri((String)time_unix);
        modify.insert(new TriplePattern[]{Rdf.iri((String)entity).has((RdfPredicate)hasTime, new RdfObject[]{time_instant_iri})});
        modify.insert(new TriplePattern[]{time_instant_iri.isA(new RdfObject[]{InstantClass}).andHas((RdfPredicate)inTimePosition, new RdfObject[]{time_unix_iri})});
        modify.insert(new TriplePattern[]{time_unix_iri.isA(new RdfObject[]{TimePosition}).andHas((RdfPredicate)numericPosition, new Number[]{timestamp}).andHas((RdfPredicate)hasTRS, new RdfObject[]{Rdf.iri((String)"http://dbpedia.org/resource/Unix_time")})});
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(new Prefix[]{p_time})).getQueryString());
        this.storeClient.executeUpdate();
    }

    void removeTimeInstance(String entity) {
        ModifyQuery modify = Queries.MODIFY();
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable time_instant = query.var();
        Variable time_unix = query.var();
        Variable timestamp = query.var();
        Variable TRS = query.var();
        TriplePattern[] queryPattern = new TriplePattern[]{Rdf.iri((String)entity).has((RdfPredicate)hasTime, new RdfObject[]{time_instant}), time_instant.isA(new RdfObject[]{InstantClass}).andHas((RdfPredicate)inTimePosition, new RdfObject[]{time_unix}), time_unix.isA(new RdfObject[]{TimePosition}).andHas((RdfPredicate)numericPosition, new RdfObject[]{timestamp}).andHas((RdfPredicate)hasTRS, new RdfObject[]{TRS})};
        modify.delete(queryPattern).where((GraphPattern[])queryPattern).prefix(new Prefix[]{p_time});
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    String getAgentUrl(String derivedQuantity) {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        String queryKey = "url";
        Variable url = SparqlBuilder.var((String)queryKey);
        Iri derivedQuantityIRI = Rdf.iri((String)derivedQuantity);
        TriplePattern queryPattern = derivedQuantityIRI.has(PropertyPaths.path((RdfPredicate[])new RdfPredicate[]{isDerivedUsing, hasOperation, hasHttpUrl}), new RdfObject[]{url});
        ((SelectQuery)query.select(new Projectable[]{url}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{p_agent, p_derived});
        this.storeClient.setQuery(query.getQueryString());
        String queryResult = this.storeClient.executeQuery().getJSONObject(0).getString(queryKey);
        return queryResult;
    }

    List<String> getInputs(String derivedQuantity) {
        String queryKey = "input";
        Variable input = SparqlBuilder.var((String)queryKey);
        TriplePattern queryPattern = Rdf.iri((String)derivedQuantity).has((RdfPredicate)isDerivedFrom, new RdfObject[]{input});
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        ((SelectQuery)((SelectQuery)query.prefix(new Prefix[]{p_derived})).where(new GraphPattern[]{queryPattern})).select(new Projectable[]{input});
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        ArrayList<String> inputs = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            inputs.add(queryResult.getJSONObject(i).getString(queryKey));
        }
        return inputs;
    }

    List<String> getInputsAndDerived(String derived) {
        String inputQueryKey = "input";
        String derivedQueryKey = "derived";
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable input = SparqlBuilder.var((String)inputQueryKey);
        Variable derivedOfInput = SparqlBuilder.var((String)derivedQueryKey);
        GraphPatternNotTriples inputPattern = GraphPatterns.and((GraphPattern[])new GraphPattern[]{Rdf.iri((String)derived).has((RdfPredicate)isDerivedFrom, new RdfObject[]{input})});
        GraphPattern derivedPattern = input.has((RdfPredicate)belongsTo, new RdfObject[]{derivedOfInput}).optional();
        ((SelectQuery)((SelectQuery)query.prefix(new Prefix[]{p_derived})).where(new GraphPattern[]{inputPattern, derivedPattern})).select(new Projectable[]{input, derivedOfInput});
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        ArrayList<String> inputsAndDerived = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            String derivedIRI = queryResult.getJSONObject(i).optString(derivedQueryKey);
            if (derivedIRI.length() > 0) {
                inputsAndDerived.add(derivedIRI);
                continue;
            }
            inputsAndDerived.add(queryResult.getJSONObject(i).getString(inputQueryKey));
        }
        return inputsAndDerived;
    }

    String getDerivedIRI(String instance) {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        String queryKey = "derived";
        Variable derived = SparqlBuilder.var((String)queryKey);
        TriplePattern queryPattern = Rdf.iri((String)instance).has((RdfPredicate)belongsTo, new RdfObject[]{derived});
        ((SelectQuery)query.prefix(new Prefix[]{p_derived})).select(new Projectable[]{derived}).where(new GraphPattern[]{queryPattern});
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        if (queryResult.length() != 1) {
            throw new JPSRuntimeException(instance + " linked with " + String.valueOf(queryResult.length()) + " derived instances");
        }
        return queryResult.getJSONObject(0).getString(queryKey);
    }

    List<String> getDerivedEntities(String derivedIRI) {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        String queryKey = "entity";
        Variable entity = SparqlBuilder.var((String)queryKey);
        TriplePattern queryPattern = entity.has((RdfPredicate)belongsTo, new RdfObject[]{Rdf.iri((String)derivedIRI)});
        ((SelectQuery)query.prefix(new Prefix[]{p_derived})).select(new Projectable[]{entity}).where(new GraphPattern[]{queryPattern});
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        ArrayList<String> entities = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            entities.add(queryResult.getJSONObject(i).getString(queryKey));
        }
        return entities;
    }

    List<List<String>> getIsDerivedFromEntities(List<String> entities) {
        String derivedkey = "derived";
        String typeKey = "type";
        Variable derived = SparqlBuilder.var((String)derivedkey);
        Variable entityType = SparqlBuilder.var((String)typeKey);
        Expression[] filters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            filters[j] = Expressions.notEquals((Operand)entityType, (Operand)((Operand)classesToIgnore.get(j)));
        }
        ArrayList<List<String>> derivedAndEntityType = new ArrayList<List<String>>();
        ArrayList<String> derivediri = new ArrayList<String>();
        ArrayList<String> typeiri = new ArrayList<String>();
        for (String entity : entities) {
            SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
            GraphPatternNotTriples queryPattern = GraphPatterns.and((GraphPattern[])new GraphPattern[]{derived.has((RdfPredicate)isDerivedFrom, new RdfObject[]{Rdf.iri((String)entity)}), Rdf.iri((String)entity).isA(new RdfObject[]{entityType})}).filter(Expressions.and((Operand[])filters)).optional();
            ((SelectQuery)query.select(new Projectable[]{derived, entityType}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{p_derived});
            JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
            if (queryResult.getJSONObject(0).isEmpty()) continue;
            for (int j = 0; j < queryResult.length(); ++j) {
                derivediri.add(queryResult.getJSONObject(j).getString(derivedkey));
                typeiri.add(queryResult.getJSONObject(j).getString(typeKey));
            }
        }
        derivedAndEntityType.add(derivediri);
        derivedAndEntityType.add(typeiri);
        return derivedAndEntityType;
    }

    void deleteInstances(List<String> entities) {
        for (String entity : entities) {
            SubSelect sub = GraphPatterns.select((Projectable[])new Projectable[0]);
            Variable subject = sub.var();
            Variable pred1 = sub.var();
            Variable pred2 = sub.var();
            Variable object = sub.var();
            TriplePattern[] delete_tp = new TriplePattern[2];
            GraphPattern[] queryPattern = new GraphPattern[2];
            delete_tp[0] = subject.has((RdfPredicate)pred1, new RdfObject[]{Rdf.iri((String)entity)});
            queryPattern[0] = delete_tp[0].optional();
            delete_tp[1] = Rdf.iri((String)entity).has((RdfPredicate)pred2, new RdfObject[]{object});
            queryPattern[1] = delete_tp[1].optional();
            sub.select(new Projectable[]{subject, pred1, pred2, object}).where(queryPattern);
            ModifyQuery modify = Queries.MODIFY();
            modify.delete(delete_tp).where(new GraphPattern[]{sub});
            this.storeClient.executeUpdate(modify.getQueryString());
        }
    }

    long getTimestamp(String instance) {
        String queryKey = "timestamp";
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable time = SparqlBuilder.var((String)queryKey);
        Iri instanceIRI = Rdf.iri((String)instance);
        Iri[] predicates = new Iri[]{hasTime, inTimePosition, numericPosition};
        GraphPattern queryPattern = instanceIRI.has(PropertyPaths.path((RdfPredicate[])predicates), new RdfObject[]{time}).optional();
        Iri[] predicates2 = new Iri[]{belongsTo, hasTime, inTimePosition, numericPosition};
        GraphPattern queryPattern2 = instanceIRI.has(PropertyPaths.path((RdfPredicate[])predicates2), new RdfObject[]{time}).optional();
        ((SelectQuery)((SelectQuery)query.prefix(new Prefix[]{p_time, p_derived})).where(new GraphPattern[]{queryPattern, queryPattern2})).select(new Projectable[]{time});
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        if (queryResult.length() > 1) {
            throw new JPSRuntimeException("DerivedQuantitySparql: More than 1 time instance associated with <" + instance + ">");
        }
        try {
            long timestamp = queryResult.getJSONObject(0).getLong(queryKey);
            return timestamp;
        }
        catch (JSONException e) {
            throw new JPSRuntimeException("No timestamp for <" + instance + ">. This is probably an input and you should consider adding a timestamp using DerivationClient.addTimeInstance or create a derived instance using this instance");
        }
    }

    void updateTimeStamp(String instance) {
        long timestamp = Instant.now().getEpochSecond();
        SubSelect sub = GraphPatterns.select((Projectable[])new Projectable[0]);
        Variable timeIRI = sub.var();
        Variable unixtimeIRI = SparqlBuilder.var((String)"timeIRI");
        Variable oldvalue = SparqlBuilder.var((String)"oldvalue");
        GraphPatternNotTriples queryPattern = GraphPatterns.and((GraphPattern[])new GraphPattern[]{Rdf.iri((String)instance).has((RdfPredicate)hasTime, new RdfObject[]{timeIRI}), timeIRI.has((RdfPredicate)inTimePosition, new RdfObject[]{unixtimeIRI}), unixtimeIRI.has((RdfPredicate)numericPosition, new RdfObject[]{oldvalue})});
        TriplePattern delete_tp = unixtimeIRI.has((RdfPredicate)numericPosition, new RdfObject[]{oldvalue});
        TriplePattern insert_tp = unixtimeIRI.has((RdfPredicate)numericPosition, new Number[]{timestamp});
        sub.select(new Projectable[]{unixtimeIRI, oldvalue}).where(new GraphPattern[]{queryPattern});
        ModifyQuery modify = Queries.MODIFY();
        ((ModifyQuery)modify.prefix(new Prefix[]{p_time})).delete(new TriplePattern[]{delete_tp}).insert(new TriplePattern[]{insert_tp}).where(new GraphPattern[]{sub});
        this.storeClient.setQuery(modify.getQueryString());
        this.storeClient.executeUpdate();
    }

    List<String> getInstanceClass(List<String> instances) {
        String queryKey = "class";
        ArrayList<String> classOfInstances = new ArrayList<String>(instances.size());
        for (int i = 0; i < instances.size(); ++i) {
            SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
            Variable type = SparqlBuilder.var((String)queryKey);
            Expression[] filters = new Expression[classesToIgnore.size()];
            for (int j = 0; j < classesToIgnore.size(); ++j) {
                filters[j] = Expressions.notEquals((Operand)type, (Operand)((Operand)classesToIgnore.get(j)));
            }
            GraphPattern queryPattern = Rdf.iri((String)instances.get(i)).isA(new RdfObject[]{type}).filter(Expressions.and((Operand[])filters));
            query.select(new Projectable[]{type}).where(new GraphPattern[]{queryPattern});
            this.storeClient.setQuery(query.getQueryString());
            JSONArray queryResult = this.storeClient.executeQuery();
            if (queryResult.length() > 1) {
                throw new JPSRuntimeException("DerivedQuantitySparql.getInstanceClass: more than 1 rdf:type for " + instances.get(i));
            }
            if (queryResult.length() == 1) {
                classOfInstances.add(i, queryResult.getJSONObject(0).getString(queryKey));
                continue;
            }
            classOfInstances.add(i, "");
        }
        return classOfInstances;
    }

    void reconnectInputToDerived(String input, String derived) {
        ModifyQuery modify = Queries.MODIFY();
        TriplePattern insert_tp = Rdf.iri((String)derived).has((RdfPredicate)isDerivedFrom, new RdfObject[]{Rdf.iri((String)input)});
        ((ModifyQuery)modify.prefix(new Prefix[]{p_derived})).insert(new TriplePattern[]{insert_tp});
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    boolean isDerivedWithTimeSeries(String derived_iri) {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable type = query.var();
        TriplePattern tp = Rdf.iri((String)derived_iri).isA(new RdfObject[]{type});
        Expression constraint = Expressions.equals((Operand)type, (Operand)DerivationWithTimeSeries);
        GraphPattern queryPattern = tp.filter(constraint);
        ((SelectQuery)query.prefix(new Prefix[]{p_derived})).select(new Projectable[]{type}).where(new GraphPattern[]{queryPattern});
        return this.storeClient.executeQuery(query.getQueryString()).length() == 1;
    }

    void addNewEntitiesToDerived(String instance, List<String> newEntities) {
        ModifyQuery modify = Queries.MODIFY();
        for (String newEntity : newEntities) {
            modify.insert(new TriplePattern[]{Rdf.iri((String)newEntity).has((RdfPredicate)belongsTo, new RdfObject[]{Rdf.iri((String)instance)})});
        }
        this.storeClient.executeUpdate(((ModifyQuery)modify.prefix(new Prefix[]{p_derived})).getQueryString());
    }

    List<String> getInputsWithTimestamps() {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable time = query.var();
        Variable input = query.var();
        Variable derivation = query.var();
        GraphPatternNotTriples queryPattern = GraphPatterns.and((GraphPattern[])new GraphPattern[]{derivation.has((RdfPredicate)isDerivedFrom, new RdfObject[]{input}), input.has((RdfPredicate)hasTime, new RdfObject[]{time})});
        ((SelectQuery)query.select(new Projectable[]{input}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{p_time, p_derived});
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        if (queryResult.length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> inputs = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            inputs.add(queryResult.getJSONObject(i).getString(input.getQueryString().substring(1)));
        }
        return inputs;
    }

    void dropAllDerivations() {
        List<Iri> derivationTypes = Arrays.asList(Derivation, DerivationWithTimeSeries);
        ModifyQuery modify = Queries.MODIFY();
        SubSelect query = GraphPatterns.select((Projectable[])new Projectable[0]);
        Variable inputs = query.var();
        Variable entities = query.var();
        Variable derivation = query.var();
        Variable time = query.var();
        Variable time_unix_iri = query.var();
        Variable timestamp = query.var();
        Variable trs = query.var();
        Variable agent = query.var();
        Variable operation = query.var();
        Variable url = query.var();
        Variable derivationType = query.var();
        TriplePattern belongsToTp = entities.has((RdfPredicate)belongsTo, new RdfObject[]{derivation});
        TriplePattern isDerivedFromTp = derivation.has((RdfPredicate)isDerivedFrom, new RdfObject[]{inputs});
        TriplePattern derivationTypeTp = derivation.isA(new RdfObject[]{derivationType});
        TriplePattern timestampTp1 = derivation.has((RdfPredicate)hasTime, new RdfObject[]{time});
        TriplePattern timeTpAll1 = time.isA(new RdfObject[]{InstantClass}).andHas((RdfPredicate)inTimePosition, new RdfObject[]{time_unix_iri});
        TriplePattern timeTpAll2 = time_unix_iri.isA(new RdfObject[]{TimePosition}).andHas((RdfPredicate)numericPosition, new RdfObject[]{timestamp}).andHas((RdfPredicate)hasTRS, new RdfObject[]{trs});
        TriplePattern agentTp1 = derivation.has((RdfPredicate)isDerivedUsing, new RdfObject[]{agent});
        TriplePattern agentTp2 = agent.isA(new RdfObject[]{Service}).andHas((RdfPredicate)hasOperation, new RdfObject[]{operation});
        TriplePattern agentTp3 = operation.isA(new RdfObject[]{Operation}).andHas((RdfPredicate)hasHttpUrl, new RdfObject[]{url});
        GraphPatternNotTriples queryPattern = GraphPatterns.and((GraphPattern[])new GraphPattern[]{belongsToTp, isDerivedFromTp, timestampTp1, timeTpAll1, timeTpAll2, agentTp1, agentTp2, agentTp3, new ValuesPattern(derivationType, derivationTypes)});
        modify.delete(new TriplePattern[]{belongsToTp, isDerivedFromTp, timestampTp1, timeTpAll1, timeTpAll2, agentTp1, agentTp2, agentTp3, derivationTypeTp}).where(new GraphPattern[]{queryPattern}).prefix(new Prefix[]{p_time, p_derived, p_agent});
        this.storeClient.executeUpdate(modify.getQueryString());
    }
}

