/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.converter;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.validator.routines.UrlValidator;
import org.jfree.ui.ExtensionFileFilter;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.cam.cares.jps.base.converter.ITBoxGeneration;
import uk.ac.cam.cares.jps.base.converter.ITBoxManagement;
import uk.ac.cam.cares.jps.base.converter.TBoxManagement;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.util.Dialogs;
import uk.ac.cam.cares.jps.base.util.FileUtil;

public class TBoxGeneration
implements ITBoxGeneration {
    static Logger logger = LoggerFactory.getLogger(TBoxGeneration.class);
    ITBoxManagement iTBoxManagement;
    public static String owlFilePath;
    public static final String HAS_IRI = "https://www.w3.org/2007/05/powder-s#hasIRI";
    public static final String VERSION_INFO = "http://www.w3.org/2002/07/owl#versionInfo";
    public static final String RDFS_COMMENT = "http://www.w3.org/2000/01/rdf-schema#comment";
    public static final String OWL_IMPORTS = "http://www.w3.org/2002/07/owl#imports";

    public static void main(String[] args) {
        File folder = Dialogs.selectFileDialog(new File(System.getProperty("user.home")), new FileFilter[]{new ExtensionFileFilter("Comma-separated Value", "csv")}, false);
        if (folder != null) {
            if (!folder.exists()) {
                Dialogs.showErrorDialog("Selected folder does not exist.", "Read");
            } else {
                TBoxGeneration iTBoxGeneration = new TBoxGeneration();
                iTBoxGeneration.generateTBox(folder.toString());
            }
        }
    }

    @Override
    public void generateTBox(String csvFileNamePlusPath) {
        if (csvFileNamePlusPath == null || csvFileNamePlusPath.isEmpty()) {
            logger.error("No file has been found in the path specied.");
        }
        logger.info("Ontokin TBox generator started running...");
        owlFilePath = csvFileNamePlusPath.replace(".csv", ".owl");
        this.iTBoxManagement = new TBoxManagement();
        try {
            this.iTBoxManagement.init();
            this.readCSVTemplate(csvFileNamePlusPath);
            this.iTBoxManagement.saveOntology(owlFilePath);
            logger.info("Ontokin TBox generation FINISHED.");
        }
        catch (IOException e) {
            logger.error("IOException occured.");
            throw new JPSRuntimeException(e);
        }
        catch (JPSRuntimeException e) {
            logger.error("JPSRuntimeException occured.");
            throw new JPSRuntimeException(e);
        }
        catch (OWLOntologyCreationException e) {
            logger.error("OWLOntologyCreationException occured.");
            throw new JPSRuntimeException(e);
        }
        catch (OWLOntologyStorageException e) {
            logger.error("OWLOntologyStorageException occured.");
            throw new JPSRuntimeException(e);
        }
    }

    public void generateTBox(String csvFileNamePlusPath, String outputFilePlusPath) {
        if (csvFileNamePlusPath == null || csvFileNamePlusPath.isEmpty()) {
            logger.error("No file has been found in the path specied.");
        }
        logger.info("Ontokin TBox generator started running...");
        owlFilePath = outputFilePlusPath;
        this.iTBoxManagement = new TBoxManagement();
        try {
            this.iTBoxManagement.init();
            this.readCSVTemplate(csvFileNamePlusPath);
            this.iTBoxManagement.saveOntology(owlFilePath);
            logger.info("Ontokin TBox generation FINISHED.");
        }
        catch (IOException e) {
            logger.error("IOException occured.");
            throw new JPSRuntimeException(e);
        }
        catch (JPSRuntimeException e) {
            logger.error("JPSRuntimeException occured.");
            throw new JPSRuntimeException(e);
        }
        catch (OWLOntologyCreationException e) {
            logger.error("OWLOntologyCreationException occured.");
            throw new JPSRuntimeException(e);
        }
        catch (OWLOntologyStorageException e) {
            logger.error("OWLOntologyStorageException occured.");
            throw new JPSRuntimeException(e);
        }
    }

    private void readCSVTemplate(String csvFileNamePlusPath) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        List<List<String>> brSourceCtml = FileUtil.openCSVSourceFile(csvFileNamePlusPath);
        int countLine = 0;
        for (List<String> singleLine : brSourceCtml) {
            if (++countLine <= 1) {
                this.processHeader(singleLine);
                continue;
            }
            this.processLine(singleLine);
        }
    }

    private void processHeader(List<String> line) throws IOException, JPSRuntimeException {
        if (line.isEmpty()) {
            logger.error("The header is empty.");
            throw new IOException("TBox generation stopped proceeding as the header is empty.");
        }
        String[] tokens = line.toArray(new String[line.size()]);
        this.processHeader(tokens);
    }

    private void processHeader(String[] tokens) throws JPSRuntimeException {
        int tokenNumber = 0;
        block9: for (String token : tokens) {
            switch (++tokenNumber) {
                case 1: {
                    this.checkIfSourceAppears(token);
                    continue block9;
                }
                case 2: {
                    this.checkIfTypeAppears(token);
                    continue block9;
                }
                case 3: {
                    this.checkIfTargetAppears(token);
                    continue block9;
                }
                case 4: {
                    this.checkIfRelationAppears(token);
                    continue block9;
                }
                case 5: {
                    this.checkIfDomainAppears(token);
                    continue block9;
                }
                case 6: {
                    this.checkIfRangeAppears(token);
                    continue block9;
                }
                case 9: {
                    this.checkIfDefinedByAppears(token);
                }
            }
        }
    }

    private void checkIfSourceAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("source")) {
            throw new JPSRuntimeException("The source column is missing in the header.");
        }
    }

    private void checkIfTypeAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("type")) {
            throw new JPSRuntimeException("The type column is missing in the header.");
        }
    }

    private void checkIfTargetAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("target")) {
            throw new JPSRuntimeException("The target column is missing in the header.");
        }
    }

    private void checkIfRelationAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("relation")) {
            throw new JPSRuntimeException("The relation column is missing in the header.");
        }
    }

    private void checkIfDomainAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("domain")) {
            throw new JPSRuntimeException("The domain column is missing in the header.");
        }
    }

    private void checkIfRangeAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("range")) {
            throw new JPSRuntimeException("The range column is missing in the header.");
        }
    }

    private void checkIfDefinedByAppears(String token) throws JPSRuntimeException {
        if (!token.equalsIgnoreCase("defined by")) {
            throw new JPSRuntimeException("The defined by column is missing in the header.");
        }
    }

    private void processLine(List<String> line) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        if (line.isEmpty()) {
            logger.info("It encountered an empty line.");
            return;
        }
        this.readEachColumn(line);
    }

    private void readEachColumn(List<String> line) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        String[] tokens = line.toArray(new String[line.size()]);
        int tokenNumber = 0;
        block4: for (String token : tokens) {
            switch (++tokenNumber) {
                case 1: {
                    this.readSourceColumn(tokens[tokenNumber - 1]);
                    continue block4;
                }
                case 2: {
                    this.readTypeColumn(tokens, tokenNumber - 1);
                }
            }
        }
    }

    private void readSourceColumn(String firstColumn) throws IOException, JPSRuntimeException {
        if (firstColumn == null || firstColumn.isEmpty()) {
            throw new IOException("The first column of a row is empty.");
        }
    }

    private void readTypeColumn(String[] tokens, int tokenNumber) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        if (tokens[tokenNumber] == null || tokens[tokenNumber].isEmpty()) {
            throw new IOException("The second column of a row is empty.");
        }
        this.decideTypeOfConstruct(tokens, tokenNumber);
    }

    private void decideTypeOfConstruct(String[] tokens, int tokenNumber) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        if (tokens[tokenNumber].toLowerCase().equalsIgnoreCase("class")) {
            if (tokens.length > tokenNumber + 1 && !tokens[tokenNumber + 1].isEmpty() && tokens.length > tokenNumber + 2 && !tokens[tokenNumber + 2].isEmpty()) {
                this.generateClass(tokens[tokenNumber - 1], tokens[tokenNumber + 1], tokens[tokenNumber + 2]);
            } else {
                this.generateClass(tokens[tokenNumber - 1], null, null);
            }
            this.generateClassMetadata(tokens);
        } else if (tokens[tokenNumber].toLowerCase().equalsIgnoreCase("data property")) {
            this.generateProperty(1, tokens);
            this.generateDataPropertyMetadata(tokens);
        } else if (tokens[tokenNumber].toLowerCase().equalsIgnoreCase("object property")) {
            this.generateProperty(2, tokens);
            this.generateObjectPropertyMetadata(tokens);
        } else if (tokens[tokenNumber].toLowerCase().equalsIgnoreCase("tbox")) {
            this.generateTBoxProperty(tokens);
        }
    }

    private void generateProperty(int propertyType, String[] tokens) throws IOException, JPSRuntimeException {
        int i = 0;
        String propertyName = "";
        String targetName = "";
        String relation = "";
        String domain = "";
        String range = "";
        String quantifier = "";
        for (String token : tokens) {
            if (++i == 1) {
                propertyName = token;
            }
            if (i == 3) {
                targetName = token;
            }
            if (i == 4) {
                relation = token;
            }
            if (i == 5) {
                domain = token;
            }
            if (i == 6) {
                range = token;
            }
            if (i != 7) continue;
            quantifier = token;
        }
        this.callPropertyGenerateor(propertyType, propertyName, targetName, relation, domain, range, quantifier);
    }

    private void generateTBoxProperty(String[] tokens) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        int i = 0;
        String tBoxName = "";
        String target = "";
        String relation = "";
        for (String token : tokens) {
            if (++i == 1) {
                tBoxName = token;
            }
            if (i == 3) {
                target = token;
            }
            if (i != 4) continue;
            relation = token;
        }
        this.assignTBoxProperty(tBoxName, target, relation);
    }

    private void callPropertyGenerateor(int propertyType, String ... strings) throws IOException, JPSRuntimeException {
        if (propertyType == 1) {
            this.generateDataProperty(strings[0], strings[1], strings[2], strings[3], strings[4]);
        }
        if (propertyType == 2) {
            this.generateObjectProperty(strings[0], strings[1], strings[2], strings[3], strings[4], strings[5]);
        }
    }

    private void assignTBoxProperty(String tBoxName, String target, String relation) throws IOException, JPSRuntimeException, OWLOntologyCreationException {
        if (tBoxName != null && !tBoxName.isEmpty() && relation != null && !relation.isEmpty()) {
            if (relation.trim().equals(HAS_IRI) && target != null && new UrlValidator().isValid(target)) {
                TBoxManagement.tBoxConfig.settBoxIri(target);
                this.iTBoxManagement.instantiateOntologyModel();
            } else if (relation.trim().equals(VERSION_INFO) && target != null && !target.isEmpty()) {
                TBoxManagement.tBoxConfig.settBoxVersion(target);
            } else if (relation.trim().equals(RDFS_COMMENT) && target != null && !target.isEmpty()) {
                TBoxManagement.tBoxConfig.settBoxComment(target);
            } else if (relation.trim().equals(OWL_IMPORTS) && target != null && !target.isEmpty()) {
                TBoxManagement.tBoxConfig.settBoxImport(target);
            }
        }
    }

    @Override
    public void generateClass(String className, String targetName, String relation) throws IOException, JPSRuntimeException {
        this.iTBoxManagement.createOWLClass(className, targetName, relation);
    }

    public void generateClassMetadata(String[] tokens) throws IOException, JPSRuntimeException {
        if (tokens.length > 7) {
            this.iTBoxManagement.addDefinitionToOWLClass(tokens[0], tokens[7]);
        }
        if (tokens.length > 8) {
            this.iTBoxManagement.addDefinedByToClass(tokens[0], tokens[8]);
        }
        if (tokens.length > 9) {
            this.iTBoxManagement.addLabelToOWLClass(tokens[0], tokens[9]);
        }
    }

    public void generateObjectPropertyMetadata(String[] tokens) throws IOException, JPSRuntimeException {
        if (tokens.length > 7) {
            this.iTBoxManagement.addDefinitionToObjectProperty(tokens[0], tokens[7]);
        }
        if (tokens.length > 8) {
            this.iTBoxManagement.addDefinedByToObjectProperty(tokens[0], tokens[8]);
        }
        if (tokens.length > 6 && tokens[5] != null && !tokens[5].isEmpty()) {
            this.iTBoxManagement.addLogicalFormulaToObjectProperty(tokens[0], tokens[6], tokens[4], tokens[5]);
        }
        if (tokens.length > 9) {
            this.iTBoxManagement.addLabelToObjectProperty(tokens[0], tokens[9]);
        }
    }

    public void generateDataPropertyMetadata(String[] tokens) throws IOException, JPSRuntimeException {
        if (tokens.length > 7) {
            this.iTBoxManagement.addDefinitionToDataProperty(tokens[0], tokens[7]);
        }
        if (tokens.length > 8) {
            this.iTBoxManagement.addDefinedByToDataProperty(tokens[0], tokens[8]);
        }
        if (tokens.length > 9) {
            this.iTBoxManagement.addLabelToDataProperty(tokens[0], tokens[9]);
        }
    }

    @Override
    public void generateDataProperty(String propertyName, String targetName, String relation, String domain, String range) throws IOException, JPSRuntimeException {
        this.iTBoxManagement.createOWLDataProperty(propertyName, targetName, relation, domain, range);
    }

    @Override
    public void generateObjectProperty(String propertyName, String targetName, String relation, String domain, String range, String quantifier) throws IOException, JPSRuntimeException {
        this.iTBoxManagement.createOWLObjectProperty(propertyName, targetName, relation, domain, range, quantifier);
    }
}

