/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.annotate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.AccessAgentCaller;
import uk.ac.cam.cares.jps.base.query.SparqlOverHttpService;
import uk.ac.cam.cares.jps.base.query.sparql.PrefixToUrlMap;
import uk.ac.cam.cares.jps.base.query.sparql.Prefixes;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;

public class MetaDataAnnotator
implements Prefixes {
    private static final Logger LOGGER = LogManager.getLogger(MetaDataAnnotator.class);
    private static MetaDataAnnotator instance = null;
    private SparqlOverHttpService sparqlService = null;
    private String datasetUrl = null;

    static synchronized MetaDataAnnotator getInstance() {
        if (instance == null) {
            instance = new MetaDataAnnotator();
        }
        return instance;
    }

    private MetaDataAnnotator() {
        String oldDatasetUrl = "http://localhost:8080/rdf4j-server/repositories/jpsmetadata";
        this.sparqlService = new SparqlOverHttpService(SparqlOverHttpService.RDFStoreType.RDF4J, oldDatasetUrl);
        this.datasetUrl = KeyValueManager.get("dataset.meta.url");
    }

    public static SparqlOverHttpService getSparqlService() {
        return null;
    }

    public static String getMetadataSetUrl() {
        return MetaDataAnnotator.getInstance().datasetUrl;
    }

    public static void update(String sparql) {
        AccessAgentCaller.update(MetaDataAnnotator.getMetadataSetUrl(), null, sparql);
    }

    public static void annotateWithTimeAndAgent(String iriTarget, String time, String iriCreatingAgent) {
        String sparql = MetaDataAnnotator.getSparqlInsertFull(iriTarget, null, time, iriCreatingAgent, false, time, null, null, null, null);
        MetaDataAnnotator.update(sparql);
    }

    public static void annotate(String iriTarget, MediaType mediaType, String iriCreatingAgent, boolean addJPSContext, List<String> topics) {
        String sparql = MetaDataAnnotator.getSparqlInsert(iriTarget, null, null, iriCreatingAgent, addJPSContext, topics, null, null);
        MetaDataAnnotator.update(sparql);
    }

    public static void annotate(String iriTarget, MediaType mediaType, String iriCreatingAgent, boolean addJPSContext, List<String> topics, String creationTime) {
        String sparql = MetaDataAnnotator.getSparqlInsert(iriTarget, null, creationTime, iriCreatingAgent, addJPSContext, topics, null, null);
        MetaDataAnnotator.update(sparql);
    }

    public static String getSparqlInsert(String iriTarget, MediaType mediaType, String creationTime, String iriCreatingAgent, boolean addJPSContext, List<String> topics, List<String> prefixes, List<String> triples) {
        String contextTime;
        long millis = System.currentTimeMillis();
        if (creationTime == null) {
            creationTime = MetaDataAnnotator.getTimeInXsdTimeStampFormat(millis);
        }
        String simulationTime = creationTime;
        String iriScenario = JPSContext.getScenarioUrl();
        if (addJPSContext && (contextTime = JPSContext.getSimulationTime()) != null && !contextTime.isEmpty()) {
            simulationTime = contextTime;
        }
        return MetaDataAnnotator.getSparqlInsertFull(iriTarget, mediaType, creationTime, iriCreatingAgent, addJPSContext, simulationTime, iriScenario, topics, prefixes, triples);
    }

    public static String getSparqlInsertFull(String iriTarget, MediaType mediaType, String creationTime, String iriCreatingAgent, boolean addJPSContext, String simulationTime, String iriScenario, List<String> topics, List<String> prefixes, List<String> triples) {
        LOGGER.info("annotating target = " + iriTarget + " with media type = " + (Object)((Object)mediaType) + ", creation time = " + creationTime + ", creatingAgent = " + iriCreatingAgent + ", simulation time = " + simulationTime + ", scenario = " + iriScenario);
        StringBuffer sparql = new StringBuffer();
        sparql.append(PrefixToUrlMap.getPrefixForSPARQL("dcterms"));
        sparql.append(PrefixToUrlMap.getPrefixForSPARQL("xsd"));
        if (prefixes != null) {
            for (String current : prefixes) {
                sparql.append(current);
                if (current.endsWith("\n")) continue;
                sparql.append(" \r\n");
            }
        }
        if (iriScenario == null) {
            sparql.append("INSERT DATA { \r\n");
        } else {
            sparql.append("INSERT DATA { GRAPH <" + iriScenario + "> { \r\n");
        }
        if (mediaType != null) {
            sparql.append("<" + iriTarget + "> dcterms:format \"" + mediaType.type + "\" . \r\n");
        }
        sparql.append("<" + iriTarget + "> dcterms:created \"" + creationTime + "\"^^xsd:dateTime . \r\n");
        if (iriCreatingAgent != null) {
            sparql.append("<" + iriCreatingAgent + "> a dcterms:Agent . \r\n");
            sparql.append("<" + iriCreatingAgent + "> a <http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#Service> . \r\n");
            sparql.append("<" + iriTarget + "> dcterms:creator <" + iriCreatingAgent + "> . \r\n");
        }
        sparql.append("<" + iriTarget + "> dcterms:date \"" + simulationTime + "\"^^xsd:dateTime . \r\n");
        if (iriScenario != null) {
            sparql.append("<" + iriTarget + "> dcterms:isPartOf <" + iriScenario + "> . \r\n");
        }
        ArrayList<String> optionalTriples = new ArrayList<String>();
        if (topics != null) {
            for (String current : topics) {
                optionalTriples.add("<" + iriTarget + "> dcterms:subject <" + current + "> .");
            }
        }
        if (triples != null) {
            optionalTriples.addAll(triples);
        }
        for (String current : optionalTriples) {
            sparql.append(current + " \r\n");
        }
        if (iriScenario == null) {
            sparql.append("} \r\n");
        } else {
            sparql.append("} } \r\n");
        }
        return sparql.toString();
    }

    public static String getTimeInXsdTimeStampFormat(long millis) {
        Date date = new Date(millis);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        String timestamp = format.format(date);
        return timestamp.replace(" ", "T");
    }

    public static long getMillisFromXsdTimeStampFormat(String timestamp) {
        Date date;
        timestamp = timestamp.replace("T", " ");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        try {
            date = format.parse(timestamp);
        }
        catch (ParseException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return date.getTime();
    }
}

