/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphml;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.LexicographicalElementComparator;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLWriterHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GraphMLWriter {
    private final Graph graph;
    private boolean normalize = false;
    private Map<String, String> vertexKeyTypes = null;
    private Map<String, String> edgeKeyTypes = null;
    private String xmlSchemaLocation = null;
    private String edgeLabelKey = null;

    public GraphMLWriter(Graph graph) {
        this.graph = graph;
    }

    public void setXmlSchemaLocation(String xmlSchemaLocation) {
        this.xmlSchemaLocation = xmlSchemaLocation;
    }

    public void setEdgeLabelKey(String edgeLabelKey) {
        this.edgeLabelKey = edgeLabelKey;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setVertexKeyTypes(Map<String, String> vertexKeyTypes) {
        this.vertexKeyTypes = vertexKeyTypes;
    }

    public void setEdgeKeyTypes(Map<String, String> edgeKeyTypes) {
        this.edgeKeyTypes = edgeKeyTypes;
    }

    public void outputGraph(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        this.outputGraph(fos);
        fos.close();
    }

    public void outputGraph(OutputStream graphMLOutputStream) throws IOException {
        if (null == this.vertexKeyTypes || null == this.edgeKeyTypes) {
            HashMap<String, String> vertexKeyTypes = new HashMap<String, String>();
            HashMap<String, String> edgeKeyTypes = new HashMap<String, String>();
            for (Vertex vertex : this.graph.getVertices()) {
                for (String string : vertex.getPropertyKeys()) {
                    if (vertexKeyTypes.containsKey(string)) continue;
                    vertexKeyTypes.put(string, GraphMLWriter.getStringType(vertex.getProperty(string)));
                }
                for (Edge edge : vertex.getEdges(Direction.OUT, new String[0])) {
                    for (String key : edge.getPropertyKeys()) {
                        if (edgeKeyTypes.containsKey(key)) continue;
                        edgeKeyTypes.put(key, GraphMLWriter.getStringType(edge.getProperty(key)));
                    }
                }
            }
            if (null == this.vertexKeyTypes) {
                this.vertexKeyTypes = vertexKeyTypes;
            }
            if (null == this.edgeKeyTypes) {
                this.edgeKeyTypes = edgeKeyTypes;
            }
        }
        if (null != this.edgeLabelKey && null != this.edgeKeyTypes && null == this.edgeKeyTypes.get(this.edgeLabelKey)) {
            this.edgeKeyTypes.put(this.edgeLabelKey, "string");
        }
        XMLOutputFactory inputFactory = XMLOutputFactory.newInstance();
        try {
            Iterable<Object> vertices;
            Collection<Object> keyset;
            XMLStreamWriter writer = inputFactory.createXMLStreamWriter(graphMLOutputStream, "UTF8");
            if (this.normalize) {
                writer = new GraphMLWriterHelper.IndentingXMLStreamWriter(writer);
                ((GraphMLWriterHelper.IndentingXMLStreamWriter)writer).setIndentStep("    ");
            }
            writer.writeStartDocument();
            writer.writeStartElement("graphml");
            writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
            writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns " + (this.xmlSchemaLocation == null ? "http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd" : this.xmlSchemaLocation));
            if (this.normalize) {
                keyset = new ArrayList();
                keyset.addAll(this.vertexKeyTypes.keySet());
                Collections.sort((List)keyset);
            } else {
                keyset = this.vertexKeyTypes.keySet();
            }
            for (String string : keyset) {
                writer.writeStartElement("key");
                writer.writeAttribute("id", string);
                writer.writeAttribute("for", "node");
                writer.writeAttribute("attr.name", string);
                writer.writeAttribute("attr.type", this.vertexKeyTypes.get(string));
                writer.writeEndElement();
            }
            if (this.normalize) {
                keyset = new ArrayList();
                keyset.addAll(this.edgeKeyTypes.keySet());
                Collections.sort((List)keyset);
            } else {
                keyset = this.edgeKeyTypes.keySet();
            }
            for (String string : keyset) {
                writer.writeStartElement("key");
                writer.writeAttribute("id", string);
                writer.writeAttribute("for", "edge");
                writer.writeAttribute("attr.name", string);
                writer.writeAttribute("attr.type", this.edgeKeyTypes.get(string));
                writer.writeEndElement();
            }
            writer.writeStartElement("graph");
            writer.writeAttribute("id", "G");
            writer.writeAttribute("edgedefault", "directed");
            if (this.normalize) {
                vertices = new ArrayList();
                for (Vertex vertex : this.graph.getVertices()) {
                    ((Collection)vertices).add(vertex);
                }
                Collections.sort((List)vertices, new LexicographicalElementComparator());
            } else {
                vertices = this.graph.getVertices();
            }
            for (Vertex vertex : vertices) {
                Collection<String> keys;
                writer.writeStartElement("node");
                writer.writeAttribute("id", vertex.getId().toString());
                if (this.normalize) {
                    keys = new ArrayList();
                    keys.addAll(vertex.getPropertyKeys());
                    Collections.sort((List)keys);
                } else {
                    keys = vertex.getPropertyKeys();
                }
                for (String key : keys) {
                    writer.writeStartElement("data");
                    writer.writeAttribute("key", key);
                    Object value = vertex.getProperty(key);
                    if (null != value) {
                        writer.writeCharacters(value.toString());
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.normalize) {
                ArrayList<Edge> arrayList = new ArrayList<Edge>();
                for (Vertex vertex : this.graph.getVertices()) {
                    for (Edge edge : vertex.getEdges(Direction.OUT, new String[0])) {
                        arrayList.add(edge);
                    }
                }
                Collections.sort(arrayList, new LexicographicalElementComparator());
                for (Edge edge : arrayList) {
                    writer.writeStartElement("edge");
                    writer.writeAttribute("id", edge.getId().toString());
                    writer.writeAttribute("source", edge.getVertex(Direction.OUT).getId().toString());
                    writer.writeAttribute("target", edge.getVertex(Direction.IN).getId().toString());
                    if (this.edgeLabelKey == null) {
                        writer.writeAttribute("label", edge.getLabel());
                    } else {
                        writer.writeStartElement("data");
                        writer.writeAttribute("key", this.edgeLabelKey);
                        writer.writeCharacters(edge.getLabel());
                        writer.writeEndElement();
                    }
                    ArrayList<String> keys = new ArrayList<String>();
                    keys.addAll(edge.getPropertyKeys());
                    Collections.sort(keys);
                    for (String key : keys) {
                        writer.writeStartElement("data");
                        writer.writeAttribute("key", key);
                        Object value = edge.getProperty(key);
                        if (null != value) {
                            writer.writeCharacters(value.toString());
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            } else {
                for (Vertex vertex : this.graph.getVertices()) {
                    for (Edge edge : vertex.getEdges(Direction.OUT, new String[0])) {
                        writer.writeStartElement("edge");
                        writer.writeAttribute("id", edge.getId().toString());
                        writer.writeAttribute("source", edge.getVertex(Direction.OUT).getId().toString());
                        writer.writeAttribute("target", edge.getVertex(Direction.IN).getId().toString());
                        writer.writeAttribute("label", edge.getLabel());
                        for (String key : edge.getPropertyKeys()) {
                            writer.writeStartElement("data");
                            writer.writeAttribute("key", key);
                            Object value = edge.getProperty(key);
                            if (null != value) {
                                writer.writeCharacters(value.toString());
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    public static void outputGraph(Graph graph, OutputStream graphMLOutputStream) throws IOException {
        GraphMLWriter writer = new GraphMLWriter(graph);
        writer.outputGraph(graphMLOutputStream);
    }

    public static void outputGraph(Graph graph, String filename) throws IOException {
        GraphMLWriter writer = new GraphMLWriter(graph);
        writer.outputGraph(filename);
    }

    public static void outputGraph(Graph graph, String filename, Map<String, String> vertexKeyTypes, Map<String, String> edgeKeyTypes) throws IOException {
        GraphMLWriter writer = new GraphMLWriter(graph);
        writer.setVertexKeyTypes(vertexKeyTypes);
        writer.setEdgeKeyTypes(edgeKeyTypes);
        writer.outputGraph(filename);
    }

    public static void outputGraph(Graph graph, OutputStream graphMLOutputStream, Map<String, String> vertexKeyTypes, Map<String, String> edgeKeyTypes) throws IOException {
        GraphMLWriter writer = new GraphMLWriter(graph);
        writer.setVertexKeyTypes(vertexKeyTypes);
        writer.setEdgeKeyTypes(edgeKeyTypes);
        writer.outputGraph(graphMLOutputStream);
    }

    private static String getStringType(Object object) {
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        return "string";
    }
}

