/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.gml;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.LexicographicalElementComparator;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GMLWriter {
    private static final String DELIMITER = " ";
    private static final String TAB = "\t";
    private static final String NEW_LINE = "\r\n";
    private static final String OPEN_LIST = " [\r\n";
    private static final String CLOSE_LIST = "]\r\n";
    private final Graph graph;
    private boolean normalize = false;
    private boolean useId = false;
    private boolean strict = false;
    private String vertexIdKey = "blueprintsId";
    private String edgeIdKey = "blueprintsId";
    private static final String GML_PROPERTY_KEY_REGEX = "[a-zA-Z][a-zA-Z0-9]{0,253}";
    private static final Pattern regex = Pattern.compile("[a-zA-Z][a-zA-Z0-9]{0,253}");

    public GMLWriter(Graph graph) {
        this.graph = graph;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setUseId(boolean useId) {
        this.useId = useId;
    }

    public void setVertexIdKey(String vertexIdKey) {
        this.vertexIdKey = vertexIdKey;
    }

    public void setEdgeIdKey(String edgeIdKey) {
        this.edgeIdKey = edgeIdKey;
    }

    public void outputGraph(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        this.outputGraph(fos);
        fos.close();
    }

    public void outputGraph(OutputStream gMLOutputStream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(gMLOutputStream, Charset.forName("ISO-8859-1")));
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        this.populateLists(vertices, edges);
        if (this.normalize) {
            LexicographicalElementComparator comparator = new LexicographicalElementComparator();
            Collections.sort(vertices, comparator);
            Collections.sort(edges, comparator);
        }
        this.writeGraph(writer, vertices, edges);
        ((Writer)writer).flush();
    }

    private void writeGraph(Writer writer, List<Vertex> vertices, List<Edge> edges) throws IOException {
        HashMap<Vertex, Integer> ids = new HashMap<Vertex, Integer>();
        writer.write("graph");
        writer.write(OPEN_LIST);
        this.writeVertices(writer, vertices, ids);
        this.writeEdges(writer, edges, ids);
        writer.write(CLOSE_LIST);
    }

    private void writeVertices(Writer writer, List<Vertex> vertices, Map<Vertex, Integer> ids) throws IOException {
        int count = 1;
        for (Vertex v : vertices) {
            if (this.useId) {
                Integer id = Integer.valueOf(v.getId().toString());
                this.writeVertex(writer, v, id);
                ids.put(v, id);
                continue;
            }
            this.writeVertex(writer, v, count);
            ids.put(v, count++);
        }
    }

    private void writeVertex(Writer writer, Vertex v, int id) throws IOException {
        writer.write(TAB);
        writer.write("node");
        writer.write(OPEN_LIST);
        this.writeKey(writer, "id");
        this.writeNumberProperty(writer, id);
        this.writeVertexProperties(writer, v);
        writer.write(TAB);
        writer.write(CLOSE_LIST);
    }

    private void writeEdges(Writer writer, List<Edge> edges, Map<Vertex, Integer> ids) throws IOException {
        for (Edge e : edges) {
            this.writeEdgeProperties(writer, e, ids.get(e.getVertex(Direction.OUT)), ids.get(e.getVertex(Direction.IN)));
        }
    }

    private void writeEdgeProperties(Writer writer, Edge e, Integer source, Integer target) throws IOException {
        writer.write(TAB);
        writer.write("edge");
        writer.write(OPEN_LIST);
        this.writeKey(writer, "source");
        this.writeNumberProperty(writer, source);
        this.writeKey(writer, "target");
        this.writeNumberProperty(writer, target);
        this.writeKey(writer, "label");
        this.writeStringProperty(writer, e.getLabel());
        this.writeEdgeProperties(writer, e);
        writer.write(TAB);
        writer.write(CLOSE_LIST);
    }

    private void writeVertexProperties(Writer writer, Vertex e) throws IOException {
        Object blueprintsId = e.getId();
        if (!this.useId) {
            this.writeKey(writer, this.vertexIdKey);
            if (blueprintsId instanceof Number) {
                this.writeNumberProperty(writer, (Number)blueprintsId);
            } else {
                this.writeStringProperty(writer, blueprintsId);
            }
        }
        this.writeProperties(writer, e);
    }

    private void writeEdgeProperties(Writer writer, Edge e) throws IOException {
        Object blueprintsId = e.getId();
        if (!this.useId) {
            this.writeKey(writer, this.edgeIdKey);
            if (blueprintsId instanceof Number) {
                this.writeNumberProperty(writer, (Number)blueprintsId);
            } else {
                this.writeStringProperty(writer, blueprintsId);
            }
        }
        this.writeProperties(writer, e);
    }

    private void writeProperties(Writer writer, Element e) throws IOException {
        for (String key : e.getPropertyKeys()) {
            if (this.strict && !regex.matcher(key).matches()) continue;
            Object property = e.getProperty(key);
            this.writeKey(writer, key);
            this.writeProperty(writer, property, 0);
        }
    }

    private void writeProperty(Writer writer, Object property, int tab) throws IOException {
        if (property instanceof Number) {
            this.writeNumberProperty(writer, (Number)property);
        } else if (property instanceof Map) {
            this.writeMapProperty(writer, (Map)property, tab);
        } else {
            this.writeStringProperty(writer, property.toString());
        }
    }

    private void writeMapProperty(Writer writer, Map<?, ?> map, int tabs) throws IOException {
        writer.write(OPEN_LIST);
        ++tabs;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.writeTabs(writer, tabs);
            this.writeKey(writer, entry.getKey().toString());
            this.writeProperty(writer, entry.getValue(), tabs);
        }
        this.writeTabs(writer, tabs - 1);
        writer.write(CLOSE_LIST);
    }

    private void writeTabs(Writer writer, int tabs) throws IOException {
        for (int i = 0; i <= tabs; ++i) {
            writer.write(TAB);
        }
    }

    private void writeNumberProperty(Writer writer, Number integer) throws IOException {
        writer.write(integer.toString());
        writer.write(NEW_LINE);
    }

    private void writeStringProperty(Writer writer, Object string) throws IOException {
        writer.write("\"");
        writer.write(string.toString().replaceAll("\"", "\\\\\""));
        writer.write("\"");
        writer.write(NEW_LINE);
    }

    private void writeKey(Writer writer, String command) throws IOException {
        writer.write(TAB);
        writer.write(TAB);
        writer.write(command);
        writer.write(DELIMITER);
    }

    private void populateLists(List<Vertex> vertices, List<Edge> edges) {
        for (Vertex v : this.graph.getVertices()) {
            vertices.add(v);
        }
        for (Edge e : this.graph.getEdges()) {
            edges.add(e);
        }
    }

    public static void outputGraph(Graph graph, OutputStream graphMLOutputStream) throws IOException {
        GMLWriter writer = new GMLWriter(graph);
        writer.outputGraph(graphMLOutputStream);
    }

    public static void outputGraph(Graph graph, String filename) throws IOException {
        GMLWriter writer = new GMLWriter(graph);
        writer.outputGraph(filename);
    }
}

