/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExprRenderer;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.FedXTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.NTuple;
import org.eclipse.rdf4j.federated.algebra.VariableExpr;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.FilterUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAlgebraUtil {
    private static final Logger log = LoggerFactory.getLogger(QueryAlgebraUtil.class);

    public static boolean hasFreeVars(StatementPattern stmt, BindingSet bindings) {
        for (Var var : stmt.getVarList()) {
            if (var.hasValue() || bindings.hasBinding(var.getName())) continue;
            return true;
        }
        return false;
    }

    public static Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public static TupleExpr toTupleExpr(ArbitraryLengthPath node, Set<String> varNames, BindingSet bindings) {
        ArbitraryLengthPath clone = node.clone();
        InsertBindingsVisitor bindingsInserter = new InsertBindingsVisitor(bindings);
        bindingsInserter.meetOther((QueryModelNode)clone);
        varNames.addAll(bindingsInserter.freeVars);
        return clone;
    }

    public static StatementPattern toStatementPattern(Statement stmt) {
        return QueryAlgebraUtil.toStatementPattern(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
    }

    public static StatementPattern toStatementPattern(Resource subj, IRI pred, Value obj) {
        Var s = subj == null ? new Var("s") : new Var("const_s", (Value)subj);
        Var p = pred == null ? new Var("p") : new Var("const_p", (Value)pred);
        Var o = obj == null ? new Var("o") : new Var("const_o", obj);
        return new StatementPattern(s, p, o);
    }

    public static Statement toStatement(StatementPattern stmt) {
        return QueryAlgebraUtil.toStatement(stmt, EmptyBindingSet.getInstance());
    }

    public static Statement toStatement(StatementPattern stmt, BindingSet bindings) {
        Value subj = QueryAlgebraUtil.getVarValue(stmt.getSubjectVar(), bindings);
        Value pred = QueryAlgebraUtil.getVarValue(stmt.getPredicateVar(), bindings);
        Value obj = QueryAlgebraUtil.getVarValue(stmt.getObjectVar(), bindings);
        return FedXUtil.valueFactory().createStatement((Resource)subj, (IRI)pred, obj);
    }

    public static TupleExpr selectQuery(StatementPattern stmt, BindingSet bindings, FilterValueExpr filterExpr, AtomicBoolean evaluated) throws IllegalQueryException {
        HashSet<String> varNames = new HashSet<String>();
        StatementPattern expr = QueryAlgebraUtil.constructStatement(stmt, varNames, bindings);
        if (varNames.isEmpty()) {
            throw new IllegalQueryException("SELECT query needs at least one projection!");
        }
        if (filterExpr != null) {
            try {
                expr = new Filter((TupleExpr)expr, FilterUtils.toFilter(filterExpr));
                evaluated.set(true);
            }
            catch (Exception e) {
                log.debug("Filter could not be evaluated remotely: " + e.getMessage());
                log.trace("Details: ", (Throwable)e);
            }
        }
        ProjectionElemList projList = new ProjectionElemList();
        for (String var : varNames) {
            projList.addElement(new ProjectionElem(var));
        }
        Projection proj = new Projection((TupleExpr)expr, projList);
        return proj;
    }

    public static TupleExpr selectQuery(ExclusiveGroup group, BindingSet bindings, FilterValueExpr filterExpr, AtomicBoolean evaluated) {
        HashSet<String> varNames = new HashSet<String>();
        List<ExclusiveTupleExpr> stmts = group.getExclusiveExpressions();
        Join join = null;
        if (stmts.size() == 2) {
            join = new Join(QueryAlgebraUtil.constructJoinArg(stmts.get(0), varNames, bindings), QueryAlgebraUtil.constructJoinArg(stmts.get(1), varNames, bindings));
        } else {
            int idx;
            join = new Join();
            join.setLeftArg(QueryAlgebraUtil.constructJoinArg(stmts.get(0), varNames, bindings));
            Object tmp = join;
            for (idx = 1; idx < stmts.size() - 1; ++idx) {
                Join _u = new Join();
                _u.setLeftArg(QueryAlgebraUtil.constructJoinArg(stmts.get(idx), varNames, bindings));
                tmp.setRightArg((TupleExpr)_u);
                tmp = _u;
            }
            tmp.setRightArg(QueryAlgebraUtil.constructJoinArg(stmts.get(idx), varNames, bindings));
        }
        Join expr = join;
        if (filterExpr != null) {
            try {
                expr = new Filter((TupleExpr)expr, FilterUtils.toFilter(filterExpr));
                evaluated.set(true);
            }
            catch (Exception e) {
                log.debug("Filter could not be evaluated remotely: " + e.getMessage());
                log.trace("Details:", (Throwable)e);
            }
        }
        ProjectionElemList projList = new ProjectionElemList();
        for (String var : varNames) {
            projList.addElement(new ProjectionElem(var));
        }
        Projection proj = new Projection((TupleExpr)expr, projList);
        return proj;
    }

    public static TupleExpr selectQueryBoundUnion(StatementPattern stmt, List<BindingSet> unionBindings, FilterValueExpr filterExpr, Boolean evaluated) {
        int idx;
        HashSet<String> varNames = new HashSet<String>();
        Union union = new Union();
        union.setLeftArg((TupleExpr)QueryAlgebraUtil.constructStatementId(stmt, Integer.toString(0), varNames, unionBindings.get(0)));
        Union tmp = union;
        for (idx = 1; idx < unionBindings.size() - 1; ++idx) {
            Union _u = new Union();
            _u.setLeftArg((TupleExpr)QueryAlgebraUtil.constructStatementId(stmt, Integer.toString(idx), varNames, unionBindings.get(idx)));
            tmp.setRightArg((TupleExpr)_u);
            tmp = _u;
        }
        tmp.setRightArg((TupleExpr)QueryAlgebraUtil.constructStatementId(stmt, Integer.toString(idx), varNames, unionBindings.get(idx)));
        ProjectionElemList projList = new ProjectionElemList();
        for (String var : varNames) {
            projList.addElement(new ProjectionElem(var));
        }
        Projection proj = new Projection((TupleExpr)union, projList);
        return proj;
    }

    public static TupleExpr selectQueryStringBoundCheck(StatementPattern stmt, List<BindingSet> unionBindings) {
        int idx;
        HashSet<String> varNames = new HashSet<String>();
        Union union = new Union();
        union.setLeftArg(QueryAlgebraUtil.constructStatementCheckId(stmt, 0, varNames, unionBindings.get(0)));
        Union tmp = union;
        for (idx = 1; idx < unionBindings.size() - 1; ++idx) {
            Union _u = new Union();
            _u.setLeftArg(QueryAlgebraUtil.constructStatementCheckId(stmt, idx, varNames, unionBindings.get(idx)));
            tmp.setRightArg((TupleExpr)_u);
            tmp = _u;
        }
        tmp.setRightArg(QueryAlgebraUtil.constructStatementCheckId(stmt, idx, varNames, unionBindings.get(idx)));
        ProjectionElemList projList = new ProjectionElemList();
        for (String var : varNames) {
            projList.addElement(new ProjectionElem(var));
        }
        Projection proj = new Projection((TupleExpr)union, projList);
        return proj;
    }

    protected static Union constructInnerUnion(StatementPattern stmt, int outerID, Set<String> varNames, List<BindingSet> bindings) {
        int idx;
        Union union = new Union();
        union.setLeftArg((TupleExpr)QueryAlgebraUtil.constructStatementId(stmt, outerID + "_0", varNames, bindings.get(0)));
        Union tmp = union;
        for (idx = 1; idx < bindings.size() - 1; ++idx) {
            Union _u = new Union();
            _u.setLeftArg((TupleExpr)QueryAlgebraUtil.constructStatementId(stmt, outerID + "_" + idx, varNames, bindings.get(idx)));
            tmp.setRightArg((TupleExpr)_u);
            tmp = _u;
        }
        tmp.setRightArg((TupleExpr)QueryAlgebraUtil.constructStatementId(stmt, outerID + "_" + idx, varNames, bindings.get(idx)));
        return union;
    }

    private static TupleExpr constructJoinArg(ExclusiveTupleExpr exclusiveExpr, Set<String> varNames, BindingSet bindings) {
        if (exclusiveExpr instanceof StatementPattern) {
            return QueryAlgebraUtil.constructStatement((StatementPattern)exclusiveExpr, varNames, bindings);
        }
        if (!(exclusiveExpr instanceof ExclusiveTupleExprRenderer)) {
            throw new IllegalStateException("Cannot render tupl expr of type " + exclusiveExpr.getClass());
        }
        return ((ExclusiveTupleExprRenderer)exclusiveExpr).toQueryAlgebra(varNames, bindings);
    }

    protected static StatementPattern constructStatement(StatementPattern stmt, Set<String> varNames, BindingSet bindings) {
        Var subj = QueryAlgebraUtil.appendVar(stmt.getSubjectVar(), varNames, bindings);
        Var pred = QueryAlgebraUtil.appendVar(stmt.getPredicateVar(), varNames, bindings);
        Var obj = QueryAlgebraUtil.appendVar(stmt.getObjectVar(), varNames, bindings);
        return new StatementPattern(subj, pred, obj);
    }

    protected static StatementPattern constructStatementId(StatementPattern stmt, String varID, Set<String> varNames, BindingSet bindings) {
        Var subj = QueryAlgebraUtil.appendVarId(stmt.getSubjectVar(), varID, varNames, bindings);
        Var pred = QueryAlgebraUtil.appendVarId(stmt.getPredicateVar(), varID, varNames, bindings);
        Var obj = QueryAlgebraUtil.appendVarId(stmt.getObjectVar(), varID, varNames, bindings);
        return new StatementPattern(subj, pred, obj);
    }

    protected static TupleExpr constructStatementCheckId(StatementPattern stmt, int varID, Set<String> varNames, BindingSet bindings) {
        Value objValue;
        String _varID = Integer.toString(varID);
        Var subj = QueryAlgebraUtil.appendVarId(stmt.getSubjectVar(), _varID, varNames, bindings);
        Var pred = QueryAlgebraUtil.appendVarId(stmt.getPredicateVar(), _varID, varNames, bindings);
        Var obj = new Var("o_" + _varID);
        varNames.add("o_" + _varID);
        if (stmt.getObjectVar().hasValue()) {
            objValue = stmt.getObjectVar().getValue();
        } else if (bindings.hasBinding(stmt.getObjectVar().getName())) {
            objValue = bindings.getBinding(stmt.getObjectVar().getName()).getValue();
        } else {
            throw new RuntimeException("Unexpected.");
        }
        Compare cmp = new Compare((ValueExpr)obj, (ValueExpr)new ValueConstant(objValue));
        cmp.setOperator(Compare.CompareOp.EQ);
        Filter filter = new Filter((TupleExpr)new StatementPattern(subj, pred, obj), (ValueExpr)cmp);
        return filter;
    }

    protected static Var appendVar(Var var, Set<String> varNames, BindingSet bindings) {
        Var res = var.clone();
        if (!var.hasValue()) {
            if (bindings.hasBinding(var.getName())) {
                res.setValue(bindings.getValue(var.getName()));
            } else {
                varNames.add(var.getName());
            }
        }
        return res;
    }

    protected static Var appendVarId(Var var, String varID, Set<String> varNames, BindingSet bindings) {
        Var res = var.clone();
        if (!var.hasValue()) {
            if (bindings.hasBinding(var.getName())) {
                res.setValue(bindings.getValue(var.getName()));
            } else {
                String newName = var.getName() + "_" + varID;
                varNames.add(newName);
                res.setName(newName);
            }
        }
        return res;
    }

    public static Collection<String> getFreeVars(TupleExpr tupleExpr) {
        if (tupleExpr instanceof FedXTupleExpr) {
            return ((FedXTupleExpr)tupleExpr).getFreeVars();
        }
        if (tupleExpr instanceof VariableExpr) {
            return ((VariableExpr)tupleExpr).getFreeVars();
        }
        if (tupleExpr instanceof NTuple) {
            HashSet<String> freeVars = new HashSet<String>();
            NTuple ntuple = (NTuple)tupleExpr;
            for (TupleExpr t : ntuple.getArgs()) {
                freeVars.addAll(QueryAlgebraUtil.getFreeVars(t));
            }
            return freeVars;
        }
        if (tupleExpr instanceof FedXService) {
            return ((FedXService)tupleExpr).getFreeVars();
        }
        if (tupleExpr instanceof Service) {
            return ((Service)tupleExpr).getServiceVars();
        }
        if (tupleExpr instanceof StatementPattern) {
            ArrayList<String> freeVars = new ArrayList<String>();
            StatementPattern st = (StatementPattern)tupleExpr;
            if (st.getSubjectVar().getValue() == null) {
                freeVars.add(st.getSubjectVar().getName());
            }
            if (st.getPredicateVar().getValue() == null) {
                freeVars.add(st.getPredicateVar().getName());
            }
            if (st.getObjectVar().getValue() == null) {
                freeVars.add(st.getObjectVar().getName());
            }
            return freeVars;
        }
        if (tupleExpr instanceof Projection) {
            Projection p = (Projection)tupleExpr;
            return new ArrayList<String>(p.getBindingNames());
        }
        if (tupleExpr instanceof BindingSetAssignment) {
            return new ArrayList<String>();
        }
        if (tupleExpr instanceof Extension) {
            return new ArrayList<String>();
        }
        if (tupleExpr instanceof ArbitraryLengthPath) {
            return QueryAlgebraUtil.getFreeVars(((ArbitraryLengthPath)tupleExpr).getPathExpression());
        }
        if (tupleExpr instanceof LeftJoin) {
            LeftJoin l = (LeftJoin)tupleExpr;
            HashSet<String> freeVars = new HashSet<String>();
            freeVars.addAll(QueryAlgebraUtil.getFreeVars(l.getLeftArg()));
            freeVars.addAll(QueryAlgebraUtil.getFreeVars(l.getRightArg()));
            return freeVars;
        }
        log.debug("Type " + tupleExpr.getClass().getSimpleName() + " not supported for computing free vars. If you run into this, please report a bug.");
        return new ArrayList<String>();
    }

    private static class InsertBindingsVisitor
    extends AbstractQueryModelVisitor<QueryEvaluationException> {
        private final BindingSet bindings;
        private final Set<String> freeVars = Sets.newHashSet();

        private InsertBindingsVisitor(BindingSet bindings) {
            this.bindings = bindings;
        }

        public void meet(Var node) throws QueryEvaluationException {
            if (node.hasValue()) {
                if (this.bindings.hasBinding(node.getName())) {
                    node.setValue(this.bindings.getValue(node.getName()));
                }
            } else {
                this.freeVars.add(node.getName());
            }
            super.meet(node);
        }
    }
}

