/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.ConjunctiveFilterExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterTuple;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.NodeFactory;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.repository.RepositoryException;

public class ExclusiveGroup
extends AbstractQueryModelNode
implements StatementTupleExpr,
FilterTuple,
ExclusiveTupleExpr {
    private static final long serialVersionUID = 9215353191021766797L;
    protected final List<ExclusiveTupleExpr> owned = new ArrayList<ExclusiveTupleExpr>();
    protected final StatementSource owner;
    protected final Set<String> freeVars = new HashSet<String>();
    protected final String id;
    protected final transient QueryInfo queryInfo;
    protected FilterValueExpr filter = null;
    protected transient Endpoint ownedEndpoint = null;
    private final FederationEvalStrategy strategy;

    public ExclusiveGroup(Collection<? extends ExclusiveTupleExpr> ownedNodes, StatementSource owner, QueryInfo queryInfo) {
        this.owned.addAll(ownedNodes);
        this.owner = owner;
        this.init();
        this.id = NodeFactory.getNextId();
        this.queryInfo = queryInfo;
        this.ownedEndpoint = queryInfo.getFederationContext().getEndpointManager().getEndpoint(owner.getEndpointID());
        this.strategy = queryInfo.getFederationContext().getStrategy();
    }

    protected void init() {
        HashSet<FilterExpr> conjExpr = new HashSet<FilterExpr>();
        for (ExclusiveTupleExpr o : this.owned) {
            this.freeVars.addAll(o.getFreeVars());
            if (!(o instanceof FilterTuple) || !((FilterTuple)((Object)o)).hasFilter()) continue;
            FilterValueExpr expr = ((FilterTuple)((Object)o)).getFilterExpr();
            if (expr instanceof ConjunctiveFilterExpr) {
                conjExpr.addAll(((ConjunctiveFilterExpr)expr).getExpressions());
                continue;
            }
            if (expr instanceof FilterExpr) {
                conjExpr.add((FilterExpr)expr);
                continue;
            }
            throw new RuntimeException("Internal Error: Unexpected filter type: " + expr.getClass().getSimpleName());
        }
        if (conjExpr.size() == 1) {
            this.filter = (FilterValueExpr)conjExpr.iterator().next();
        } else if (conjExpr.size() > 1) {
            this.filter = new ConjunctiveFilterExpr(conjExpr);
        }
    }

    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ExclusiveTupleExpr s : this.owned) {
            s.visit(visitor);
        }
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther((QueryModelNode)this);
    }

    public Set<String> getAssuredBindingNames() {
        return Collections.emptySet();
    }

    public Set<String> getBindingNames() {
        return Collections.emptySet();
    }

    public ExclusiveGroup clone() {
        throw new RuntimeException("Operation not supported on this node!");
    }

    @Override
    public StatementSource getOwner() {
        return this.owner;
    }

    public Endpoint getOwnedEndpoint() {
        return this.ownedEndpoint;
    }

    public List<ExclusiveTupleExpr> getExclusiveExpressions() {
        return this.owned;
    }

    @Override
    public int getFreeVarCount() {
        return this.freeVars.size();
    }

    @Override
    public List<String> getFreeVars() {
        return new ArrayList<String>(this.freeVars);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<StatementSource> getStatementSources() {
        return Collections.singletonList(this.owner);
    }

    @Override
    public boolean hasFreeVarsFor(BindingSet bindings) {
        for (String var : this.freeVars) {
            if (bindings.hasBinding(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        try {
            return this.strategy.evaluateExclusiveGroup(this, bindings);
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
    }

    @Override
    public void addFilterExpr(FilterExpr expr) {
        throw new UnsupportedOperationException("Operation not supported for " + ExclusiveGroup.class.getCanonicalName() + ", filters already to children during optimization.");
    }

    @Override
    public FilterValueExpr getFilterExpr() {
        return this.filter;
    }

    @Override
    public boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public void addBoundFilter(String varName, Value value) {
        throw new UnsupportedOperationException("Operation not supported for " + ExclusiveGroup.class.getCanonicalName() + ", bindings inserted during optimization.");
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }
}

