/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;

class EmptyPropertyElement
extends AbstractState
implements State {
    protected final NodeElement nodeElement;
    @Nullable
    protected String pIRI;

    EmptyPropertyElement(NodeElement nodeElement, RDFParser parser) {
        super(parser);
        this.nodeElement = nodeElement;
    }

    protected String propertyIRI() {
        return (String)OWLAPIPreconditions.verifyNotNull((Object)this.pIRI);
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) {
        this.parser.verify(this.pIRI != null, "incorrect element start encountered.");
        this.pIRI = this.nodeElement.getPropertyIRI(namespaceIRI + localName);
        String reificationID = this.nodeElement.getReificationID(atts);
        String objectIRI = this.getNodeIDResourceResourceIRI(atts);
        if (objectIRI == null) {
            objectIRI = NodeID.nextAnonymousIRI();
        }
        this.parser.statementWithResourceValue(this.nodeElement.subjectIRI(), this.propertyIRI(), objectIRI, reificationID);
        this.propertyAttributes(objectIRI, atts, this.getReificationManager(atts));
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        this.parser.popState();
    }

    @Override
    public void characters(char[] data, int start, int length) {
        this.parser.verify(true, "Characters were not expected.");
    }
}

