/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.sail.memory.model.MemLiteral;

public class IntegerMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = -8121416400439616510L;
    private final BigInteger value;

    public IntegerMemLiteral(Object creator, BigInteger value) {
        this(creator, value, XMLSchema.INTEGER);
    }

    public IntegerMemLiteral(Object creator, BigInteger value, URI datatype) {
        this(creator, value.toString(), value, datatype);
    }

    public IntegerMemLiteral(Object creator, String label, BigInteger value, URI datatype) {
        super(creator, label, datatype);
        this.value = value;
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger integerValue() {
        return this.value;
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.value);
    }
}

