/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class XMLHandler
extends DefaultHandler {
    private final DSLContext ctx;
    private boolean inResult;
    private boolean inFields;
    private int inRecord;
    private boolean inColumn;
    Result<Record> result;
    private Field<?>[] fieldsArray;
    private final List<Field<?>> fields;
    private final List<String> values;
    private int column;

    XMLHandler(DSLContext ctx) {
        this.ctx = ctx;
        this.fields = new ArrayList();
        this.values = new ArrayList<String>();
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.inResult && "result".equals(qName)) {
            this.inResult = true;
        } else if (this.inResult && "fields".equals(qName)) {
            this.inFields = true;
        } else if (this.inResult && this.inFields && "field".equals(qName)) {
            String catalog = attributes.getValue("catalog");
            String schema = attributes.getValue("schema");
            String table = attributes.getValue("table");
            String name = attributes.getValue("name");
            String type = attributes.getValue("type");
            this.fields.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(this.ctx.dialect(), StringUtils.defaultIfBlank(type, "VARCHAR"))));
        } else if (!this.inResult || !"records".equals(qName)) {
            if (this.inResult && "record".equals(qName)) {
                ++this.inRecord;
            } else {
                if (this.result == null) {
                    String fieldName;
                    if ("value".equals(qName) && (fieldName = attributes.getValue("field")) != null) {
                        this.fields.add(DSL.field(DSL.name(fieldName), SQLDataType.VARCHAR));
                    } else {
                        this.fields.add(DSL.field(DSL.name(qName), SQLDataType.VARCHAR));
                    }
                }
                this.inColumn = true;
            }
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inResult && this.inRecord == 0 && "result".equals(qName)) {
            this.inResult = false;
        } else if (this.inResult && this.inFields && "fields".equals(qName)) {
            this.inFields = false;
            this.initResult();
        } else if (!(this.inResult && this.inFields && "field".equals(qName) || this.inResult && "records".equals(qName))) {
            if (this.inRecord > 0 && "record".equals(qName)) {
                --this.inRecord;
                this.initResult();
                Record r = this.ctx.newRecord(this.fieldsArray);
                r.from(this.values);
                this.result.add(r);
                this.values.clear();
                this.column = 0;
            } else {
                this.inColumn = false;
                ++this.column;
            }
        }
    }

    private void initResult() {
        if (this.result == null) {
            if (XMLHandler.onlyValueFields(this.fields)) {
                this.fieldsArray = Tools.fields(this.fields.size());
                this.result = this.ctx.newResult(this.fieldsArray);
            } else {
                this.fieldsArray = this.fields.toArray(Tools.EMPTY_FIELD);
                this.result = this.ctx.newResult(this.fieldsArray);
            }
        }
    }

    private static boolean onlyValueFields(List<Field<?>> fields) {
        if (fields.size() <= 1) {
            return false;
        }
        for (Field<?> field : fields) {
            if ("value".equals(field.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inColumn) {
            String value = new String(ch, start, length);
            if (this.values.size() == this.column) {
                this.values.add(value);
            } else {
                this.values.set(this.column, this.values.get(this.column) + value);
            }
        }
    }
}

