/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.UUID;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONEntry;
import org.jooq.JSONEntryValueStep;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.F1;
import org.jooq.impl.Keywords;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class JSONEntryImpl<T>
extends AbstractQueryPart
implements JSONEntry<T>,
JSONEntryValueStep {
    private static final long serialVersionUID = 6734093632906565848L;
    private final Field<String> key;
    private final Field<T> value;

    JSONEntryImpl(Field<String> key) {
        this(key, null);
    }

    JSONEntryImpl(Field<String> key, Field<T> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public final Field<String> key() {
        return this.key;
    }

    @Override
    public final Field<T> value() {
        return this.value;
    }

    public final <X> JSONEntry<X> value(X newValue) {
        return this.value(Tools.field(newValue));
    }

    public final <X> JSONEntry<X> value(Field<X> newValue) {
        return new JSONEntryImpl<X>(this.key, newValue);
    }

    public final <X> JSONEntry<X> value(Select<? extends Record1<X>> newValue) {
        return this.value(DSL.field(newValue));
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: {
                ctx.visit(this.key).sql(", ").visit(JSONEntryImpl.jsonCast(ctx, this.value));
                break;
            }
            default: {
                ctx.visit(Keywords.K_KEY).sql(' ').visit(this.key).sql(' ').visit(Keywords.K_VALUE).sql(' ').visit(JSONEntryImpl.jsonCast(ctx, this.value));
            }
        }
    }

    static final F1<Field<?>, Field<?>> jsonCastMapper(final Context<?> ctx) {
        return new F1<Field<?>, Field<?>>(){

            @Override
            public Field<?> apply(Field<?> field) {
                return JSONEntryImpl.jsonCast(ctx, field);
            }
        };
    }

    static final Field<?> jsonCast(Context<?> ctx, Field<?> field) {
        DataType type = field.getDataType();
        switch (ctx.family()) {
            case H2: {
                if (type.getType() != UUID.class) break;
                return field.cast(SQLDataType.VARCHAR(36));
            }
            case MARIADB: 
            case MYSQL: {
                if (type.getType() != Boolean.class) break;
                return Tools.inlined(field);
            }
        }
        return field;
    }
}

