/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class DisjunctiveConstraintOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new OrSameTermOptimizer());
    }

    protected static class OrSameTermOptimizer
    extends QueryModelVisitorBase<RuntimeException> {
        protected OrSameTermOptimizer() {
        }

        public void meet(Filter filter) {
            if (filter.getCondition() instanceof Or && this.containsSameTerm(filter.getCondition())) {
                Or orNode = (Or)filter.getCondition();
                TupleExpr filterArg = filter.getArg();
                ValueExpr leftConstraint = orNode.getLeftArg();
                ValueExpr rightConstraint = orNode.getRightArg();
                filter.replaceWith((QueryModelNode)filterArg);
                TupleExpr node = this.findNotFilter(filterArg);
                Filter leftFilter = new Filter(node.clone(), leftConstraint);
                Filter rightFilter = new Filter(node.clone(), rightConstraint);
                Union union = new Union((TupleExpr)leftFilter, (TupleExpr)rightFilter);
                node.replaceWith((QueryModelNode)union);
                filter.getParentNode().visit((QueryModelVisitor)this);
            } else {
                super.meet(filter);
            }
        }

        private TupleExpr findNotFilter(TupleExpr node) {
            if (node instanceof Filter) {
                return this.findNotFilter(((Filter)node).getArg());
            }
            return node;
        }

        private boolean containsSameTerm(ValueExpr node) {
            if (node instanceof SameTerm) {
                return true;
            }
            if (node instanceof Or) {
                Or or = (Or)node;
                boolean left = this.containsSameTerm(or.getLeftArg());
                return left || this.containsSameTerm(or.getRightArg());
            }
            if (node instanceof And) {
                And and = (And)node;
                boolean left = this.containsSameTerm(and.getLeftArg());
                return left || this.containsSameTerm(and.getRightArg());
            }
            return false;
        }
    }
}

