"""Script to unblind the Radio-selected AGN sample (9749 sources). Draws the background TS values
generated by radio_selected_agn_analysis.py, in order to quantify the significance of the result.
Produces relevant post-unblinding plots.
"""
from __future__ import print_function
from __future__ import division
import numpy as np
from flarestack.data.icecube import diffuse_8_year
from flarestack.utils.catalogue_loader import load_catalogue
from flarestack.analyses.agn_cores.shared_agncores import \
    agn_subset_catalogue, complete_cats_north, complete_cats_north, agn_catalogue_name, agn_subset_catalogue_north
from flarestack.core.unblinding import create_unblinder


import logging


logging.getLogger().setLevel("INFO")

analyses = dict()

# Initialise Injectors/LLHs
llh_time = {
    "time_pdf_name": "Steady"
}

llh_energy = {
    "energy_pdf_name": "PowerLaw"
}

llh_dict = {
    "llh_name": "standard_matrix",
    "llh_sig_time_pdf": llh_time,
    "llh_energy_pdf": llh_energy
}


def bkg_ts_base_name(cat_key, n_sources):
    return "analyses/agn_cores/stacking_analysis_8yrNTsample_pre_unblinding/{0}/" \
           "NrSrcs={1}/".format(cat_key, n_sources)

def bkg_ts_generate_name(cat_key, n_sources, gamma):
    return bkg_ts_base_name(cat_key, n_sources) + "{0}/".format(gamma)

def base_name(cat_key, n_sources):
    return "analyses/agn_cores/stacking_analysis_8yrNTsample_unblinding/{0}/" \
           "NrSrcs={1}/".format(cat_key, n_sources)

def generate_name(cat_key, n_sources, gamma):
    return base_name(cat_key, n_sources) + "{0}/".format(gamma)


gammas = [2.0, 2.5]

# Unblind the total radio-selected AGN sample (not sub-selection of brightest sources)
nr_brightest_sources = [9749]

all_res = dict()

# Loop over the gammas for the radio-selected AGN sample with 9749 sources
for (cat_type, method) in complete_cats_north[:1]:

    unique_key = cat_type + "_" + method

    gamma_dict = dict()

    for gamma_index in gammas:
        res = dict()
        nr_srcs = int(nr_brightest_sources[0])
        cat_path = agn_subset_catalogue(cat_type, method, nr_srcs)
        catalogue = load_catalogue(cat_path)
        cat = np.load(cat_path)

        name = generate_name(unique_key, nr_srcs, gamma_index)
        bkg_ts = bkg_ts_base_name(unique_key, nr_srcs)
        print('NAME OF FOLDERS')
        print(name, bkg_ts)

        injection_time = llh_time
        injection_energy = dict(llh_energy)
        injection_energy["gamma"] = gamma_index

        inj_kwargs = {
            "injection_energy_pdf": injection_energy,
            "injection_sig_time_pdf": injection_time,
        }

        unblind_dict = {
            "name": name,
            "mh_name": "large_catalogue",
            "dataset": diffuse_8_year.get_seasons(),
            "catalogue": cat_path,
            "llh_dict": llh_dict,
            "background_ts": bkg_ts,
        }

        ub = create_unblinder(unblind_dict, mock_unblind=True, full_plots=False)