import typing
from ast import *

"""
Make sure that certain variable names may never be overwritten
"""

FORBIDDEN_NAMES = {
    # Type annotations
    "List",
    "Dict",
    "Union",
    # decorator and class name
    "dataclass",
    "PlutusData",
}


class ForbiddenOverwriteError(ValueError):
    pass


class RewriteForbiddenOverwrites(NodeTransformer):
    def visit_Name(self, node: Name) -> Name:
        if node.ctx == Store() and node.id in FORBIDDEN_NAMES:
            raise ForbiddenOverwriteError(
                f"It is not allowed to overwrite name {node.id}"
            )
        return node
