# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['renotize']

package_data = \
{'': ['*']}

install_requires = \
['arrow>=0.15.5,<0.16.0',
 'click>=7.1.1,<8.0.0',
 'logzero>=1.5.0,<2.0.0',
 'pyyaml>=5.3.1,<6.0.0',
 'tqdm>=4.45.0,<5.0.0']

entry_points = \
{'console_scripts': ['renotize = renotize.renotize:cli']}

setup_kwargs = {
    'name': 'renotize',
    'version': '1.0.1',
    'description': "A utility script for quickly and automatically notarizing Ren'Py applications for macOS.",
    'long_description': "# reNotize\nA utility script for quickly and automatically notarizing Ren'Py applications for macOS.\n\nreNotize supports the entire pipeline of app notarization, starting with the basic ZIP file generated by Ren'Py's build process and automatically generating a fully-notarized DMG for distribution to your users.\n\n## Installation\nreNotize can be installed via pip:\n```bash\n$ pip install renotize\n```\n\nPlease note that reNotize requires Python 3 and will not provide backwards compatibility for Python 2 for the foreseeable future.\n\n## Usage\n```\nUsage: renotize.py [OPTIONS] PROJECT COMMAND [ARGS]...\n\n  A utility script for quickly and automatically notarizing Ren'Py\n  applications for macOS.\n\n  Commands can be abbreviated by the shortest unique string.\n\n  For example:\n      unpack-app -> u\n      sign-app -> sign-a\n      sign-dmg -> sign-d\n\n  The fully automatic process can be started using:\n      renotize -c <path_to_config> <path_to_ZIP_file> full-run\n\nOptions:\n  -c, --config TEXT\n  -d, --debug / -nd, --no-debug  Print debug information or only regular\n                                 output\n\n  --help                         Show this message and exit.\n\nCommands:\n  full-run\n  notarize-app\n  notarize-dmg\n  pack-dmg\n  sign-app\n  sign-dmg\n  staple-app\n  staple-dmg\n  status\n  unpack-app\n```\n\n# Disclaimer\nreNotize is a hobby project and not in any way affiliated with Ren'Py. This means that there is no way I can guarantee that it will work at all, or continue to work once it does.\n",
    'author': 'CobaltCore',
    'author_email': 'cobaltcore@yandex.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kobaltcore/renotize',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
