"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserVpcAuthorization = exports.UserVpcAuthorizationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pvtz_generated_1 = require("./pvtz.generated");
Object.defineProperty(exports, "UserVpcAuthorizationProperty", { enumerable: true, get: function () { return pvtz_generated_1.RosUserVpcAuthorization; } });
/**
 * A ROS resource type:  `ALIYUN::PVTZ::UserVpcAuthorization`
 */
class UserVpcAuthorization extends ros.Resource {
    /**
     * Create a new `ALIYUN::PVTZ::UserVpcAuthorization`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUserVpcAuthorization = new pvtz_generated_1.RosUserVpcAuthorization(this, id, {
            authCode: props.authCode,
            authChannel: props.authChannel,
            authorizedUserId: props.authorizedUserId,
            authType: props.authType,
            ignoreDeletionForbidden: props.ignoreDeletionForbidden === undefined || props.ignoreDeletionForbidden === null ? false : props.ignoreDeletionForbidden,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUserVpcAuthorization;
        this.attrAuthType = rosUserVpcAuthorization.attrAuthType;
        this.attrAuthorizedUserId = rosUserVpcAuthorization.attrAuthorizedUserId;
    }
}
exports.UserVpcAuthorization = UserVpcAuthorization;
//# sourceMappingURL=data:application/json;base64,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