/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.io.Serializable;
import java.util.Arrays;

public class SparseIntVector
implements IntVector,
Serializable {
    private static final long serialVersionUID = -2428993854689991888L;
    private static final int INITIAL_SIZE = 5;
    private final double EXPANSION = 1.5;
    int maxIndex = -1;
    private final MutableSparseIntSet indices = MutableSparseIntSet.makeEmpty();
    private int[] data = new int[5];
    private final int defaultValue;

    public SparseIntVector(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public int get(int x) {
        int index = this.indices.getIndex(x);
        if (index == -1) {
            return this.defaultValue;
        }
        return this.data[index];
    }

    @Override
    public void set(int x, int value) {
        this.maxIndex = Math.max(this.maxIndex, x);
        int index = this.indices.getIndex(x);
        if (index == -1) {
            this.indices.add(x);
            index = this.indices.getIndex(x);
            this.ensureCapacity(this.indices.size() + 1);
            if (index < this.data.length - 1) {
                System.arraycopy(this.data, index, this.data, index + 1, this.indices.size() - index);
            }
        }
        this.data[index] = value;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length < capacity + 1) {
            this.data = Arrays.copyOf(this.data, 1 + (int)((double)capacity * 1.5));
        }
    }

    public void performVerboseAction() {
        System.err.println(this.getClass() + " stats: ");
        System.err.println("data.length " + this.data.length);
        System.err.println("indices.size() " + this.indices.size());
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }
}

