/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.intset.BitVectorIntSet;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class BitVectorRepository {
    private static final boolean STATS = false;
    private static final int STATS_WINDOW = 100;
    private static int queries = 0;
    private static int hits = 0;
    private static final int SUBSET_DELTA = 5;
    private static final Map<Integer, LinkedList<WeakReference<BitVectorIntSet>>> buckets = HashMapFactory.make();

    public static synchronized BitVectorIntSet findOrCreateSharedSubset(BitVectorIntSet value) {
        int size;
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        for (int i = size = value.size(); i > size - 5; --i) {
            LinkedList<WeakReference<BitVectorIntSet>> m = buckets.get(i);
            if (m == null) continue;
            Iterator it = m.iterator();
            while (it.hasNext()) {
                WeakReference wr = (WeakReference)it.next();
                BitVectorIntSet bv = (BitVectorIntSet)wr.get();
                if (bv != null) {
                    if (!bv.isSubset(value)) continue;
                    return bv;
                }
                it.remove();
            }
        }
        LinkedList<WeakReference<BitVectorIntSet>> m = buckets.get(size);
        if (m == null) {
            LinkedList tmp = new LinkedList();
            m = tmp;
            buckets.put(size, m);
        }
        BitVectorIntSet bv = new BitVectorIntSet(value);
        m.add(new WeakReference<BitVectorIntSet>(bv));
        return bv;
    }

    private static void reportStats() {
        double percent = 100.0 * (double)hits / (double)queries;
        System.err.println("BitVectorRepository: queries " + queries + " hits " + percent);
        System.err.println("                     entries " + BitVectorRepository.countEntries());
    }

    private static int countEntries() {
        int result = 0;
        for (LinkedList<WeakReference<BitVectorIntSet>> l : buckets.values()) {
            result += l.size();
        }
        return result;
    }
}

