/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.Bits;
import java.io.Serializable;
import java.util.Arrays;

public abstract class BitVectorBase<T extends BitVectorBase>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1151811022797406841L;
    protected static final boolean DEBUG = false;
    protected static final int LOG_BITS_PER_UNIT = 5;
    protected static final int BITS_PER_UNIT = 32;
    protected static final int MASK = -1;
    protected static final int LOW_MASK = 31;
    protected int[] bits;
    private static final int[][] masks = new int[][]{{-65536}, {-16777216, 65280}, {-268435456, 0xF00000, 61440, 240}, {-1073741824, 0xC000000, 0xC00000, 786432, 49152, 3072, 192, 12}, {Integer.MIN_VALUE, 0x20000000, 0x8000000, 0x2000000, 0x800000, 0x200000, 524288, 131072, 32768, 8192, 2048, 512, 128, 32, 8, 2}};

    public abstract void set(int var1);

    public abstract void clear(int var1);

    public abstract boolean get(int var1);

    public abstract int length();

    public abstract void and(T var1);

    public abstract void andNot(T var1);

    public abstract void or(T var1);

    public abstract void xor(T var1);

    public abstract boolean sameBits(T var1);

    public abstract boolean isSubset(T var1);

    public abstract boolean intersectionEmpty(T var1);

    public static int subscript(int bitIndex) {
        return bitIndex >> 5;
    }

    public final void clearAll() {
        Arrays.fill(this.bits, 0);
    }

    public int hashCode() {
        int h = 1234;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            h ^= this.bits[i] * (i + 1);
        }
        return h;
    }

    public final int populationCount() {
        int count = 0;
        for (int bit : this.bits) {
            count += Bits.populationCount(bit);
        }
        return count;
    }

    public boolean isZero() {
        int setLength = this.bits.length;
        for (int i = setLength - 1; i >= 0; --i) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        BitVectorBase result = null;
        try {
            result = (BitVectorBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean needSeparator = false;
        buffer.append('{');
        int limit = this.length();
        for (int i = 0; i < limit; ++i) {
            if (!this.get(i)) continue;
            if (needSeparator) {
                buffer.append(", ");
            } else {
                needSeparator = true;
            }
            buffer.append(i);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean contains(int i) {
        return this.get(i);
    }

    public int max() {
        int lastWord;
        for (lastWord = this.bits.length - 1; lastWord >= 0 && this.bits[lastWord] == 0; --lastWord) {
        }
        if (lastWord < 0) {
            return -1;
        }
        int count = lastWord * 32;
        int top = this.bits[lastWord];
        int j = 0;
        for (int[] mask2 : masks) {
            if ((top & mask2[j]) != 0) {
                j <<= 1;
                continue;
            }
            j <<= 1;
            ++j;
        }
        return count + (31 - j);
    }

    public int nextSetBit(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("illegal start: " + start);
        }
        int bit = 1 << (start & 0x1F);
        for (int word = BitVectorBase.subscript(start); word < this.bits.length; ++word) {
            if (this.bits[word] != 0) {
                do {
                    if ((this.bits[word] & bit) != 0) {
                        return start;
                    }
                    ++start;
                } while ((bit <<= 1) != 0);
            } else {
                start += 32 - (start & 0x1F);
            }
            bit = 1;
        }
        return -1;
    }

    public void copyBits(BitVectorBase set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int setLength = set.bits.length;
        this.bits = new int[setLength];
        for (int i = setLength - 1; i >= 0; --i) {
            this.bits[i] = set.bits[i];
        }
    }
}

