/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.dominators;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DominanceFrontiers<T> {
    private final Map<T, Set<T>> DF = HashMapFactory.make();
    private final Dominators<T> dom;
    private final Graph<T> G;
    private final T root;

    public DominanceFrontiers(Graph<T> G, T root) {
        this.root = root;
        this.G = G;
        this.dom = Dominators.make(G, root);
        this.analyze();
    }

    public Iterator<T> getDominanceFrontier(T n) {
        Set<T> frontier = this.DF.get(n);
        if (frontier == null) {
            throw new IllegalArgumentException("no dominance frontier for node " + n);
        }
        return frontier.iterator();
    }

    public boolean isDominatedBy(T node, T master) {
        return this.dom.isDominatedBy(node, master);
    }

    public Iterator<T> dominators(T node) {
        return this.dom.dominators(node);
    }

    public Graph<T> dominatorTree() {
        return this.dom.dominatorTree();
    }

    private void analyze() {
        Graph DT = this.dom.dominatorTree();
        DFSFinishTimeIterator<T> XS = DFS.iterateFinishTime(DT, new NonNullSingletonIterator<T>(this.root));
        while (XS.hasNext()) {
            Object X = XS.next();
            HashSet DF_X = HashSetFactory.make();
            this.DF.put(X, DF_X);
            for (Object Y : Iterator2Iterable.make(this.G.getSuccNodes(X))) {
                if (this.dom.getIdom(Y) == X) continue;
                DF_X.add(Y);
            }
            for (Object Z : Iterator2Iterable.make(DT.getSuccNodes(X))) {
                for (Object Y2 : Iterator2Iterable.make(this.getDominanceFrontier(Z))) {
                    if (this.dom.getIdom(Y2) == X) continue;
                    DF_X.add(Y2);
                }
            }
        }
    }
}

