/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.core.util.strings.Atom;
import java.io.Serializable;

public class ClassLoaderReference
implements Serializable {
    private static final long serialVersionUID = -3256390509887654325L;
    public static final Atom Java = Atom.findOrCreateUnicodeAtom("Java");
    public static final ClassLoaderReference Primordial = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom("Primordial"), Java, null);
    public static final ClassLoaderReference Extension = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom("Extension"), Java, Primordial);
    public static final ClassLoaderReference Application = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom("Application"), Java, Extension);
    private final Atom name;
    private final Atom language;
    private final ClassLoaderReference parent;

    public ClassLoaderReference(Atom name, Atom language, ClassLoaderReference parent) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.language = language;
        this.parent = parent;
    }

    public Atom getName() {
        return this.name;
    }

    public Atom getLanguage() {
        return this.language;
    }

    public ClassLoaderReference getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ClassLoaderReference o = (ClassLoaderReference)obj;
        return this.name.equals(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + " classloader\n";
    }
}

