/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.core.util.strings.StringStuff;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class IR
implements IRView {
    private final IMethod method;
    private final SSAOptions options;
    private final SSACFG cfg;
    private final SSAInstruction[] instructions;
    private final SymbolTable symbolTable;
    private final BasicNaturalRelation callSiteMapping = new BasicNaturalRelation();
    private final Map<NewSiteReference, Integer> newSiteMapping = HashMapFactory.make();
    private final Map<ProgramCounter, Integer> peiMapping = HashMapFactory.make();
    private Map<SSAInstruction, ISSABasicBlock> instruction2Block;

    protected abstract SSA2LocalMap getLocalMap();

    protected abstract <T extends SSAIndirectionData.Name> SSAIndirectionData<T> getIndirectionData();

    protected IR(IMethod method, SSAInstruction[] instructions, SymbolTable symbolTable, SSACFG cfg, SSAOptions options) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.method = method;
        this.instructions = instructions;
        this.symbolTable = symbolTable;
        this.cfg = cfg;
        this.options = options;
    }

    protected void setupLocationMap() {
        for (int i = 0; i < this.instructions.length; ++i) {
            SSAInstruction x = this.instructions[i];
            if (x == null) continue;
            if (x instanceof SSAAbstractInvokeInstruction) {
                this.callSiteMapping.add(((SSAAbstractInvokeInstruction)x).getCallSite().getProgramCounter(), i);
            }
            if (x instanceof SSANewInstruction) {
                this.newSiteMapping.put(((SSANewInstruction)x).getNewSite(), i);
            }
            if (!x.isPEI()) continue;
            this.peiMapping.put(new ProgramCounter(this.cfg.getProgramCounter(i)), i);
        }
    }

    protected abstract String instructionPosition(int var1);

    public String toString() {
        Collection names = null;
        if (this.getIndirectionData() != null) {
            names = this.getIndirectionData().getNames();
        }
        StringBuilder result = new StringBuilder(this.method.toString());
        result.append("\nCFG:\n");
        result.append(this.cfg.toString());
        result.append("Instructions:\n");
        for (int i = 0; i <= this.cfg.getMaxNumber(); ++i) {
            SSACFG.BasicBlock bb = this.cfg.getNode(i);
            int start = bb.getFirstInstructionIndex();
            int end = bb.getLastInstructionIndex();
            result.append("BB").append(bb.getNumber());
            if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
                result.append("<Handler> (");
                Iterator<Object> catchIter = ((SSACFG.ExceptionHandlerBasicBlock)bb).getCaughtExceptionTypes();
                while (catchIter.hasNext()) {
                    TypeReference next = (TypeReference)catchIter.next();
                    result.append(next);
                    if (!catchIter.hasNext()) continue;
                    result.append(',');
                }
                result.append(')');
            }
            result.append('\n');
            for (SSAPhiInstruction phi : Iterator2Iterable.make(bb.iteratePhis())) {
                if (phi == null) continue;
                result.append("           ").append(phi.toString(this.symbolTable)).append('\n');
            }
            if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
                SSACFG.ExceptionHandlerBasicBlock ebb = (SSACFG.ExceptionHandlerBasicBlock)bb;
                SSAGetCaughtExceptionInstruction s = ebb.getCatchInstruction();
                if (s != null) {
                    result.append("           ").append(s.toString(this.symbolTable)).append('\n');
                } else {
                    result.append("            No catch instruction. Unreachable?\n");
                }
            }
            for (int j = start; j <= end; ++j) {
                int valNum;
                int v;
                if (this.instructions[j] == null) continue;
                if (names != null) {
                    boolean any = false;
                    for (SSAIndirectionData.Name n : names) {
                        if (this.getIndirectionData().getUse(j, n) == -1) continue;
                        result.append(' ').append(n).append(" -> ").append(this.getIndirectionData().getUse(j, n));
                        any = true;
                    }
                    if (any) {
                        result.append('\n');
                    }
                }
                StringBuilder x = new StringBuilder(j + "   " + this.instructions[j].toString(this.symbolTable));
                StringStuff.padWithSpaces(x, 45);
                result.append((CharSequence)x);
                result.append(this.instructionPosition(j));
                HashMap<Integer, Set<String>> valNames = HashMapFactory.make();
                for (v = 0; v < this.instructions[j].getNumberOfDefs(); ++v) {
                    valNum = this.instructions[j].getDef(v);
                    this.addNames(j, valNames, valNum);
                }
                for (v = 0; v < this.instructions[j].getNumberOfUses(); ++v) {
                    valNum = this.instructions[j].getUse(v);
                    this.addNames(j, valNames, valNum);
                }
                if (!valNames.isEmpty()) {
                    result.append(" [");
                    for (Map.Entry e : valNames.entrySet()) {
                        result.append(e.getKey()).append('=').append(e.getValue());
                    }
                    result.append(']');
                }
                result.append('\n');
                if (names == null) continue;
                boolean any = false;
                for (SSAIndirectionData.Name n : names) {
                    if (this.getIndirectionData().getDef(j, n) == -1) continue;
                    result.append(' ').append(n).append(" <- ").append(this.getIndirectionData().getDef(j, n));
                    any = true;
                }
                if (!any) continue;
                result.append('\n');
            }
            for (SSAPiInstruction pi : Iterator2Iterable.make(bb.iteratePis())) {
                if (pi == null) continue;
                result.append("           ").append(pi.toString(this.symbolTable)).append('\n');
            }
        }
        return result.toString();
    }

    private void addNames(int j, Map<Integer, Set<String>> valNames, int valNum) {
        if (this.getLocalNames(j, valNum) != null && this.getLocalNames(j, valNum).length > 0) {
            if (!valNames.containsKey(valNum)) {
                valNames.put(valNum, HashSetFactory.make());
            }
            for (String s : this.getLocalNames(j, valNum)) {
                valNames.get(valNum).add(s);
            }
        }
    }

    @Override
    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public SSACFG getControlFlowGraph() {
        return this.cfg;
    }

    @Override
    public Iterator<ISSABasicBlock> getBlocks() {
        return this.getControlFlowGraph().iterator();
    }

    public Iterator<? extends SSAInstruction> iteratePhis() {
        return new TwoLevelIterator(){

            @Override
            Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock b) {
                return b.iteratePhis();
            }
        };
    }

    public Iterator<? extends SSAInstruction> iteratePis() {
        return new TwoLevelIterator(){

            @Override
            Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock b) {
                return b.iteratePis();
            }
        };
    }

    public int[] getParameterValueNumbers() {
        return this.symbolTable.getParameterValueNumbers();
    }

    public int getParameter(int i) {
        return this.symbolTable.getParameter(i);
    }

    public TypeReference getParameterType(int i) {
        return this.method.getParameterType(i);
    }

    public int getNumberOfParameters() {
        return this.method.getNumberOfParameters();
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    public Iterator<SSAInstruction> iterateCatchInstructions() {
        return new CatchIterator();
    }

    public void visitNormalInstructions(SSAInstruction.IVisitor v) {
        for (SSAInstruction inst : Iterator2Iterable.make(this.iterateNormalInstructions())) {
            inst.visit(v);
        }
    }

    public void visitAllInstructions(SSAInstruction.IVisitor v) {
        for (SSAInstruction inst : Iterator2Iterable.make(this.iterateAllInstructions())) {
            inst.visit(v);
        }
    }

    public Iterator<SSAInstruction> iterateNormalInstructions() {
        return new NormalIterator();
    }

    public Iterator<SSAInstruction> iterateAllInstructions() {
        return new CompoundIterator<SSAInstruction>(this.iterateNormalInstructions(), new CompoundIterator<SSAInstruction>(this.iterateCatchInstructions(), new CompoundIterator<SSAInstruction>(this.iteratePhis(), this.iteratePis())));
    }

    @Override
    public SSACFG.BasicBlock getExitBlock() {
        return this.cfg.exit();
    }

    public SSAAbstractInvokeInstruction[] getCalls(CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        IntSet s = this.callSiteMapping.getRelated(site.getProgramCounter());
        if (s == null) {
            throw new IllegalArgumentException("no calls at site's pc");
        }
        SSAAbstractInvokeInstruction[] result = new SSAAbstractInvokeInstruction[s.size()];
        int index = 0;
        IntIterator it = s.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            result[index++] = (SSAAbstractInvokeInstruction)this.instructions[i];
        }
        return result;
    }

    public IntSet getCallInstructionIndices(CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        return this.callSiteMapping.getRelated(site.getProgramCounter());
    }

    public SSANewInstruction getNew(NewSiteReference site) {
        Integer i = this.newSiteMapping.get(site);
        return (SSANewInstruction)this.instructions[i];
    }

    public int getNewInstructionIndex(NewSiteReference site) {
        Integer i = this.newSiteMapping.get(site);
        return i;
    }

    @Override
    public SSAInstruction getPEI(ProgramCounter pc) {
        Integer i = this.peiMapping.get(pc);
        return this.instructions[i];
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites() {
        return this.newSiteMapping.keySet().iterator();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites() {
        return new Iterator<CallSiteReference>(){
            private final int limit;
            private int i;
            {
                this.limit = IR.this.callSiteMapping.maxKeyValue();
                this.i = -1;
                this.advance();
            }

            private void advance() {
                while (IR.this.callSiteMapping.getRelatedCount(++this.i) == 0 && this.i <= this.limit) {
                }
            }

            @Override
            public boolean hasNext() {
                return this.i <= this.limit;
            }

            @Override
            public CallSiteReference next() {
                int index = IR.this.callSiteMapping.getRelated(this.i).max();
                this.advance();
                return ((SSAAbstractInvokeInstruction)IR.this.instructions[index]).getCallSite();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ISSABasicBlock[] getBasicBlocksForCall(CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        IntSet s = this.callSiteMapping.getRelated(site.getProgramCounter());
        if (s == null) {
            throw new IllegalArgumentException("invalid site: " + site);
        }
        ISSABasicBlock[] result = new ISSABasicBlock[s.size()];
        int index = 0;
        IntIterator it = s.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            result[index++] = this.getControlFlowGraph().getBlockForInstruction(i);
        }
        return result;
    }

    public ISSABasicBlock getBasicBlockForInstruction(SSAInstruction s) {
        if (this.instruction2Block == null) {
            this.mapInstructions2Blocks();
        }
        return this.instruction2Block.get(s);
    }

    private void mapInstructions2Blocks() {
        this.instruction2Block = HashMapFactory.make();
        for (ISSABasicBlock b : this.cfg) {
            for (SSAInstruction s : b) {
                this.instruction2Block.put(s, b);
            }
        }
    }

    public boolean isEmptyIR() {
        if (this.instructions == null) {
            return true;
        }
        for (SSAInstruction instruction : this.instructions) {
            if (instruction == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getLocalNames(int index, int vn) {
        if (this.getLocalMap() == null) {
            return new String[0];
        }
        return this.getLocalMap().getLocalNames(index, vn);
    }

    public ISSABasicBlock getBasicBlockForCatch(SSAGetCaughtExceptionInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        int bb = instruction.getBasicBlockNumber();
        return this.cfg.getBasicBlock(bb);
    }

    public SSAOptions getOptions() {
        return this.options;
    }

    public static interface SSA2LocalMap {
        public String[] getLocalNames(int var1, int var2);
    }

    private class NormalIterator
    implements Iterator<SSAInstruction> {
        int nextIndex = -1;
        final SSAInstruction[] instructions = IR.this.getInstructions();

        NormalIterator() {
            this.advanceIndex(0);
        }

        private void advanceIndex(int start) {
            for (int i = start; i < this.instructions.length; ++i) {
                if (this.instructions[i] == null) continue;
                this.nextIndex = i;
                return;
            }
            this.nextIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != -1;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        @Override
        public SSAInstruction next() {
            SSAInstruction result = this.instructions[this.nextIndex];
            this.advanceIndex(this.nextIndex + 1);
            return result;
        }
    }

    private class CatchIterator
    implements Iterator<SSAInstruction> {
        private int currentBlockIndex = 0;

        private boolean hasCatch(Object x) {
            return x instanceof SSACFG.ExceptionHandlerBasicBlock && ((SSACFG.ExceptionHandlerBasicBlock)x).getCatchInstruction() != null;
        }

        CatchIterator() {
            if (!this.hasCatch(IR.this.cfg.getNode(0))) {
                this.advanceBlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex != -1;
        }

        @Override
        public SSAInstruction next() {
            SSACFG.ExceptionHandlerBasicBlock bb = (SSACFG.ExceptionHandlerBasicBlock)IR.this.cfg.getNode(this.currentBlockIndex);
            SSAGetCaughtExceptionInstruction result = bb.getCatchInstruction();
            this.advanceBlock();
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        private void advanceBlock() {
            for (int i = this.currentBlockIndex + 1; i < IR.this.cfg.getMaxNumber(); ++i) {
                if (!this.hasCatch(IR.this.cfg.getNode(i))) continue;
                this.currentBlockIndex = i;
                return;
            }
            this.currentBlockIndex = -1;
        }
    }

    private abstract class TwoLevelIterator
    implements Iterator<SSAInstruction> {
        private Iterator<? extends SSAInstruction> currentBlockIterator;
        private int currentBlockIndex = 0;

        abstract Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock var1);

        TwoLevelIterator() {
            this.currentBlockIterator = IR.this.cfg.getNode(0).iteratePhis();
            if (!this.currentBlockIterator.hasNext()) {
                this.advanceBlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex != -1;
        }

        @Override
        public SSAInstruction next() {
            SSAInstruction result = this.currentBlockIterator.next();
            if (!this.currentBlockIterator.hasNext()) {
                this.advanceBlock();
            }
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        private void advanceBlock() {
            for (int i = this.currentBlockIndex + 1; i <= IR.this.cfg.getMaxNumber(); ++i) {
                Iterator<? extends SSAInstruction> it = this.getBlockIterator(IR.this.cfg.getNode(i));
                if (!it.hasNext()) continue;
                this.currentBlockIndex = i;
                this.currentBlockIterator = it;
                return;
            }
            this.currentBlockIterator = null;
            this.currentBlockIndex = -1;
        }
    }
}

