/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrike.shrikeBT.Constants;
import com.ibm.wala.shrike.shrikeBT.Decoder;
import com.ibm.wala.shrike.shrikeBT.Disassembler;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrike.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.CodeReader;
import com.ibm.wala.shrike.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrike.shrikeCT.ConstantValueReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrike.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrike.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrike.shrikeCT.SignatureReader;
import com.ibm.wala.shrike.shrikeCT.SourceFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;

public class ClassPrinter {
    private final PrintWriter w;
    private boolean printLineNumberInfo = true;
    private boolean printConstantPool = true;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ClassPrinter(PrintWriter w) {
        this.w = w;
    }

    public void setPrintLineNumberInfo(boolean b) {
        this.printLineNumberInfo = b;
    }

    public void setPrintConstantPool(boolean b) {
        this.printConstantPool = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ClassInstrumenter ci;
        OfflineInstrumenter oi = new OfflineInstrumenter();
        args = oi.parseStandardArgs(args);
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        ClassPrinter p = new ClassPrinter(w);
        oi.beginTraversal();
        while ((ci = oi.nextClass()) != null) {
            try {
                p.doClass(ci.getReader());
            }
            finally {
                w.flush();
            }
        }
        oi.close();
    }

    private static String makeHex(byte[] bytes, int pos, int len, int padTo) {
        StringBuilder b = new StringBuilder();
        for (int i = pos; i < pos + len; ++i) {
            byte v = bytes[i];
            b.append(hexChars[v >> 4 & 0xF]);
            b.append(hexChars[v & 0xF]);
        }
        while (b.length() < padTo) {
            b.append(' ');
        }
        return b.toString();
    }

    private static String makeChars(byte[] bytes, int pos, int len) {
        StringBuilder b = new StringBuilder();
        for (int i = pos; i < pos + len; ++i) {
            char ch = (char)bytes[i];
            if (ch < ' ' || ch > '\u007f') {
                b.append('.');
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    private static String getClassName(ClassReader cr, int index) throws InvalidClassFileException {
        if (index == 0) {
            return "any";
        }
        return cr.getCP().getCPClass(index);
    }

    private static String dumpFlags(int flags) {
        Field[] fs;
        StringBuilder buf = new StringBuilder();
        Class<Constants> c = Constants.class;
        for (Field element : fs = c.getDeclaredFields()) {
            int val;
            String name = element.getName();
            if (!name.startsWith("ACC_")) continue;
            try {
                val = element.getInt(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new Error(e.getMessage());
            }
            if ((flags & val) == 0) continue;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(name.substring(4).toLowerCase());
        }
        return "0x" + Integer.toString(16, flags) + '(' + buf + ')';
    }

    private void dumpAttributes(ClassReader cr, ClassReader.AttrIterator attrs) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException {
        while (attrs.isValid()) {
            block30: {
                String name;
                block29: {
                    int count;
                    block31: {
                        int[][] locals;
                        int j;
                        String line;
                        int[] map;
                        name = attrs.getName();
                        this.w.write("  " + name + ": @" + Integer.toString(attrs.getRawOffset(), 16) + '\n');
                        if (!name.equals("Code")) break block29;
                        CodeReader code = new CodeReader(attrs);
                        this.w.write("    maxstack: " + code.getMaxStack() + '\n');
                        this.w.write("    maxlocals: " + code.getMaxLocals() + '\n');
                        this.w.write("    bytecode:\n");
                        int[] rawHandlers = code.getRawHandlers();
                        CTDecoder decoder = new CTDecoder(code);
                        decoder.decode();
                        Disassembler disasm = new Disassembler(decoder.getInstructions(), decoder.getHandlers(), decoder.getInstructionsToBytecodes());
                        disasm.disassembleTo("      ", this.w);
                        this.w.write("    exception handlers:\n");
                        for (int e = 0; e < rawHandlers.length; e += 4) {
                            this.w.write("      " + rawHandlers[e] + " to " + rawHandlers[e + 1] + " catch " + ClassPrinter.getClassName(cr, rawHandlers[e + 3]) + " at " + rawHandlers[e + 2] + '\n');
                        }
                        ClassReader.AttrIterator codeAttrs = new ClassReader.AttrIterator();
                        code.initAttributeIterator(codeAttrs);
                        while (codeAttrs.isValid()) {
                            String cName = codeAttrs.getName();
                            this.w.write("    " + cName + ": " + Integer.toString(codeAttrs.getRawOffset(), 16) + '\n');
                            codeAttrs.advance();
                        }
                        if (this.printLineNumberInfo && (map = LineNumberTableReader.makeBytecodeToSourceMap(code)) != null) {
                            this.w.write("    line number map:\n");
                            line = null;
                            count = 0;
                            for (j = 0; j < map.length; ++j) {
                                String line2 = "      " + j + ": " + map[j];
                                if (line == null || !line2.substring(line2.indexOf(58)).equals(line.substring(line.indexOf(58)))) {
                                    if (count > 1) {
                                        this.w.write(" (" + count + " times)\n");
                                    } else if (count > 0) {
                                        this.w.write("\n");
                                    }
                                    count = 0;
                                    line = line2;
                                    this.w.write(line);
                                }
                                ++count;
                            }
                            if (count > 1) {
                                this.w.write(" (" + count + " times)\n");
                            } else if (count > 0) {
                                this.w.write("\n");
                            }
                        }
                        if ((locals = LocalVariableTableReader.makeVarMap(code)) == null) break block30;
                        this.w.write("    local variable map:\n");
                        line = null;
                        count = 0;
                        for (j = 0; j < locals.length; ++j) {
                            int[] vars = locals[j];
                            String line2 = null;
                            if (vars != null) {
                                StringBuilder buf = new StringBuilder();
                                buf.append("      ").append(j).append(':');
                                for (int k = 0; k < vars.length; k += 2) {
                                    if (vars[k] == 0) continue;
                                    String n = cr.getCP().getCPUtf8(vars[k]) + '(' + cr.getCP().getCPUtf8(vars[k + 1]) + ')';
                                    buf.append(' ').append(k / 2).append(':').append(n);
                                }
                                line2 = buf.toString();
                            }
                            if (line == null || line2 == null || !line2.substring(line2.indexOf(58)).equals(line.substring(line.indexOf(58)))) {
                                if (count > 1) {
                                    this.w.write(" (" + count + " times)\n");
                                } else if (count > 0) {
                                    this.w.write("\n");
                                }
                                count = 0;
                                line = line2;
                                if (line != null) {
                                    this.w.write(line);
                                }
                            }
                            if (line == null) continue;
                            ++count;
                        }
                        if (count <= true) break block31;
                        this.w.write(" (" + count + " times)\n");
                        break block30;
                    }
                    if (count <= 0) break block30;
                    this.w.write("\n");
                    break block30;
                }
                if (name.equals("ConstantValue")) {
                    ConstantValueReader cv = new ConstantValueReader(attrs);
                    this.w.write("    value: " + ClassPrinter.getCPItemString(cr.getCP(), cv.getValueCPIndex()) + '\n');
                } else if (name.equals("SourceFile")) {
                    SourceFileReader sr = new SourceFileReader(attrs);
                    this.w.write("    file: " + cr.getCP().getCPUtf8(sr.getSourceFileCPIndex()) + '\n');
                } else if (name.equals("Signature")) {
                    SignatureReader sr = new SignatureReader(attrs);
                    this.w.write("    signature: " + cr.getCP().getCPUtf8(sr.getSignatureCPIndex()) + '\n');
                } else if (AnnotationsReader.isKnownAnnotation(name)) {
                    AnnotationsReader r = new AnnotationsReader(attrs, name);
                    this.printAnnotations(r);
                } else {
                    int len = attrs.getDataSize();
                    int pos = attrs.getDataOffset();
                    while (len > 0) {
                        int amount = Math.min(16, len);
                        this.w.write("    " + ClassPrinter.makeHex(cr.getBytes(), pos, amount, 32) + ' ' + ClassPrinter.makeChars(cr.getBytes(), pos, amount) + '\n');
                        len -= amount;
                        pos += amount;
                    }
                }
            }
            attrs.advance();
        }
    }

    private void printAnnotations(AnnotationsReader r) throws InvalidClassFileException {
        for (AnnotationsReader.AnnotationAttribute annot : r.getAllAnnotations()) {
            this.w.write("    Annotation type: " + annot.type + '\n');
        }
    }

    private static String getCPItemString(ConstantPoolParser cp, int i) throws InvalidClassFileException {
        byte t = cp.getItemType(i);
        switch (t) {
            case 1: {
                return "Utf8 " + ClassPrinter.quoteString(cp.getCPUtf8(i));
            }
            case 7: {
                return "Class " + cp.getCPClass(i);
            }
            case 8: {
                return "String " + ClassPrinter.quoteString(cp.getCPString(i));
            }
            case 3: {
                return "Integer " + cp.getCPInt(i);
            }
            case 4: {
                return "Float " + cp.getCPFloat(i);
            }
            case 6: {
                return "Double " + cp.getCPDouble(i);
            }
            case 5: {
                return "Long " + cp.getCPLong(i);
            }
            case 10: {
                return "Method " + cp.getCPRefClass(i) + ' ' + cp.getCPRefName(i) + ' ' + cp.getCPRefType(i);
            }
            case 9: {
                return "Field " + cp.getCPRefClass(i) + ' ' + cp.getCPRefName(i) + ' ' + cp.getCPRefType(i);
            }
            case 11: {
                return "InterfaceMethod " + cp.getCPRefClass(i) + ' ' + cp.getCPRefName(i) + ' ' + cp.getCPRefType(i);
            }
            case 12: {
                return "NameAndType " + cp.getCPNATType(i) + ' ' + cp.getCPNATName(i);
            }
        }
        return "Unknown type " + t;
    }

    private static String quoteString(String string) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    if (ch >= ' ' && ch <= '\u007f') {
                        buf.append(ch);
                        continue block7;
                    }
                    buf.append("\\u");
                    String h = ClassPrinter.makeHex(new byte[]{(byte)(ch >> 8), (byte)ch}, 0, 2, 0);
                    for (int j = 4 - h.length(); j > 0; --j) {
                        buf.append('0');
                    }
                    buf.append(h);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public void doClass(ClassReader cr) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException {
        if (cr == null) {
            throw new IllegalArgumentException("cr is null");
        }
        this.w.write("Class: " + cr.getName() + '\n');
        if (this.printConstantPool) {
            ConstantPoolParser cp = cr.getCP();
            for (int i = 1; i < cp.getItemCount(); ++i) {
                byte t = cp.getItemType(i);
                if (t <= 0) continue;
                this.w.write("  Constant pool item " + i + ": ");
                this.w.write(ClassPrinter.getCPItemString(cp, i));
                this.w.write("\n");
            }
        }
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        cr.initClassAttributeIterator(attrs);
        this.dumpAttributes(cr, attrs);
        this.w.write("\n");
        int fieldCount = cr.getFieldCount();
        this.w.write(fieldCount + " fields:\n");
        for (int i = 0; i < fieldCount; ++i) {
            this.w.write(cr.getFieldName(i) + ' ' + cr.getFieldType(i) + ' ' + ClassPrinter.dumpFlags(cr.getFieldAccessFlags(i)) + '\n');
            cr.initFieldAttributeIterator(i, attrs);
            this.dumpAttributes(cr, attrs);
        }
        this.w.write("\n");
        int methodCount = cr.getMethodCount();
        this.w.write(methodCount + " methods:\n");
        for (int i = 0; i < methodCount; ++i) {
            this.w.write(cr.getMethodName(i) + ' ' + cr.getMethodType(i) + ' ' + ClassPrinter.dumpFlags(cr.getMethodAccessFlags(i)) + '\n');
            cr.initMethodAttributeIterator(i, attrs);
            this.dumpAttributes(cr, attrs);
        }
        this.w.write("\n");
    }
}

