/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrike.shrikeBT.Decoder;
import com.ibm.wala.shrike.shrikeBT.Disassembler;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrike.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrike.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.CTUtils;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.CodeReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;

public class BatchVerifier {
    private static boolean disasm = false;
    private static final ClassHierarchyStore store = new ClassHierarchyStore();
    private static int errors = 0;

    public static void main(String[] args) throws Exception {
        OfflineInstrumenter oi = new OfflineInstrumenter();
        for (String arg : args = oi.parseStandardArgs(args)) {
            if (!arg.equals("-d")) continue;
            disasm = true;
            break;
        }
        try (PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter("report", false)));){
            ClassInstrumenter ci;
            oi.beginTraversal();
            while ((ci = oi.nextClass()) != null) {
                ClassReader cr = ci.getReader();
                CTUtils.addClassToHierarchy(store, cr);
            }
            oi.beginTraversal();
            while ((ci = oi.nextClass()) != null) {
                BatchVerifier.doClass(ci.getReader(), w);
            }
        }
        oi.close();
        if (errors > 0) {
            System.err.println(errors + " error" + (errors > 1 ? "s" : "") + " detected");
        }
    }

    private static void doClass(ClassReader cr, PrintWriter w) throws Exception {
        int methodCount = cr.getMethodCount();
        w.write("Verifying " + cr.getName() + '\n');
        w.flush();
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        block4: for (int i = 0; i < methodCount; ++i) {
            cr.initMethodAttributeIterator(i, iter);
            while (iter.isValid()) {
                if (iter.getName().equals("Code")) {
                    w.write("Verifying " + cr.getName() + '.' + cr.getMethodName(i) + ' ' + cr.getMethodType(i) + ":\n");
                    w.flush();
                    CodeReader code = new CodeReader(iter);
                    CTDecoder d = new CTDecoder(code);
                    try {
                        d.decode();
                    }
                    catch (Decoder.InvalidBytecodeException e) {
                        throw new InvalidClassFileException(code.getRawOffset(), e.getMessage());
                    }
                    MethodData md = new MethodData(d, cr.getMethodAccessFlags(i), CTDecoder.convertClassToType(cr.getName()), cr.getMethodName(i), cr.getMethodType(i));
                    if (disasm) {
                        w.write("ShrikeBT code:\n");
                        new Disassembler(md).disassembleTo(w);
                        w.flush();
                    }
                    Verifier v = new Verifier(md);
                    try {
                        v.verify();
                    }
                    catch (Analyzer.FailureException e) {
                        w.println("ERROR: VERIFICATION FAILED");
                        e.printStackTrace(w);
                        e.printPath(w);
                        ++errors;
                        w.flush();
                    }
                    continue block4;
                }
                iter.advance();
            }
        }
    }
}

