/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.info;

import com.ibm.wala.shrike.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrike.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.Util;

public class LocalAllocator
implements MethodData.Results {
    private static final String key = LocalAllocator.class.getName();
    private int nextLocal;

    LocalAllocator(MethodData info) {
        this.recalculateFrom(info);
    }

    private void recalculateFrom(MethodData info) {
        IInstruction[] instructions = info.getInstructions();
        final int[] max = new int[]{Util.getParamsWordSize(info.getSignature()) + (info.getIsStatic() ? 0 : 1)};
        IInstruction.Visitor visitor = new IInstruction.Visitor(){

            @Override
            public void visitLocalLoad(ILoadInstruction instruction) {
                int v = instruction.getVarIndex() + Util.getWordSize(instruction.getType());
                if (v > max[0]) {
                    max[0] = v;
                }
            }

            @Override
            public void visitLocalStore(IStoreInstruction instruction) {
                int v = instruction.getVarIndex() + Util.getWordSize(instruction.getType());
                if (v > max[0]) {
                    max[0] = v;
                }
            }
        };
        for (IInstruction instruction : instructions) {
            instruction.visit(visitor);
        }
        this.nextLocal = max[0];
    }

    private int allocateLocals(int count) {
        int r = this.nextLocal;
        this.nextLocal += count;
        return r;
    }

    @Override
    public boolean notifyUpdate(MethodData info, IInstruction[] newInstructions, ExceptionHandler[][] newHandlers, int[] newInstructionMap) {
        return false;
    }

    public static int allocate(MethodData info, int count) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        LocalAllocator l = (LocalAllocator)info.getInfo(key);
        if (l == null) {
            l = new LocalAllocator(info);
            info.putInfo(key, l);
        }
        return l.allocateLocals(count);
    }

    public static int allocate(MethodData info, String type) throws IllegalArgumentException {
        return LocalAllocator.allocate(info, type == null ? 2 : (int)Util.getWordSize(type));
    }

    public static int allocate(MethodData info) throws IllegalArgumentException {
        return LocalAllocator.allocate(info, null);
    }
}

