/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.Decoder;
import com.ibm.wala.shrike.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class MethodData {
    private final HashMap<Object, Results> map = new HashMap();
    private final int access;
    private final String classType;
    private final String name;
    private final String signature;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private int[] instructionsToBytecodes;
    private boolean hasChanged = false;

    public static MethodData makeWithDefaultHandlersAndInstToBytecodes(int access, String classType, String name, String signature, IInstruction[] instructions) {
        ExceptionHandler[][] handlers = new ExceptionHandler[instructions.length][];
        Arrays.fill((Object[])handlers, new ExceptionHandler[0]);
        int[] i2b = new int[instructions.length];
        Arrays.setAll(i2b, i -> i);
        return new MethodData(access, classType, name, signature, instructions, handlers, i2b);
    }

    public MethodData(int access, String classType, String name, String signature, IInstruction[] instructions, ExceptionHandler[][] handlers, int[] instructionsToBytecodes) {
        this.classType = classType;
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.instructions = instructions;
        this.handlers = handlers;
        this.instructionsToBytecodes = instructionsToBytecodes;
        if (instructions == null) {
            throw new IllegalArgumentException("Instruction array cannot be null");
        }
        if (handlers == null) {
            throw new IllegalArgumentException("Handler array cannot be null");
        }
        if (instructionsToBytecodes == null) {
            throw new IllegalArgumentException("InstructionToBytecodes array cannot be null");
        }
        if (instructions.length != handlers.length) {
            throw new IllegalArgumentException("Handlers array must be the same length as the instructions");
        }
        if (instructions.length != instructionsToBytecodes.length) {
            throw new IllegalArgumentException("Bytecode map array must be the same length as the instructions");
        }
    }

    public MethodData(Decoder d, int access, String classType, String name, String signature) throws NullPointerException {
        this(access, classType, name, signature, d.getInstructions(), d.getHandlers(), d.getInstructionsToBytecodes());
    }

    public void setHasChanged() {
        this.hasChanged = true;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    public int getAccess() {
        return this.access;
    }

    public String getClassType() {
        return this.classType;
    }

    public boolean getIsStatic() {
        return (this.access & 8) != 0;
    }

    public boolean getIsSynchronized() {
        return (this.access & 0x20) != 0;
    }

    public ExceptionHandler[][] getHandlers() {
        return this.handlers;
    }

    public IInstruction[] getInstructions() {
        return this.instructions;
    }

    public int[] getInstructionsToBytecodes() {
        return this.instructionsToBytecodes;
    }

    public Results getInfo(Object key) {
        return this.map.get(key);
    }

    public void putInfo(Object key, Results value) {
        this.map.put(key, value);
    }

    void update(IInstruction[] instructions, ExceptionHandler[][] handlers, int[] newInstructionMap, int[] instructionsToBytecodes) {
        Iterator<Object> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Results r = this.map.get(key);
            if (!r.notifyUpdate(this, instructions, handlers, newInstructionMap)) continue;
            i.remove();
        }
        this.instructions = instructions;
        this.handlers = handlers;
        this.instructionsToBytecodes = instructionsToBytecodes;
        this.hasChanged = true;
    }

    public boolean getHasChanged() {
        return this.hasChanged;
    }

    public String toString() {
        return this.getClassType() + '.' + this.getName() + this.getSignature();
    }

    public static interface Results {
        public boolean notifyUpdate(MethodData var1, IInstruction[] var2, ExceptionHandler[][] var3, int[] var4);
    }
}

