/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis.dataflow;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorKillAll;
import com.ibm.wala.dataflow.graph.BitVectorKillGen;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Map;

public class ContextInsensitiveReachingDefs {
    private final ExplodedInterproceduralCFG icfg;
    private final OrdinalSetMapping<Pair<CGNode, Integer>> putInstrNumbering;
    private final IClassHierarchy cha;
    private final Map<IField, BitVector> staticField2DefStatements = HashMapFactory.make();
    private static final boolean VERBOSE = true;

    public ContextInsensitiveReachingDefs(ExplodedInterproceduralCFG icfg, IClassHierarchy cha) {
        this.icfg = icfg;
        this.cha = cha;
        this.putInstrNumbering = this.numberPutStatics();
    }

    private OrdinalSetMapping<Pair<CGNode, Integer>> numberPutStatics() {
        ArrayList<Pair<CGNode, Integer>> putInstrs = new ArrayList<Pair<CGNode, Integer>>();
        for (CGNode node : this.icfg.getCallGraph()) {
            IR ir = node.getIR();
            if (ir == null) continue;
            SSAInstruction[] instructions = ir.getInstructions();
            for (int i = 0; i < instructions.length; ++i) {
                SSAInstruction instruction = instructions[i];
                if (!(instruction instanceof SSAPutInstruction) || !((SSAPutInstruction)instruction).isStatic()) continue;
                SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                int instrNum = putInstrs.size();
                putInstrs.add(Pair.make(node, i));
                IField field = this.cha.resolveField(putInstr.getDeclaredField());
                assert (field != null);
                BitVector bv = this.staticField2DefStatements.get(field);
                if (bv == null) {
                    bv = new BitVector();
                    this.staticField2DefStatements.put(field, bv);
                }
                bv.set(instrNum);
            }
        }
        ObjectArrayMapping<Pair<CGNode, Integer>> result = new ObjectArrayMapping<Pair<CGNode, Integer>>(putInstrs.toArray(new Pair[0]));
        return result;
    }

    public BitVectorSolver<BasicBlockInContext<IExplodedBasicBlock>> analyze() {
        BitVectorSolver<BasicBlockInContext<IExplodedBasicBlock>> solver;
        block3: {
            BitVectorFramework<BasicBlockInContext<IExplodedBasicBlock>, Pair<CGNode, Integer>> framework = new BitVectorFramework<BasicBlockInContext<IExplodedBasicBlock>, Pair<CGNode, Integer>>(this.icfg, new TransferFunctions(), this.putInstrNumbering);
            solver = new BitVectorSolver<BasicBlockInContext<IExplodedBasicBlock>>((IKilldallFramework<BasicBlockInContext<IExplodedBasicBlock>, BitVectorVariable>)framework);
            try {
                solver.solve(null);
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        for (BasicBlockInContext ebb : this.icfg) {
            System.out.println(ebb);
            System.out.println(((IExplodedBasicBlock)ebb.getDelegate()).getInstruction());
            System.out.println(solver.getIn(ebb));
            System.out.println(solver.getOut(ebb));
        }
        return solver;
    }

    public Pair<CGNode, Integer> getNodeAndInstrForNumber(int num) {
        return this.putInstrNumbering.getMappedObject(num);
    }

    private class TransferFunctions
    implements ITransferFunctionProvider<BasicBlockInContext<IExplodedBasicBlock>, BitVectorVariable> {
        private TransferFunctions() {
        }

        @Override
        public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
            return BitVectorUnion.instance();
        }

        @Override
        public UnaryOperator<BitVectorVariable> getNodeTransferFunction(BasicBlockInContext<IExplodedBasicBlock> node) {
            IExplodedBasicBlock ebb = node.getDelegate();
            SSAInstruction instruction = ebb.getInstruction();
            int instructionIndex = ebb.getFirstInstructionIndex();
            CGNode cgNode = node.getNode();
            if (instruction instanceof SSAPutInstruction && ((SSAPutInstruction)instruction).isStatic()) {
                SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                IField field = ContextInsensitiveReachingDefs.this.cha.resolveField(putInstr.getDeclaredField());
                assert (field != null);
                BitVector kill = (BitVector)ContextInsensitiveReachingDefs.this.staticField2DefStatements.get(field);
                BitVector gen = new BitVector();
                gen.set(ContextInsensitiveReachingDefs.this.putInstrNumbering.getMappedIndex(Pair.make(cgNode, instructionIndex)));
                return new BitVectorKillGen(kill, gen);
            }
            return BitVectorIdentity.instance();
        }

        @Override
        public boolean hasEdgeTransferFunctions() {
            return true;
        }

        @Override
        public boolean hasNodeTransferFunctions() {
            return true;
        }

        @Override
        public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
            if (this.isCallToReturnEdge(src, dst)) {
                return BitVectorKillAll.instance();
            }
            return BitVectorIdentity.instance();
        }

        private boolean isCallToReturnEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
            SSAInstruction srcInst = src.getDelegate().getInstruction();
            return srcInst instanceof SSAAbstractInvokeInstruction && src.getNode().equals(dst.getNode());
        }
    }
}

