/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFlowGraph
extends SlowSparseNumberedLabeledGraph<Object, IFlowLabel>
implements IFlowGraph {
    private static final long serialVersionUID = 1L;
    private static final IFlowLabel defaultLabel = new IFlowLabel(){

        @Override
        public IFlowLabel bar() {
            return defaultLabel;
        }

        @Override
        public boolean isBarred() {
            return false;
        }

        @Override
        public void visit(IFlowLabel.IFlowLabelVisitor v, Object dst) {
        }
    };
    protected final Map<PointerKey, SSAAbstractInvokeInstruction> callDefs = HashMapFactory.make();
    protected final Map<PointerKey, Set<SSAAbstractInvokeInstruction>> callParams = HashMapFactory.make();
    protected final Map<PointerKey, CGNode> params = HashMapFactory.make();
    protected final Map<PointerKey, CGNode> returns = HashMapFactory.make();
    protected final MemoryAccessMap mam;
    protected final HeapModel heapModel;
    protected final IClassHierarchy cha;
    protected final CallGraph cg;

    public AbstractFlowGraph(MemoryAccessMap mam, HeapModel heapModel, IClassHierarchy cha, CallGraph cg) {
        super(defaultLabel);
        this.mam = mam;
        this.heapModel = heapModel;
        this.cha = cha;
        this.cg = cg;
    }

    @Override
    public void visitSuccs(Object node, IFlowLabel.IFlowLabelVisitor v) {
        for (IFlowLabel label : Iterator2Iterable.make(this.getSuccLabels(node))) {
            for (Object succNode : Iterator2Iterable.make(this.getSuccNodes(node, label))) {
                label.visit(v, succNode);
            }
        }
    }

    @Override
    public void visitPreds(Object node, IFlowLabel.IFlowLabelVisitor v) {
        for (IFlowLabel label : Iterator2Iterable.make(this.getPredLabels(node))) {
            for (Object predNode : Iterator2Iterable.make(this.getPredNodes(node, label))) {
                label.visit(v, predNode);
            }
        }
    }

    protected void addNodesForInvocations(CGNode node, IR ir) {
        for (CallSiteReference site : Iterator2Iterable.make(ir.iterateCallSites())) {
            SSAAbstractInvokeInstruction[] calls;
            for (SSAAbstractInvokeInstruction invokeInstr : calls = ir.getCalls(site)) {
                for (int i = 0; i < invokeInstr.getNumberOfUses(); ++i) {
                    PointerKey use = this.heapModel.getPointerKeyForLocal(node, invokeInstr.getUse(i));
                    this.addNode(use);
                    Set<SSAAbstractInvokeInstruction> s = MapUtil.findOrCreateSet(this.callParams, use);
                    s.add(invokeInstr);
                }
                if (invokeInstr.hasDef()) {
                    PointerKey def = this.heapModel.getPointerKeyForLocal(node, invokeInstr.getDef());
                    this.addNode(def);
                    this.callDefs.put(def, invokeInstr);
                }
                PointerKey exc = this.heapModel.getPointerKeyForLocal(node, invokeInstr.getException());
                this.addNode(exc);
                this.callDefs.put(exc, invokeInstr);
            }
        }
    }

    @Override
    public boolean isParam(LocalPointerKey pk) {
        return this.params.get(pk) != null;
    }

    @Override
    public Iterator<SSAAbstractInvokeInstruction> getInstrsPassingParam(LocalPointerKey pk) {
        Set<SSAAbstractInvokeInstruction> instrs = this.callParams.get(pk);
        if (instrs == null) {
            return EmptyIterator.instance();
        }
        return instrs.iterator();
    }

    @Override
    public SSAAbstractInvokeInstruction getInstrReturningTo(LocalPointerKey pk) {
        return this.callDefs.get(pk);
    }

    @Override
    public Iterator<? extends Object> getWritesToStaticField(StaticFieldKey sfk) throws IllegalArgumentException {
        if (sfk == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> fieldWrites = this.mam.getStaticFieldWrites(sfk.getField());
        for (MemoryAccess a : fieldWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        return this.getSuccNodes(sfk, AssignGlobalLabel.v());
    }

    @Override
    public Iterator<? extends Object> getReadsOfStaticField(StaticFieldKey sfk) throws IllegalArgumentException {
        if (sfk == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> fieldReads = this.mam.getStaticFieldReads(sfk.getField());
        for (MemoryAccess a : fieldReads) {
            this.addSubgraphForNode(a.getNode());
        }
        return this.getPredNodes(sfk, AssignGlobalLabel.v());
    }

    @Override
    public Iterator<PointerKey> getWritesToInstanceField(PointerKey pk, IField f) {
        if (f == ArrayContents.v()) {
            return this.getArrayWrites(pk);
        }
        pk = AbstractFlowGraph.convertPointerKeyToHeapModel(pk, this.mam.getHeapModel());
        Collection<MemoryAccess> writes = this.mam.getFieldWrites(pk, f);
        for (MemoryAccess a : writes) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> written = new ArrayList<PointerKey>();
        for (MemoryAccess a : writes) {
            IR ir = a.getNode().getIR();
            SSAPutInstruction s = (SSAPutInstruction)ir.getInstructions()[a.getInstructionIndex()];
            if (s == null) continue;
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getVal());
            written.add(r);
        }
        return written.iterator();
    }

    public static PointerKey convertPointerKeyToHeapModel(PointerKey pk, HeapModel h) {
        if (pk == null) {
            throw new IllegalArgumentException("null pk");
        }
        if (pk instanceof LocalPointerKey) {
            LocalPointerKey lpk = (LocalPointerKey)pk;
            return h.getPointerKeyForLocal(lpk.getNode(), lpk.getValueNumber());
        }
        if (pk instanceof ArrayContentsKey) {
            ArrayContentsKey ack = (ArrayContentsKey)pk;
            InstanceKey ik = ack.getInstanceKey();
            if (ik instanceof NormalAllocationInNode) {
                NormalAllocationInNode nain = (NormalAllocationInNode)ik;
                ik = h.getInstanceKeyForAllocation(nain.getNode(), nain.getSite());
            } else assert (false) : "need to handle " + ik.getClass();
            return h.getPointerKeyForArrayContents(ik);
        }
        if (pk instanceof ReturnValueKey) {
            ReturnValueKey rvk = (ReturnValueKey)pk;
            return h.getPointerKeyForReturnValue(rvk.getNode());
        }
        throw new UnsupportedOperationException("need to handle " + pk.getClass());
    }

    @Override
    public Iterator<PointerKey> getReadsOfInstanceField(PointerKey pk, IField f) {
        if (f == ArrayContents.v()) {
            return this.getArrayReads(pk);
        }
        pk = AbstractFlowGraph.convertPointerKeyToHeapModel(pk, this.mam.getHeapModel());
        Collection<MemoryAccess> reads = this.mam.getFieldReads(pk, f);
        for (MemoryAccess a : reads) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> readInto = new ArrayList<PointerKey>();
        for (MemoryAccess a : reads) {
            IR ir = a.getNode().getIR();
            SSAGetInstruction s = (SSAGetInstruction)ir.getInstructions()[a.getInstructionIndex()];
            if (s == null) continue;
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getDef());
            readInto.add(r);
        }
        return readInto.iterator();
    }

    Iterator<PointerKey> getArrayWrites(PointerKey arrayRef) {
        arrayRef = AbstractFlowGraph.convertPointerKeyToHeapModel(arrayRef, this.mam.getHeapModel());
        Collection<MemoryAccess> arrayWrites = this.mam.getArrayWrites(arrayRef);
        for (MemoryAccess a : arrayWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> written = new ArrayList<PointerKey>();
        for (MemoryAccess a : arrayWrites) {
            CGNode node = a.getNode();
            IR ir = node.getIR();
            SSAInstruction instruction = ir.getInstructions()[a.getInstructionIndex()];
            if (instruction == null) continue;
            if (instruction instanceof SSAArrayStoreInstruction) {
                SSAArrayStoreInstruction s = (SSAArrayStoreInstruction)instruction;
                PointerKey r = this.heapModel.getPointerKeyForLocal(node, s.getValue());
                written.add(r);
                continue;
            }
            if (instruction instanceof SSANewInstruction) {
                DemandPointerFlowGraph.NewMultiDimInfo multiDimInfo = DemandPointerFlowGraph.getInfoForNewMultiDim((SSANewInstruction)instruction, this.heapModel, node);
                for (Pair<PointerKey, PointerKey> arrStoreInstr : multiDimInfo.arrStoreInstrs) {
                    written.add((PointerKey)arrStoreInstr.snd);
                }
                continue;
            }
            Assertions.UNREACHABLE();
        }
        return written.iterator();
    }

    protected Iterator<PointerKey> getArrayReads(PointerKey arrayRef) {
        arrayRef = AbstractFlowGraph.convertPointerKeyToHeapModel(arrayRef, this.mam.getHeapModel());
        Collection<MemoryAccess> arrayReads = this.mam.getArrayReads(arrayRef);
        for (MemoryAccess a : arrayReads) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> read = new ArrayList<PointerKey>();
        for (MemoryAccess a : arrayReads) {
            IR ir = a.getNode().getIR();
            SSAArrayLoadInstruction s = (SSAArrayLoadInstruction)ir.getInstructions()[a.getInstructionIndex()];
            if (s == null) continue;
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getDef());
            read.add(r);
        }
        return read.iterator();
    }

    protected void addNodePassthruExceptionConstraints(CGNode node, IR ir) {
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        IClass c = node.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable);
        this.addExceptionDefConstraints(ir, node, peis, exception, Collections.singleton(c));
    }

    protected void addExceptionDefConstraints(IR ir, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set<IClass> catchClasses) {
        for (ProgramCounter peiLoc : peis) {
            Collection<TypeReference> types;
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e, AssignLabel.noFilter());
            } else if (pei instanceof SSAAbstractThrowInstruction) {
                s = (SSAAbstractThrowInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e, AssignLabel.noFilter());
            }
            if ((types = pei.getExceptionTypes()) == null) continue;
            for (TypeReference type : types) {
                InstanceKey ik;
                if (type == null || (ik = this.heapModel.getInstanceKeyForPEI(node, peiLoc, type)) == null) continue;
                if (!(ik instanceof ConcreteTypeKey)) assert (ik instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + ik;
                ConcreteTypeKey ck = (ConcreteTypeKey)ik;
                IClass klass = ck.getType();
                if (!PropagationCallGraphBuilder.catches(catchClasses, klass, this.cha)) continue;
                this.addNode(exceptionVar);
                this.addNode(ik);
                this.addEdge(exceptionVar, ik, NewLabel.v());
            }
        }
    }

    protected void addNodeConstantConstraints(CGNode node, IR ir) {
        SymbolTable symbolTable = ir.getSymbolTable();
        for (int i = 1; i <= symbolTable.getMaxValueNumber(); ++i) {
            InstanceKey ik;
            Object v;
            if (!symbolTable.isConstant(i) || (v = symbolTable.getConstantValue(i)) instanceof Number) continue;
            Object S = symbolTable.getConstantValue(i);
            TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
            if (type == null || (ik = this.heapModel.getInstanceKeyForConstant(type, S)) == null) continue;
            PointerKey pk = this.heapModel.getPointerKeyForLocal(node, i);
            this.addNode(pk);
            this.addNode(ik);
            this.addEdge(pk, ik, NewLabel.v());
        }
    }
}

