/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

class ThisFilteringHeapModel
implements HeapModel {
    private final HeapModel delegate;
    private final IClassHierarchy cha;

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.delegate.getClassHierarchy();
    }

    @Override
    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
        return this.delegate.getFilteredPointerKeyForLocal(node, valueNumber, filter);
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        return this.delegate.getInstanceKeyForAllocation(node, allocation);
    }

    @Override
    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        return this.delegate.getInstanceKeyForMetadataObject(obj, objType);
    }

    public InstanceKey getInstanceKeyForConstant(TypeReference type, Object S) {
        return this.delegate.getInstanceKeyForConstant(type, S);
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        return this.delegate.getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) {
        return this.delegate.getInstanceKeyForPEI(node, instr, type);
    }

    @Override
    public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
        return this.delegate.getPointerKeyForArrayContents(I);
    }

    @Override
    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return this.delegate.getPointerKeyForExceptionalReturnValue(node);
    }

    @Override
    public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField field) {
        return this.delegate.getPointerKeyForInstanceField(I, field);
    }

    @Override
    public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        if (!node.getMethod().isStatic() && valueNumber == 1) {
            return this.delegate.getFilteredPointerKeyForLocal(node, valueNumber, this.getFilter(node));
        }
        return this.delegate.getPointerKeyForLocal(node, valueNumber);
    }

    private FilteredPointerKey.TypeFilter getFilter(CGNode target) {
        FilteredPointerKey.TypeFilter filter = (FilteredPointerKey.TypeFilter)target.getContext().get(ContextKey.PARAMETERS[0]);
        if (filter != null) {
            return filter;
        }
        IClass C = this.getReceiverClass(target.getMethod());
        return new FilteredPointerKey.SingleClassFilter(C);
    }

    private IClass getReceiverClass(IMethod method) {
        TypeReference formalType = method.getParameterType(0);
        IClass C = this.cha.lookupClass(formalType);
        if (method.isStatic()) {
            Assertions.UNREACHABLE("asked for receiver of static method " + method);
        }
        if (C == null) {
            Assertions.UNREACHABLE("no class found for " + formalType + " recv of " + method);
        }
        return C;
    }

    @Override
    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return this.delegate.getPointerKeyForReturnValue(node);
    }

    @Override
    public PointerKey getPointerKeyForStaticField(IField f) {
        return this.delegate.getPointerKeyForStaticField(f);
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        return this.delegate.iteratePointerKeys();
    }

    public ThisFilteringHeapModel(HeapModel delegate, IClassHierarchy cha) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate null");
        }
        this.delegate = delegate;
        this.cha = cha;
    }
}

