/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.graph;

import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;

public class BitVectorUnionConstant
extends UnaryOperator<BitVectorVariable> {
    private final int c;

    public BitVectorUnionConstant(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("Invalid c: " + c);
        }
        this.c = c;
    }

    @Override
    public byte evaluate(BitVectorVariable lhs, BitVectorVariable rhs) throws IllegalArgumentException {
        if (lhs == null) {
            throw new IllegalArgumentException("lhs == null");
        }
        BitVectorVariable U = new BitVectorVariable();
        U.copyState(lhs);
        U.addAll(rhs);
        U.set(this.c);
        if (!lhs.sameValue(U)) {
            lhs.copyState(U);
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "U " + this.c;
    }

    @Override
    public int hashCode() {
        return 9901 * this.c;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BitVectorUnionConstant) {
            BitVectorUnionConstant other = (BitVectorUnionConstant)o;
            return this.c == other.c;
        }
        return false;
    }
}

