/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.ssa;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.PrimitiveAssignability;
import com.ibm.wala.core.util.ssa.ClassLookupException;
import com.ibm.wala.core.util.ssa.IInstantiator;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ParameterAccessor {
    private static final boolean DEBUG = false;
    private final BasedOn base;
    private final MethodReference mRef;
    private final IMethod method;
    private final int implicitThis;
    private final int descriptorOffset;
    private final int numberOfParameters;

    public ParameterAccessor(MethodReference mRef, IClassHierarchy cha) {
        boolean hasImplicitThis;
        if (mRef == null) {
            throw new IllegalArgumentException("Can't read the arguments from null.");
        }
        this.mRef = mRef;
        this.method = null;
        this.base = BasedOn.METHOD_REFERENCE;
        this.numberOfParameters = mRef.getNumberOfParameters();
        Set<IMethod> targets = cha.getPossibleTargets(mRef);
        if (targets.size() < 1) {
            ParameterAccessor.warn("Unable to look up the method {} starting extensive search...", mRef);
            targets = new HashSet<IMethod>();
            TypeReference mClass = mRef.getDeclaringClass();
            Selector mSel = mRef.getSelector();
            HashSet<IClass> testClasses = new HashSet<IClass>();
            for (IClassLoader loader : cha.getLoaders()) {
                IClass iClass = loader.lookupClass(mClass.getName());
                if (iClass == null) continue;
                testClasses.add(iClass);
            }
            IClass lookedUp = cha.lookupClass(mClass);
            if (lookedUp != null) {
                ParameterAccessor.debug("Found using cha.lookupClass()", new Object[0]);
                testClasses.add(lookedUp);
            }
            ParameterAccessor.info("Searching the classes {} for the method", testClasses);
            for (IClass testClass : testClasses) {
                IMethod cand = testClass.getMethod(mSel);
                if (cand == null) continue;
                targets.add(cand);
            }
            if (targets.size() < 1) {
                ParameterAccessor.warn("Still no candidates for the method - continuing with super-classes (TODO)", new Object[0]);
                for (IClass testClass : testClasses) {
                    ParameterAccessor.info("Known Methods in " + testClass, new Object[0]);
                    for (IMethod iMethod : testClass.getAllMethods()) {
                        System.out.println(iMethod);
                        ParameterAccessor.info("\t" + iMethod, new Object[0]);
                    }
                }
                throw new IllegalStateException("Unable to look up the method " + mRef);
            }
        }
        Iterator<IMethod> it = targets.iterator();
        boolean testStatic = it.next().isStatic();
        while (it.hasNext()) {
            boolean tmpStatic = it.next().isStatic();
            if (testStatic == tmpStatic) continue;
            throw new IllegalStateException("The ClassHierarchy knows multiple (" + targets.size() + ") targets for " + mRef + ". The targets contradict themselves if they have an implicit this!");
        }
        boolean bl = hasImplicitThis = !testStatic;
        if (hasImplicitThis) {
            ParameterAccessor.info("The method {} has an implicit this pointer", mRef);
            this.implicitThis = 1;
            this.descriptorOffset = -1;
        } else {
            ParameterAccessor.info("The method {} has no implicit this pointer", mRef);
            this.implicitThis = -1;
            this.descriptorOffset = 0;
        }
    }

    public ParameterAccessor(MethodReference mRef, boolean hasImplicitThis) {
        if (mRef == null) {
            throw new IllegalArgumentException("Can't read the arguments from null.");
        }
        this.mRef = mRef;
        this.method = null;
        this.base = BasedOn.METHOD_REFERENCE;
        this.numberOfParameters = mRef.getNumberOfParameters();
        if (hasImplicitThis) {
            ParameterAccessor.info("The method {} has an implicit this pointer", mRef);
            this.implicitThis = 1;
            this.descriptorOffset = -1;
        } else {
            ParameterAccessor.info("The method {} has no implicit this pointer", mRef);
            this.implicitThis = -1;
            this.descriptorOffset = 0;
        }
    }

    public ParameterAccessor(IMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Can't read the arguments from null.");
        }
        this.mRef = null;
        this.method = method;
        this.base = BasedOn.IMETHOD;
        this.numberOfParameters = method.getReference().getNumberOfParameters();
        if (method.isStatic() && !method.isInit()) {
            assert (method.getNumberOfParameters() == method.getReference().getNumberOfParameters()) : "WTF!" + method;
            this.implicitThis = -1;
            this.descriptorOffset = 0;
        } else {
            assert (method.getNumberOfParameters() == 1 + method.getReference().getNumberOfParameters()) : "WTF!" + method;
            this.implicitThis = 1;
            this.descriptorOffset = -1;
        }
    }

    public Parameter getParameter(int no) {
        int newNo = this.getParameterNo(no);
        switch (this.base) {
            case IMETHOD: {
                return new Parameter(newNo, null, this.method.getParameterType(no), ParamerterDisposition.PARAM, this.base, this.method.getReference(), this.descriptorOffset);
            }
            case METHOD_REFERENCE: {
                return new Parameter(newNo, null, this.mRef.getParameterType(no - 1), ParamerterDisposition.PARAM, this.base, this.mRef, this.descriptorOffset);
            }
        }
        throw new UnsupportedOperationException("No implementation of getParameter() for base " + (Object)((Object)this.base));
    }

    public int getParameterNo(int no) {
        if (no == 0) {
            throw new IllegalArgumentException("Parameter numbers start with 1. Use getThis() to access a potential implicit this.");
        }
        if (no < 0 || no > this.numberOfParameters) {
            throw new ArrayIndexOutOfBoundsException("The given number (" + no + ") was not within bounds (1 to " + this.numberOfParameters + ") when acessing a parameter of " + this);
        }
        switch (this.base) {
            case IMETHOD: {
                return no + this.implicitThis;
            }
            case METHOD_REFERENCE: {
                if (this.implicitThis > 0) {
                    return no + this.implicitThis;
                }
                return no;
            }
        }
        throw new UnsupportedOperationException("No implementation of getParameter() for base " + (Object)((Object)this.base));
    }

    public int getParameterNo(Parameter param) {
        if (param == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return param.getNumber();
    }

    public List<Parameter> all() {
        ArrayList<Parameter> all = new ArrayList<Parameter>(this.getNumberOfParameters());
        if (this.getNumberOfParameters() == 0) {
            return all;
        }
        switch (this.base) {
            case IMETHOD: {
                int i;
                int n = i = this.hasImplicitThis() ? 1 : 0;
                while (i < this.method.getNumberOfParameters()) {
                    ParameterAccessor.debug("all() adding: Parameter({}, {}, {}, {}, {})", new Object[]{i + 1, this.method.getParameterType(i), this.base, this.method, this.descriptorOffset});
                    all.add(new Parameter(i + 1, null, this.method.getParameterType(i), ParamerterDisposition.PARAM, this.base, this.method.getReference(), this.descriptorOffset));
                    ++i;
                }
                break;
            }
            case METHOD_REFERENCE: {
                int firstInSelector = this.firstInSelector();
                for (int i = 0; i < this.numberOfParameters; ++i) {
                    all.add(new Parameter(i + firstInSelector, null, this.mRef.getParameterType(i), ParamerterDisposition.PARAM, this.base, this.mRef, this.descriptorOffset));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("No implementation of all() for base " + (Object)((Object)this.base));
            }
        }
        return all;
    }

    public Parameter getThis() {
        TypeReference selfType;
        int self = this.getThisNo();
        switch (this.base) {
            case IMETHOD: {
                selfType = this.method.getParameterType(self);
                break;
            }
            case METHOD_REFERENCE: {
                selfType = this.mRef.getDeclaringClass();
                break;
            }
            default: {
                throw new UnsupportedOperationException("No implementation of getThis() for base " + (Object)((Object)this.base));
            }
        }
        return this.getThisAs(selfType);
    }

    public Parameter getThisAs(TypeReference asType) {
        int self = this.getThisNo();
        switch (this.base) {
            case IMETHOD: {
                IClassHierarchy cha = this.method.getClassHierarchy();
                try {
                    if (!ParameterAccessor.isSubclassOf(this.method.getParameterType(self), asType, cha)) {
                        throw new IllegalArgumentException("Class " + asType + " is not a super-class of " + this.method.getParameterType(self));
                    }
                }
                catch (ClassLookupException classLookupException) {
                    // empty catch block
                }
                return new Parameter(self, "self", asType, ParamerterDisposition.THIS, this.base, this.method.getReference(), this.descriptorOffset);
            }
            case METHOD_REFERENCE: {
                return new Parameter(self, "self", asType, ParamerterDisposition.THIS, this.base, this.mRef, this.descriptorOffset);
            }
        }
        throw new UnsupportedOperationException("No implementation of getThis() for base " + (Object)((Object)this.base));
    }

    public int getThisNo() {
        if (this.implicitThis >= 0) {
            return this.implicitThis;
        }
        throw new IllegalStateException("getThisNo called for a method that has no implicit this");
    }

    public boolean hasImplicitThis() {
        return this.implicitThis >= 0;
    }

    public Parameter makeReturn(int ssa) {
        if (!this.hasReturn()) {
            throw new IllegalStateException("Can't generate a return-value for a void-function.");
        }
        switch (this.base) {
            case IMETHOD: {
                return new Parameter(ssa, "retVal", this.getReturnType(), ParamerterDisposition.RETURN, this.base, this.method.getReference(), this.descriptorOffset);
            }
            case METHOD_REFERENCE: {
                return new Parameter(ssa, "retVal", this.getReturnType(), ParamerterDisposition.RETURN, this.base, this.mRef, this.descriptorOffset);
            }
        }
        throw new UnsupportedOperationException("No implementation of getReturn() for base " + (Object)((Object)this.base));
    }

    public Parameter makeReturn(int ssa, TypeReference type, IClassHierarchy cha) {
        if (!this.hasReturn()) {
            throw new IllegalStateException("Can't generate a return-value for a void-function.");
        }
        TypeReference returnType = this.getReturnType();
        if (returnType.equals(type)) {
            return this.makeReturn(ssa);
        }
        if (cha == null) {
            throw new IllegalArgumentException("Needed to test assignability but no cha given.");
        }
        if (ParameterAccessor.isAssignable(type, returnType, cha)) {
            return this.makeReturn(ssa);
        }
        throw new IllegalStateException("Return type " + returnType + " is not assignable from " + type);
    }

    public int firstInSelector() {
        if (this.numberOfParameters == 0) {
            if (this.method != null) {
                throw new IllegalArgumentException("The method " + this.method + " has no explicit parameters.");
            }
            throw new IllegalArgumentException("The method " + this.mRef.toString() + " has no explicit parameters.");
        }
        if (this.implicitThis > 1) {
            throw new IllegalStateException("An internal error in ParameterAccessor locating the implicit this pointer occurred! Invalid: " + this.implicitThis);
        }
        switch (this.base) {
            case IMETHOD: {
                if (this.hasImplicitThis()) {
                    ParameterAccessor.debug("This IMethod {} has an implicit this pointer at {}, so firstInSelector is accessible using SSA-Value {}", this.method, this.implicitThis, this.implicitThis + 1);
                    return this.implicitThis + 1;
                }
                ParameterAccessor.debug("This IMethod {} has no implicit this pointer, so firstInSelector is accessible using SSA-Value 1", this.method);
                return 1;
            }
            case METHOD_REFERENCE: {
                if (this.hasImplicitThis()) {
                    ParameterAccessor.debug("This IMethod {} has an implicit this pointer at {}, so firstInSelector is accessible using SSA-Value {}", this.mRef, this.implicitThis, this.implicitThis + 1);
                    return this.implicitThis + 1;
                }
                ParameterAccessor.debug("This mRef {} has no implicit this pointer, so firstInSelector is accessible using SSA-Value 1", this.mRef);
                return 1;
            }
        }
        throw new UnsupportedOperationException("No implementation of firstInSelector() for base " + (Object)((Object)this.base));
    }

    public TypeReference getParameterType(int no) {
        switch (this.base) {
            case IMETHOD: 
            case METHOD_REFERENCE: {
                return this.method.getParameterType(this.getParameterNo(no));
            }
        }
        throw new UnsupportedOperationException("No implementation of getParameterType() for base " + (Object)((Object)this.base));
    }

    public Parameter firstOf(TypeName tName) {
        if (tName == null) {
            throw new IllegalArgumentException("Search-name may not be null");
        }
        if (tName.equals(TypeReference.VoidName)) {
            throw new IllegalArgumentException("You are searching for 'void' as a parameter.");
        }
        List<Parameter> all = this.all();
        for (Parameter cand : all) {
            if (!cand.getType().getName().equals(tName)) continue;
            return cand;
        }
        return null;
    }

    public Parameter firstOf(TypeReference tRef) {
        if (tRef == null) {
            throw new IllegalArgumentException("Search-name may not be null");
        }
        if (tRef.equals(TypeReference.Void)) {
            throw new IllegalArgumentException("You are searching for 'void' as a parameter.");
        }
        List<Parameter> all = this.all();
        for (Parameter cand : all) {
            if (!cand.getType().equals(tRef)) continue;
            return cand;
        }
        return null;
    }

    public List<Parameter> allExtend(TypeName tName, IClassHierarchy cha) {
        IClassLoader loader;
        if (tName == null) {
            throw new IllegalArgumentException("Search-name may not be null");
        }
        if (tName.equals(TypeReference.VoidName)) {
            throw new IllegalArgumentException("You are searching for 'void' as a parameter.");
        }
        if (cha == null) {
            throw new IllegalArgumentException("Can't search ClassHierarchy without having a ClassHierarchy (is null)");
        }
        List<Parameter> all = this.all();
        ArrayList<Parameter> allExctends = new ArrayList<Parameter>();
        IClass searchType = null;
        IClassLoader[] allLoaders = cha.getLoaders();
        IClassLoader[] iClassLoaderArray = allLoaders;
        int n = iClassLoaderArray.length;
        for (int i = 0; i < n && (searchType = (loader = iClassLoaderArray[i]).lookupClass(tName)) == null; ++i) {
        }
        if (searchType == null) {
            throw new IllegalStateException("Could not find " + tName + " in any loader!");
        }
        ParameterAccessor.debug("Retrieved {} as {}", tName, searchType);
        for (Parameter cand : all) {
            IClass candClass = cha.lookupClass(cand.getType());
            if (candClass != null) {
                if (!cha.isSubclassOf(candClass, searchType)) continue;
                allExctends.add(cand);
                continue;
            }
            for (IClassLoader loader2 : cha.getLoaders()) {
                IClass c = loader2.lookupClass(cand.getType().getName());
                if (c == null) continue;
                ParameterAccessor.info("Using alternative for from: {}", cand);
                if (!cha.isSubclassOf(c, searchType)) continue;
                allExctends.add(cand);
            }
            ParameterAccessor.warn("Unable to look up IClass of {}", cand);
        }
        return allExctends;
    }

    public List<Parameter> allExtend(TypeReference tRef, IClassHierarchy cha) {
        if (tRef == null) {
            throw new IllegalArgumentException("Search TypeReference may not be null");
        }
        if (tRef.equals(TypeReference.Void)) {
            throw new IllegalArgumentException("You are searching for 'void' as a parameter.");
        }
        if (cha == null) {
            throw new IllegalArgumentException("Can't search ClassHierarchy without having a ClassHierarchy (is null)");
        }
        IClass searchType = cha.lookupClass(tRef);
        List<Parameter> all = this.all();
        ArrayList<Parameter> allExctends = new ArrayList<Parameter>();
        if (searchType == null) {
            throw new IllegalStateException("Could not find the IClass of " + tRef);
        }
        ParameterAccessor.debug("Reteived {} as {}", tRef, searchType);
        for (Parameter cand : all) {
            IClass candClass = cha.lookupClass(cand.getType());
            if (candClass != null) {
                if (!cha.isSubclassOf(candClass, searchType)) continue;
                allExctends.add(cand);
                continue;
            }
            ParameterAccessor.warn("Unable to look up IClass of {}", cand);
        }
        return allExctends;
    }

    public Parameter firstExtends(TypeName tName, IClassHierarchy cha) {
        IClassLoader loader;
        if (tName == null) {
            throw new IllegalArgumentException("Search-name may not be null");
        }
        if (tName.equals(TypeReference.VoidName)) {
            throw new IllegalArgumentException("You are searching for 'void' as a parameter.");
        }
        if (cha == null) {
            throw new IllegalArgumentException("Can't search ClassHierarchy without having a ClassHierarchy (is null)");
        }
        List<Parameter> all = this.all();
        IClass searchType = null;
        IClassLoader[] allLoaders = cha.getLoaders();
        IClassLoader[] iClassLoaderArray = allLoaders;
        int n = iClassLoaderArray.length;
        for (int i = 0; i < n && (searchType = (loader = iClassLoaderArray[i]).lookupClass(tName)) == null; ++i) {
        }
        if (searchType == null) {
            throw new IllegalStateException("Could not find " + tName + " in any loader!");
        }
        ParameterAccessor.debug("Reteived {} as {}", tName, searchType);
        for (Parameter cand : all) {
            IClass candClass = cha.lookupClass(cand.getType());
            if (candClass != null) {
                if (!cha.isSubclassOf(candClass, searchType)) continue;
                return cand;
            }
            for (IClassLoader loader2 : cha.getLoaders()) {
                IClass c = loader2.lookupClass(cand.getType().getName());
                if (c == null) continue;
                ParameterAccessor.info("Using alternative for from: {}", cand);
                if (!cha.isSubclassOf(c, searchType)) continue;
                return cand;
            }
            ParameterAccessor.warn("Unable to look up IClass of {}", cand);
        }
        return null;
    }

    public Parameter firstExtends(TypeReference tRef, IClassHierarchy cha) {
        if (tRef == null) {
            throw new IllegalArgumentException("Search TypeReference may not be null");
        }
        if (tRef.equals(TypeReference.Void)) {
            throw new IllegalArgumentException("You are searching for 'void' as a parameter.");
        }
        if (cha == null) {
            throw new IllegalArgumentException("Can't search ClassHierarchy without having a ClassHierarchy (is null)");
        }
        IClass searchType = cha.lookupClass(tRef);
        List<Parameter> all = this.all();
        if (searchType == null) {
            throw new IllegalStateException("Could not find the IClass of " + tRef);
        }
        ParameterAccessor.debug("Reteived {} as {}", tRef, searchType);
        for (Parameter cand : all) {
            IClass candClass = cha.lookupClass(cand.getType());
            if (candClass != null) {
                if (!cha.isSubclassOf(candClass, searchType)) continue;
                return cand;
            }
            ParameterAccessor.warn("Unable to look up IClass of {}", cand);
        }
        return null;
    }

    public int getFirstAfter() {
        return this.numberOfParameters + 2;
    }

    public int[] forInvokeStatic(List<? extends SSAValue> args) {
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        int[] params = new int[args.size()];
        if (params.length == 0) {
            return params;
        }
        if (args.get(1) instanceof Parameter && ((Parameter)args.get(1)).getDisposition() == ParamerterDisposition.THIS) {
            ParameterAccessor.warn("The first argument is an implicit this: {} this may be ok however.", args.get(1));
        }
        Arrays.setAll(params, i -> ((SSAValue)args.get(i)).getNumber());
        return params;
    }

    public int[] forInvokeStatic(List<? extends SSAValue> args, ParameterAccessor target, IClassHierarchy cha) {
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("ParameterAccessor for the target is null");
        }
        if (target.hasImplicitThis()) {
            throw new IllegalArgumentException("You used forInvokeStatic on a method that has an implicit this pointer");
        }
        if (target.getNumberOfParameters() != args.size()) {
            throw new IllegalArgumentException("Number of arguments mismatch: " + args.size() + " given on a method that needs " + target.getNumberOfParameters() + " arguments. Arguments given were " + args + " for a static call to " + target);
        }
        int[] params = new int[args.size()];
        if (params.length == 0) {
            return params;
        }
        if (args.get(1) instanceof Parameter && ((Parameter)args.get(1)).getDisposition() == ParamerterDisposition.THIS) {
            ParameterAccessor.warn("The first argument is an implicit this: {} this may be ok however.", args.get(1));
        }
        for (int i = 0; i < params.length; ++i) {
            SSAValue param = args.get(i);
            if (param.getType().equals(target.getParameter(i).getType())) {
                params[i] = param.getNumber();
                continue;
            }
            if (cha == null) {
                throw new IllegalArgumentException("Parameter " + i + " (" + param + ") of the Arguments list is not equal to param " + i + " ( " + target.getParameter(i) + ") of " + target + "and no ClassHierarchy was given to test assignability");
            }
            if (this.isAssignable(param, target.getParameter(i), cha)) {
                params[i] = param.getNumber();
                continue;
            }
            throw new IllegalArgumentException("Parameter " + i + " (" + param + ") of the Arguments list is not assignable to param " + i + " ( " + target.getParameter(i) + ") of " + target);
        }
        return params;
    }

    public int[] forInvokeVirtual(int self, List<? extends SSAValue> args) {
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        if (this.base == BasedOn.METHOD_REFERENCE && self < 1) {
            throw new IllegalArgumentException("The first SSA-Value of a MethodReference is 1. The given this (self) is " + self);
        }
        if (self < 0) {
            throw new IllegalArgumentException("self = " + self + " < 0");
        }
        int[] params = new int[args.size() + 1];
        if (params.length > 1 && args.get(1) instanceof Parameter && ((Parameter)args.get(1)).getDisposition() == ParamerterDisposition.THIS) {
            ParameterAccessor.warn("The first argument is an implicit this: {} this may be ok however.", args.get(1));
        }
        params[0] = self;
        for (int i = 1; i < params.length; ++i) {
            params[i] = args.get(i - 1).getNumber();
        }
        return params;
    }

    public int[] forInvokeVirtual(int self, List<? extends SSAValue> args, ParameterAccessor target, IClassHierarchy cha) {
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        if (this.base == BasedOn.METHOD_REFERENCE && self < 1) {
            throw new IllegalArgumentException("The first SSA-Value of a MethodReference is 1. The given this (self) is " + self);
        }
        if (self < 0) {
            throw new IllegalArgumentException("self = " + self + " < 0");
        }
        if (target == null) {
            throw new IllegalArgumentException("ParameterAccessor for the target is null");
        }
        if (!target.hasImplicitThis()) {
            throw new IllegalArgumentException("You used forInvokeVirtual on a method that has no implicit this pointer");
        }
        if (target.getNumberOfParameters() != args.size() + 1) {
            throw new IllegalArgumentException("Number of arguments mismatch: " + args.size() + " given on a method that needs " + target.getNumberOfParameters() + " arguments. Arguments given were " + args + " for a static call to " + target);
        }
        int[] params = new int[args.size() + 1];
        if (params.length > 1 && args.get(1) instanceof Parameter && ((Parameter)args.get(1)).getDisposition() == ParamerterDisposition.THIS) {
            ParameterAccessor.warn("The first argument is an implicit this: {} this may be ok however.", args.get(1));
        }
        params[0] = self;
        for (int i = 1; i < params.length; ++i) {
            SSAValue param = args.get(i - 1);
            if (param.getType().equals(target.getParameter(i).getType())) {
                params[i] = param.getNumber();
                continue;
            }
            if (cha == null) {
                throw new IllegalArgumentException("Parameter " + i + " (" + param + ") of the Arguments list is not equal to param " + i + " ( " + target.getParameter(i) + ") of " + target + "and no ClassHierarchy was given to test assignability");
            }
            if (this.isAssignable(param, target.getParameter(i), cha)) {
                params[i] = param.getNumber();
                continue;
            }
            throw new IllegalArgumentException("Parameter " + i + " (" + param + ") of the Arguments list is not assignable to param " + i + " ( " + target.getParameter(i) + ") of " + target);
        }
        return params;
    }

    /*
     * WARNING - void declaration
     */
    public List<SSAValue> connectThrough(ParameterAccessor callee, Set<? extends SSAValue> overrides, Set<? extends SSAValue> defaults, IClassHierarchy cha, IInstantiator instantiator, Object ... instantiatorArgs) {
        if (callee == null) {
            throw new IllegalArgumentException("Cannot connect through to null-callee");
        }
        if (overrides == null) {
            overrides = Collections.emptySet();
        }
        if (defaults == null) {
            defaults = Collections.emptySet();
        }
        if (callee.getNumberOfParameters() == 0) {
            return new ArrayList<SSAValue>(0);
        }
        ArrayList<SSAValue> assigned = new ArrayList<SSAValue>();
        List<Parameter> calleeParams = callee.all();
        List<Parameter> thisParams = this.all();
        ParameterAccessor.debug("Collecting parameters for callee {}", callee.mRef != null ? callee.mRef : callee.method);
        ParameterAccessor.debug("\tThe calling function is {}", this.mRef != null ? this.mRef : this.method);
        block4: for (Parameter param : calleeParams) {
            ParameterAccessor.debug("\tSearching candidate for {}", param);
            TypeReference paramType = param.getType();
            for (SSAValue sSAValue : overrides) {
                if (sSAValue.getType().getName().equals(paramType.getName())) {
                    assigned.add(sSAValue);
                    ParameterAccessor.debug("\t\tAsigning: {} from the overrides (eq)", sSAValue);
                    continue block4;
                }
                ParameterAccessor.debug("\t\tSkipping: {} of the overrides (eq)", sSAValue);
            }
            for (Parameter parameter : thisParams) {
                if (parameter.getType().getName().equals(paramType.getName())) {
                    assigned.add(parameter);
                    ParameterAccessor.debug("\t\tAsigning: {} from callers params (eq)", parameter);
                    continue block4;
                }
                ParameterAccessor.debug("\t\tSkipping: {} of the callers params (eq)", parameter);
            }
            for (SSAValue sSAValue : defaults) {
                if (!sSAValue.getType().getName().equals(paramType.getName())) continue;
                assigned.add(sSAValue);
                ParameterAccessor.debug("\t\tAsigning: {} from the defaults (eq)", sSAValue);
                continue block4;
            }
            ParameterAccessor.debug("\tThe parameter is still not found - try again using an assignability check...", new Object[0]);
            if (cha != null) {
                try {
                    for (SSAValue sSAValue : overrides) {
                        if (!this.isAssignable(sSAValue, param, cha)) continue;
                        assigned.add(sSAValue);
                        ParameterAccessor.debug("\t\tAsigning: {} from the overrides (ass)", sSAValue);
                        continue block4;
                    }
                }
                catch (ClassLookupException classLookupException) {
                    // empty catch block
                }
                for (Parameter parameter : thisParams) {
                    try {
                        if (!this.isAssignable(parameter, param, cha)) continue;
                        assigned.add(parameter);
                        ParameterAccessor.debug("\t\tAsigning: {} from the callrs params (ass)", parameter);
                        continue block4;
                    }
                    catch (ClassLookupException classLookupException) {
                    }
                }
                for (SSAValue sSAValue : defaults) {
                    if (!this.isAssignable(sSAValue, param, cha)) continue;
                    assigned.add(sSAValue);
                    ParameterAccessor.debug("\t\tAsigning: {} from the defaults (ass)", sSAValue);
                    continue block4;
                }
                if (instantiator != null) {
                    void var14_26;
                    ParameterAccessor.info("Creating new instance of: {} in call to {}", param, callee);
                    int inst = instantiator.createInstance(param.getType(), instantiatorArgs);
                    if (inst < 0) {
                        ParameterAccessor.warn("No type was assignable and the instantiator returned an invalidone! Using null for {}", param);
                        assigned.add(null);
                        continue;
                    }
                    if (this.base == BasedOn.IMETHOD) {
                        Parameter parameter = new Parameter(inst, "craftedForCall", param.getType(), ParamerterDisposition.NEW, this.base, this.method.getReference(), this.descriptorOffset);
                    } else if (this.base == BasedOn.METHOD_REFERENCE) {
                        Parameter parameter = new Parameter(inst, "craftedForCall", param.getType(), ParamerterDisposition.NEW, this.base, this.mRef, this.descriptorOffset);
                    } else {
                        throw new UnsupportedOperationException("Can't handle base " + (Object)((Object)this.base));
                    }
                    assigned.add((SSAValue)var14_26);
                    continue;
                }
                ParameterAccessor.warn("No IInstantiator given and no known parameter assignable - using null", new Object[0]);
                assigned.add(null);
                continue;
            }
            ParameterAccessor.warn("No type was equal. We can't ask isAssignable since we have no cha!", new Object[0]);
            assigned.add(null);
        }
        if (assigned.size() != calleeParams.size()) {
            System.err.println("Assigned " + assigned.size() + " params to a method taking " + calleeParams.size() + " params!");
            System.err.println("The call takes the parameters");
            for (Parameter param : calleeParams) {
                System.err.println("\t" + param);
            }
            System.err.println("The following were assigned:");
            for (int i = 0; i < assigned.size(); ++i) {
                System.err.println("\tAssigned parameter " + (i + 1) + " is " + assigned.get(i));
            }
            throw new IllegalStateException("Parameter mismatch!");
        }
        return assigned;
    }

    public static boolean isAssignable(TypeReference from, TypeReference to, IClassHierarchy cha) {
        IClass cand;
        if (cha == null) {
            throw new IllegalArgumentException("ClassHierarchy may not be null");
        }
        if (from.getName().equals(to.getName())) {
            return true;
        }
        if (from.isPrimitiveType() && to.isPrimitiveType()) {
            return PrimitiveAssignability.isAssignableFrom(to.getName(), from.getName());
        }
        if (from.isPrimitiveType() || to.isPrimitiveType()) {
            return false;
        }
        IClass fromClass = cha.lookupClass(from);
        IClass toClass = cha.lookupClass(to);
        if (fromClass == null) {
            ParameterAccessor.debug("Unable to look up the type of from=" + from + " in the ClassHierarchy - tying other loaders...", new Object[0]);
            for (IClassLoader loader : cha.getLoaders()) {
                cand = loader.lookupClass(from.getName());
                if (cand == null) continue;
                ParameterAccessor.debug("Using alternative for from: {}", cand);
                fromClass = cand;
                break;
            }
            if (fromClass == null) {
                throw new ClassLookupException("Unable to look up the type of from=" + from + " in the ClassHierarchy");
            }
        }
        if (toClass == null) {
            ParameterAccessor.debug("Unable to look up the type of to=" + to + " in the ClassHierarchy - tying other loaders...", new Object[0]);
            for (IClassLoader loader : cha.getLoaders()) {
                cand = loader.lookupClass(to.getName());
                if (cand == null) continue;
                ParameterAccessor.debug("Using alternative for to: {}", cand);
                toClass = cand;
                break;
            }
            if (toClass == null) {
                ParameterAccessor.error("Unable to look up the type of to={} in the ClassHierarchy", to);
                return false;
            }
        }
        ParameterAccessor.trace("isAssignableFrom({}, {}) = {}", toClass, fromClass, cha.isAssignableFrom(toClass, fromClass));
        return cha.isAssignableFrom(toClass, fromClass);
    }

    public static boolean isSubclassOf(TypeReference sub, TypeReference superC, IClassHierarchy cha) throws ClassLookupException {
        IClass cand;
        if (cha == null) {
            throw new IllegalArgumentException("ClassHierarchy may not be null");
        }
        if (sub.getName().equals(superC.getName())) {
            return true;
        }
        if (sub.isPrimitiveType() || superC.isPrimitiveType()) {
            return false;
        }
        IClass subClass = cha.lookupClass(sub);
        IClass superClass = cha.lookupClass(superC);
        if (subClass == null) {
            ParameterAccessor.debug("Unable to look up the type of from=" + sub + " in the ClassHierarchy - tying other loaders...", new Object[0]);
            for (IClassLoader loader : cha.getLoaders()) {
                cand = loader.lookupClass(sub.getName());
                if (cand == null) continue;
                ParameterAccessor.debug("Using alternative for from: {}", cand);
                subClass = cand;
                break;
            }
            if (subClass == null) {
                throw new ClassLookupException("Unable to look up the type of from=" + sub + " in the ClassHierarchy");
            }
        }
        if (superClass == null) {
            ParameterAccessor.debug("Unable to look up the type of to=" + superC + " in the ClassHierarchy - tying other loaders...", new Object[0]);
            for (IClassLoader loader : cha.getLoaders()) {
                cand = loader.lookupClass(superC.getName());
                if (cand == null) continue;
                ParameterAccessor.debug("Using alternative for to: {}", cand);
                superClass = cand;
                break;
            }
            if (superClass == null) {
                ParameterAccessor.error("Unable to look up the type of to={} in the ClassHierarchy", superC);
                throw new ClassLookupException("Unable to look up the type of to=" + superC + " in the ClassHierarchy");
            }
        }
        return cha.isSubclassOf(subClass, superClass);
    }

    public MethodReference forMethod() {
        if (this.mRef != null) {
            return this.mRef;
        }
        return this.method.getReference();
    }

    protected boolean isAssignable(SSAValue from, SSAValue to, IClassHierarchy cha) {
        return ParameterAccessor.isAssignable(from.getType(), to.getType(), cha);
    }

    public int[] forInvokeStatic(List<? extends Parameter> args, MethodReference target, IClassHierarchy cha) {
        return this.forInvokeStatic(args, new ParameterAccessor(target, cha), cha);
    }

    public int[] forInvokeVirtual(int self, List<? extends Parameter> args, MethodReference target, IClassHierarchy cha) {
        return this.forInvokeVirtual(self, args, new ParameterAccessor(target, cha), cha);
    }

    public boolean hasReturn() {
        return this.getReturnType() != TypeReference.Void;
    }

    public List<SSAValue> connectThrough(ParameterAccessor callee, Set<? extends SSAValue> overrides, Set<? extends SSAValue> defaults, IClassHierarchy cha) {
        return this.connectThrough(callee, overrides, defaults, cha, null, new Object[0]);
    }

    public TypeReference getReturnType() {
        switch (this.base) {
            case IMETHOD: {
                return this.method.getReturnType();
            }
            case METHOD_REFERENCE: {
                return this.mRef.getReturnType();
            }
        }
        throw new UnsupportedOperationException("No implementation of getReturnType() for base " + (Object)((Object)this.base));
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public String dump() {
        StringBuilder ret = new StringBuilder().append("Parameter Accessor for ").append(this.mRef != null ? "mRef:" + this.mRef : "IMethod: " + this.method.toString()).append("\nContains ").append(this.numberOfParameters).append(" Parameters ").append((Object)this.base).append('\n');
        ret.append("\nAnd all is:\n");
        for (Parameter p : this.all()) {
            ret.append('\t').append(p).append('\n');
        }
        if (this.hasImplicitThis()) {
            ret.append("This: ").append(this.getThis());
        } else {
            ret.append("Is static");
        }
        return ret.toString();
    }

    public String toString() {
        return "<ParamAccessor forMethod=" + this.forMethod() + " />";
    }

    private static void debug(String s, Object ... args) {
    }

    private static void info(String s, Object ... args) {
    }

    private static void warn(String s, Object ... args) {
    }

    private static void trace(String s, Object ... args) {
    }

    private static void error(String s, Object ... args) {
    }

    public static class Parameter
    extends SSAValue {
        private final ParamerterDisposition disp;
        private final int descriptorOffset;

        protected Parameter(int number, String name, TypeReference type, ParamerterDisposition disp, BasedOn basedOn, MethodReference mRef, int descriptorOffset) {
            super(number, type, mRef, new ParameterKey(type.getName(), number + descriptorOffset, name));
            if (mRef == null) {
                throw new IllegalArgumentException("MethodReference (mRef) of a Parameter may not be null");
            }
            if (basedOn == null) {
                throw new IllegalArgumentException("Argument basedOn of a Parameter may not be null");
            }
            if (disp == null) {
                throw new IllegalArgumentException("ParamerterDisposition (disp) of a Parameter may not be null");
            }
            if (number < 1 && basedOn == BasedOn.METHOD_REFERENCE) {
                throw new IllegalArgumentException("The first accessible SSA-Value of a MethodReference is 1 but the Value-Number given is " + number);
            }
            if (number < 0 && basedOn == BasedOn.IMETHOD) {
                throw new IllegalArgumentException("The first accessible SSA-Value of an IMethod is 0 but the Value-Number given is " + number);
            }
            if (disp == ParamerterDisposition.PARAM && number + descriptorOffset > mRef.getNumberOfParameters()) {
                throw new IllegalArgumentException("The SSA-Value " + number + " (with added offset " + descriptorOffset + ") is beyond the number of Arguments (" + mRef.getNumberOfParameters() + ") of the Method " + mRef.getName() + '\n' + mRef.getSignature());
            }
            if (disp == ParamerterDisposition.THIS && basedOn == BasedOn.METHOD_REFERENCE && number != 1) {
                throw new IllegalArgumentException("The implicit this-pointer of a MethodReference is located at SSA-Value 1. The SSA-Value given is " + number);
            }
            if (disp == ParamerterDisposition.THIS && basedOn == BasedOn.IMETHOD && number != 0) {
                throw new IllegalArgumentException("The implicit this-pointer of an IMethod is located at SSA-Value 0. The SSA-Value given is " + number);
            }
            if (descriptorOffset < -2 || descriptorOffset > 1) {
                throw new IllegalArgumentException("The descriptor-offset given is not within its expected bounds: -1 (for a method without implicit this-pointer) to 1. The given offset is " + descriptorOffset);
            }
            this.disp = disp;
            this.descriptorOffset = descriptorOffset;
            super.isAssigned();
        }

        public int getNumberInDescriptor() {
            return this.number + this.descriptorOffset;
        }

        public ParamerterDisposition getDisposition() {
            return this.disp;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Parameter) {
                Parameter other = (Parameter)o;
                return this.type.equals(other.type) && this.number == other.number && this.mRef.equals(other.mRef);
            }
            if (o instanceof SSAValue) {
                return super.equals(o);
            }
            throw new IllegalArgumentException("Can't compare Parameter to " + o.getClass());
        }

        @Override
        public final int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            switch (this.disp) {
                case THIS: {
                    return "Implicit this-parameter of " + this.mRef.getName() + " as " + this.type + " accessible using SSA-Value " + this.number;
                }
                case PARAM: {
                    if (this.key instanceof SSAValue.NamedKey) {
                        return "Parameter " + this.getNumberInDescriptor() + " \"" + this.getVariableName() + "\" of " + this.mRef.getName() + " is " + this.type + " accessible using SSA-Value " + this.number;
                    }
                    return "Parameter " + this.getNumberInDescriptor() + " of " + this.mRef.getName() + " is " + this.type + " accessible using SSA-Value " + this.number;
                }
                case RETURN: {
                    return "Return Value of " + this.mRef.getName() + " as " + this.type + " accessible using SSA-Value " + this.number;
                }
                case NEW: {
                    return "New instance of " + this.type + " accessible in " + this.mRef.getName() + " using number " + this.number;
                }
            }
            return "Parameter " + this.getNumberInDescriptor() + " - " + (Object)((Object)this.disp) + " of " + this.mRef.getName() + " as " + this.type + " accessible using SSA-Value " + this.number;
        }
    }

    public static class ParameterKey
    extends SSAValue.WeaklyNamedKey {
        final int paramNo;

        public ParameterKey(TypeName type, int no, String name) {
            super(type, name == null ? "param_" + no : name);
            this.paramNo = no;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public String toString() {
            return "<ParameterKey no=" + this.paramNo + " type=" + this.type + " name=\"" + this.name + "\" />";
        }
    }

    public static enum ParamerterDisposition {
        THIS,
        PARAM,
        RETURN,
        NEW;

    }

    public static enum BasedOn {
        IMETHOD,
        METHOD_REFERENCE;

    }
}

