/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util;

import com.ibm.wala.util.MonitorUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

class ProgressMasterImpl
implements MonitorUtil.IProgressMonitor {
    private final MonitorUtil.IProgressMonitor delegate;
    private volatile boolean timedOut = false;
    private volatile boolean tooMuchMemory = false;
    private final int msPerWorkItem;
    private final boolean checkMemory;
    private Timeout currentNanny;

    ProgressMasterImpl(MonitorUtil.IProgressMonitor monitor, int msPerWorkItem, boolean checkMemory) {
        this.delegate = monitor;
        this.msPerWorkItem = msPerWorkItem;
        this.checkMemory = checkMemory;
    }

    @Override
    public synchronized void beginTask(String name, int totalWork) {
        this.delegate.beginTask(name, totalWork);
        this.startNanny();
    }

    private synchronized void startNanny() {
        this.killNanny();
        if (this.msPerWorkItem >= 1 || this.checkMemory) {
            this.currentNanny = new Timeout();
            this.currentNanny.setDaemon(true);
            this.currentNanny.start();
        }
    }

    public synchronized void reset() {
        this.killNanny();
        this.setCanceled();
        this.timedOut = false;
        this.tooMuchMemory = false;
    }

    public boolean lastItemTimedOut() {
        return this.timedOut;
    }

    public boolean lastItemTooMuchMemory() {
        return this.tooMuchMemory;
    }

    @Override
    public synchronized void done() {
        this.killNanny();
        this.delegate.done();
    }

    private synchronized void killNanny() {
        if (this.currentNanny != null) {
            this.currentNanny.interrupt();
            try {
                this.currentNanny.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currentNanny = null;
        }
    }

    @Override
    public boolean isCanceled() {
        return this.delegate.isCanceled() || this.timedOut || this.tooMuchMemory;
    }

    public void setCanceled() {
        this.killNanny();
    }

    @Override
    public void subTask(String subTask) {
        this.delegate.subTask(subTask);
    }

    @Override
    public void cancel() {
        this.setCanceled();
    }

    @Override
    public synchronized void worked(int work) {
        this.killNanny();
        this.delegate.worked(work);
        this.startNanny();
    }

    public int getMillisPerWorkItem() {
        return this.msPerWorkItem;
    }

    @Override
    public String getCancelMessage() {
        return this.tooMuchMemory ? "too much memory" : (this.timedOut ? "timed out" : "unknown");
    }

    private class Timeout
    extends Thread {
        private static final double MAX_USED_MEM_BEFORE_BACKING_OUT = 0.7;

        private Timeout() {
        }

        @Override
        public void run() {
            try {
                MemoryMXBean gcbean = null;
                NotificationListener listener = null;
                if (ProgressMasterImpl.this.checkMemory) {
                    for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                        if (!pool.getType().equals((Object)MemoryType.HEAP)) continue;
                        pool.setCollectionUsageThreshold((long)((double)pool.getUsage().getMax() * 0.7));
                    }
                    Timeout nannyThread = this;
                    gcbean = ManagementFactory.getMemoryMXBean();
                    listener = (notification, arg1) -> {
                        long max;
                        MemoryNotificationInfo info = MemoryNotificationInfo.from((CompositeData)notification.getUserData());
                        long used = info.getUsage().getUsed();
                        if ((double)used / (double)(max = Runtime.getRuntime().maxMemory()) > 0.7) {
                            System.err.println("used " + used + " of " + max);
                            ProgressMasterImpl.this.tooMuchMemory = true;
                            nannyThread.interrupt();
                        }
                    };
                    try {
                        ManagementFactory.getPlatformMBeanServer().addNotificationListener(gcbean.getObjectName(), listener, null, null);
                    }
                    catch (InstanceNotFoundException e) {
                        throw new Error("cannot find existing bean", e);
                    }
                }
                Thread.sleep(ProgressMasterImpl.this.msPerWorkItem);
                if (ProgressMasterImpl.this.checkMemory) {
                    try {
                        ManagementFactory.getPlatformMBeanServer().removeNotificationListener(gcbean.getObjectName(), listener);
                    }
                    catch (InstanceNotFoundException | ListenerNotFoundException e) {
                        throw new Error("cannot find existing bean", e);
                    }
                }
                if (this.isInterrupted()) {
                    return;
                }
                ProgressMasterImpl.this.timedOut = true;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public static class TooMuchMemoryUsed
    extends Exception {
        private static final long serialVersionUID = -7174940833610292692L;
    }
}

