/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.core.util.io.FileSuffixes;
import com.ibm.wala.core.util.warnings.Warning;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class JarStreamModule
extends JarInputStream
implements Module {
    private static final boolean DEBUG = false;
    private HashMap<String, byte[]> cache = null;

    public JarStreamModule(InputStream stream) throws IOException {
        super(stream);
    }

    public InputStream getInputStream(String name) {
        this.populateCache();
        byte[] b = this.cache.get(name);
        return new ByteArrayInputStream(b);
    }

    private void populateCache() {
        if (this.cache != null) {
            return;
        }
        this.cache = HashMapFactory.make();
        try {
            ZipEntry z = this.getNextEntry();
            while (z != null) {
                String name = z.getName();
                if (FileSuffixes.isClassFile(name) || FileSuffixes.isSourceFile(name)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] temp = new byte[1024];
                    int n = this.read(temp);
                    while (n != -1) {
                        out.write(temp, 0, n);
                        n = this.read(temp);
                    }
                    byte[] bb = out.toByteArray();
                    this.cache.put(name, bb);
                }
                z = this.getNextEntry();
            }
        }
        catch (IOException e) {
            Warnings.add(new Warning(){

                @Override
                public String getMsg() {
                    return "could not read contents of jar input stream.";
                }
            });
        }
    }

    protected long getEntrySize(String name) {
        this.populateCache();
        byte[] b = this.cache.get(name);
        return b.length;
    }

    public Iterator<ModuleEntry> getEntries() {
        this.populateCache();
        final Iterator<String> it = this.cache.keySet().iterator();
        return new Iterator<ModuleEntry>(){
            String next = null;
            {
                this.advance();
            }

            private void advance() {
                this.next = it.hasNext() ? (String)it.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ModuleEntry next() {
                Entry result = new Entry(this.next);
                this.advance();
                return result;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public String toString() {
        return "Jar input stream " + super.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JarStreamModule other = (JarStreamModule)obj;
        return super.equals(other);
    }

    private class Entry
    implements ModuleEntry {
        private final String name;

        Entry(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isClassFile() {
            return FileSuffixes.isClassFile(this.getName());
        }

        @Override
        public InputStream getInputStream() {
            return JarStreamModule.this.getInputStream(this.name);
        }

        @Override
        public boolean isModuleFile() {
            return false;
        }

        @Override
        public Module asModule() {
            Assertions.UNREACHABLE();
            return null;
        }

        public String toString() {
            return "nested entry: " + this.name;
        }

        @Override
        public String getClassName() {
            return FileSuffixes.stripSuffix(this.getName());
        }

        @Override
        public boolean isSourceFile() {
            return FileSuffixes.isSourceFile(this.getName());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        private JarStreamModule getOuterType() {
            return JarStreamModule.this;
        }

        @Override
        public Module getContainer() {
            return JarStreamModule.this;
        }
    }
}

