/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NestedJarFileModule;
import com.ibm.wala.core.util.io.FileSuffixes;
import com.ibm.wala.util.debug.Assertions;
import java.io.InputStream;
import java.util.jar.JarFile;

public class JarFileEntry
implements ModuleEntry {
    private final String entryName;
    private final JarFileModule jarFileModule;

    protected JarFileEntry(String entryName, JarFileModule jarFile) {
        this.entryName = entryName;
        this.jarFileModule = jarFile;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public boolean isClassFile() {
        return FileSuffixes.isClassFile(this.getName());
    }

    @Override
    public InputStream getInputStream() {
        try {
            JarFile jarFile = this.jarFileModule.getJarFile();
            return jarFile.getInputStream(jarFile.getEntry(this.entryName));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public long getSize() {
        return this.jarFileModule.getJarFile().getEntry(this.entryName).getSize();
    }

    public String toString() {
        return this.jarFileModule.getJarFile().getName() + ':' + this.getName();
    }

    @Override
    public boolean isModuleFile() {
        return FileSuffixes.isJarFile(this.getName()) || FileSuffixes.isWarFile(this.getName());
    }

    @Override
    public Module asModule() {
        return new NestedJarFileModule(this.jarFileModule, this.jarFileModule.getJarFile().getEntry(this.entryName));
    }

    public JarFile getJarFile() {
        return this.jarFileModule.getJarFile();
    }

    @Override
    public JarFileModule getContainer() {
        return this.jarFileModule;
    }

    public int hashCode() {
        return this.entryName.hashCode() * 5059 + this.jarFileModule.getJarFile().hashCode();
    }

    @Override
    public String getClassName() {
        return FileSuffixes.stripSuffix(this.getName());
    }

    @Override
    public boolean isSourceFile() {
        return FileSuffixes.isSourceFile(this.getName());
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

