/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import java.util.Arrays;
import java.util.Collection;

public class OperatorUtil {

    public static class UnaryOperatorSequence<T extends IVariable<T>>
    extends UnaryOperator<T> {
        final UnaryOperator<T>[] operators;

        public UnaryOperatorSequence(Collection<UnaryOperator<T>> operators) {
            if (operators.size() == 0) {
                throw new IllegalArgumentException("Empty Operator-Sequence");
            }
            this.operators = operators.toArray(new UnaryOperator[0]);
        }

        @SafeVarargs
        public UnaryOperatorSequence(UnaryOperator<T> ... operators) {
            if (operators.length == 0) {
                throw new IllegalArgumentException("Empty Operator-Sequence");
            }
            this.operators = Arrays.copyOf(operators, operators.length);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            UnaryOperatorSequence other = (UnaryOperatorSequence)o;
            return Arrays.equals(this.operators, other.operators);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.operators);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.operators);
        }

        @Override
        public byte evaluate(T lhs, T rhs) {
            assert (this.operators.length > 0);
            int result = this.operators[0].evaluate(lhs, rhs);
            for (int i = 1; i < this.operators.length; ++i) {
                byte changed = this.operators[i].evaluate(lhs, lhs);
                result = (result | changed) & 1 | (result | changed) & 4 | result & changed & 2;
            }
            return (byte)result;
        }
    }
}

