/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.Collection;

public class CFGSanitizer {
    public static Graph<ISSABasicBlock> sanitize(IR ir, IClassHierarchy cha) throws IllegalArgumentException, WalaException {
        if (ir == null) {
            throw new IllegalArgumentException("ir cannot be null");
        }
        SSACFG cfg = ir.getControlFlowGraph();
        SlowSparseNumberedGraph<ISSABasicBlock> g = SlowSparseNumberedGraph.make();
        for (ISSABasicBlock basicBlock : cfg) {
            g.addNode(basicBlock);
        }
        for (ISSABasicBlock b : cfg) {
            for (ISSABasicBlock b2 : Iterator2Iterable.make(cfg.getSuccNodes(b))) {
                if (b2.isExitBlock()) continue;
                g.addEdge(b, b2);
            }
        }
        ISSABasicBlock exit = (ISSABasicBlock)cfg.exit();
        for (ISSABasicBlock b : Iterator2Iterable.make(cfg.getPredNodes(exit))) {
            SSAInstruction s = ir.getInstructions()[b.getLastInstructionIndex()];
            if (s == null) continue;
            if (s instanceof SSAReturnInstruction || s instanceof SSAThrowInstruction || cfg.getSuccNodeCount(b) == 1) {
                g.addEdge(b, exit);
                continue;
            }
            TypeReference[] exceptions = null;
            try {
                exceptions = CFGSanitizer.computeExceptions(cha, ir, s);
            }
            catch (InvalidClassFileException e1) {
                e1.printStackTrace();
                Assertions.UNREACHABLE();
            }
            for (ISSABasicBlock c : Iterator2Iterable.make(cfg.getSuccNodes(b))) {
                if (!c.isCatchBlock()) continue;
                SSACFG.ExceptionHandlerBasicBlock cb = (SSACFG.ExceptionHandlerBasicBlock)c;
                for (TypeReference ex : Iterator2Iterable.make(cb.getCaughtExceptionTypes())) {
                    IClass exClass = cha.lookupClass(ex);
                    if (exClass == null) {
                        throw new WalaException("failed to find " + ex);
                    }
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (exceptions[i] == null) continue;
                        IClass exi = cha.lookupClass(exceptions[i]);
                        if (exi == null) {
                            throw new WalaException("failed to find " + exceptions[i]);
                        }
                        if (!cha.isSubclassOf(exi, exClass)) continue;
                        exceptions[i] = null;
                    }
                }
            }
            TypeReference[] declared = null;
            try {
                declared = ir.getMethod().getDeclaredExceptions();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            if (declared == null || exceptions == null) continue;
            for (TypeReference exception : exceptions) {
                boolean isDeclared = false;
                if (exception == null) continue;
                IClass exi = cha.lookupClass(exception);
                if (exi == null) {
                    throw new WalaException("failed to find " + exception);
                }
                for (TypeReference element : declared) {
                    IClass dc = cha.lookupClass(element);
                    if (dc == null) {
                        throw new WalaException("failed to find " + element);
                    }
                    if (!cha.isSubclassOf(exi, dc)) continue;
                    isDeclared = true;
                    break;
                }
                if (!isDeclared) continue;
                g.addEdge(b, exit);
            }
        }
        return g;
    }

    private static TypeReference[] computeExceptions(IClassHierarchy cha, IR ir, SSAInstruction s) throws InvalidClassFileException {
        Collection<TypeReference> c;
        Language l = ir.getMethod().getDeclaringClass().getClassLoader().getLanguage();
        if (s instanceof SSAInvokeInstruction) {
            SSAInvokeInstruction call = (SSAInvokeInstruction)s;
            c = l.inferInvokeExceptions(call.getDeclaredTarget(), cha);
        } else {
            c = s.getExceptionTypes();
        }
        return c == null ? null : c.toArray(new TypeReference[0]);
    }
}

