/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds;

import com.ibm.wala.analysis.arraybounds.ArrayBoundsGraph;
import com.ibm.wala.analysis.arraybounds.BinaryOpWithConstant;
import com.ibm.wala.analysis.arraybounds.ConditionNormalizer;
import com.ibm.wala.analysis.arraybounds.hypergraph.DirectedHyperEdge;
import com.ibm.wala.analysis.arraybounds.hypergraph.HyperNode;
import com.ibm.wala.shrike.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrike.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ArrayBoundsGraphBuilder {
    private final IR ir;
    private final HashSet<Integer> foundVariables;
    private final DefUse defUse;
    private final ArrayBoundsGraph lowerBoundGraph;
    private final ArrayBoundsGraph upperBoundGraph;
    private final Set<SSAArrayReferenceInstruction> arrayReferenceInstructions;
    private final IBinaryOpInstruction.Operator SUB = IBinaryOpInstruction.Operator.SUB;
    private final IBinaryOpInstruction.Operator ADD = IBinaryOpInstruction.Operator.ADD;

    public ArrayBoundsGraphBuilder(IR ir) {
        this.ir = ir;
        this.foundVariables = new HashSet();
        this.defUse = new DefUse(ir);
        this.arrayReferenceInstructions = new HashSet<SSAArrayReferenceInstruction>();
        this.lowerBoundGraph = new ArrayBoundsGraph();
        this.upperBoundGraph = new ArrayBoundsGraph();
        this.findArrayAccess();
        this.exploreIr();
        this.addConstructionLength();
        this.lowerBoundGraph.updateNodeEdges();
        this.upperBoundGraph.updateNodeEdges();
        this.lowerBoundGraph.postProcessConstants();
        this.upperBoundGraph.postProcessConstants();
        this.lowerBoundGraph.updateNodeEdges();
        this.upperBoundGraph.updateNodeEdges();
        ArrayBoundsGraphBuilder.bundleDeadEnds(this.lowerBoundGraph);
        ArrayBoundsGraphBuilder.bundleDeadEnds(this.upperBoundGraph);
        ArrayBoundsGraphBuilder.collapseNonPhiEdges(this.lowerBoundGraph);
        ArrayBoundsGraphBuilder.collapseNonPhiEdges(this.upperBoundGraph);
        this.lowerBoundGraph.updateNodeEdges();
        this.upperBoundGraph.updateNodeEdges();
    }

    private void addConstructionLength() {
        Iterator<Integer> iterator = this.lowerBoundGraph.getArrayLength().keySet().iterator();
        while (iterator.hasNext()) {
            Integer array;
            final Integer tmp = array = iterator.next();
            SSAInstruction instruction = this.defUse.getDef(array);
            if (instruction == null) continue;
            instruction.visit(new SSAInstruction.Visitor(){

                @Override
                public void visitNew(SSANewInstruction instruction) {
                    if (instruction.getNumberOfUses() == 1) {
                        int constructionLength = instruction.getUse(0);
                        Integer arraysNode = ArrayBoundsGraphBuilder.this.lowerBoundGraph.getArrayLength().get(tmp);
                        ArrayBoundsGraphBuilder.this.lowerBoundGraph.addEdge(arraysNode, constructionLength);
                        arraysNode = ArrayBoundsGraphBuilder.this.upperBoundGraph.getArrayLength().get(tmp);
                        ArrayBoundsGraphBuilder.this.upperBoundGraph.addEdge(arraysNode, constructionLength);
                        ArrayBoundsGraphBuilder.this.addPossibleConstant(constructionLength);
                    }
                }
            });
        }
    }

    private void addPiStructure(Integer piVar, Integer piParent, Integer piRestrictor, IConditionalBranchInstruction.Operator op) {
        switch (op) {
            case EQ: {
                this.upperBoundGraph.addPi(piVar, piParent, piRestrictor);
                this.lowerBoundGraph.addPi(piVar, piParent, piRestrictor);
                break;
            }
            case NE: {
                this.upperBoundGraph.addEdge(piParent, piVar);
                this.lowerBoundGraph.addEdge(piParent, piVar);
                break;
            }
            case LE: {
                this.upperBoundGraph.addPi(piVar, piParent, piRestrictor);
                this.lowerBoundGraph.addEdge(piParent, piVar);
                break;
            }
            case GE: {
                this.lowerBoundGraph.addPi(piVar, piParent, piRestrictor);
                this.upperBoundGraph.addEdge(piParent, piVar);
                break;
            }
            case LT: {
                Integer helper = this.upperBoundGraph.generateNewVar();
                this.upperBoundGraph.addAdditionEdge(piRestrictor, helper, -1);
                this.upperBoundGraph.addPi(piVar, piParent, helper);
                this.lowerBoundGraph.addEdge(piParent, piVar);
                break;
            }
            case GT: {
                Integer helper = this.lowerBoundGraph.generateNewVar();
                this.lowerBoundGraph.addAdditionEdge(piRestrictor, helper, 1);
                this.lowerBoundGraph.addPi(piVar, piParent, helper);
                this.upperBoundGraph.addEdge(piParent, piVar);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("unexpected operator %s", op));
            }
        }
    }

    private void addPossibleConstant(int handle) {
        if (this.ir.getSymbolTable().isIntegerConstant(handle)) {
            int value = this.ir.getSymbolTable().getIntValue(handle);
            this.lowerBoundGraph.addConstant(handle, value);
            this.upperBoundGraph.addConstant(handle, value);
        }
    }

    private static void bundleDeadEnds(ArrayBoundsGraph graph) {
        HashSet nodes = new HashSet(graph.getNodes().values());
        for (DirectedHyperEdge directedHyperEdge : graph.getEdges()) {
            for (HyperNode node : directedHyperEdge.getDestination()) {
                nodes.remove(node);
            }
        }
        for (HyperNode hyperNode : nodes) {
            graph.markAsDeadEnd((Integer)hyperNode.getValue());
        }
    }

    private static void collapseNonPhiEdges(ArrayBoundsGraph graph) {
        HashMap inEdges = new HashMap();
        HashSet edges = new HashSet(graph.getEdges());
        for (DirectedHyperEdge directedHyperEdge : edges) {
            assert (directedHyperEdge.getDestination().size() == 1);
            HyperNode node = directedHyperEdge.getDestination().iterator().next();
            if (graph.getPhis().contains(node.getValue())) continue;
            if (inEdges.containsKey(node)) {
                DirectedHyperEdge inEdge = (DirectedHyperEdge)inEdges.get(node);
                assert (inEdge.getWeight().equals(directedHyperEdge.getWeight()));
                for (HyperNode src : directedHyperEdge.getSource()) {
                    inEdge.getSource().add(src);
                }
                graph.getEdges().remove(directedHyperEdge);
                continue;
            }
            inEdges.put(node, directedHyperEdge);
        }
    }

    private void discoverPredecessors(final ArrayDeque<Integer> todo, int handle) {
        SSAInstruction def = this.defUse.getDef(handle);
        if (def == null) {
            this.addPossibleConstant(handle);
        } else {
            def.visit(new SSAInstruction.Visitor(){

                @Override
                public void visitArrayLength(SSAArrayLengthInstruction instruction) {
                    ArrayBoundsGraphBuilder.this.lowerBoundGraph.markAsArrayLength(instruction.getArrayRef(), instruction.getDef());
                    ArrayBoundsGraphBuilder.this.upperBoundGraph.markAsArrayLength(instruction.getArrayRef(), instruction.getDef());
                }

                @Override
                public void visitBinaryOp(SSABinaryOpInstruction instruction) {
                    BinaryOpWithConstant op;
                    if ((instruction.getOperator() == ArrayBoundsGraphBuilder.this.SUB || instruction.getOperator() == ArrayBoundsGraphBuilder.this.ADD) && (op = BinaryOpWithConstant.create(instruction, ArrayBoundsGraphBuilder.this.ir)) != null) {
                        todo.push(op.getOtherVar());
                        int value = op.getConstantValue();
                        if (instruction.getOperator() == ArrayBoundsGraphBuilder.this.SUB) {
                            value = -value;
                        }
                        ArrayBoundsGraphBuilder.this.lowerBoundGraph.addAdditionEdge(op.getOtherVar(), instruction.getDef(), value);
                        ArrayBoundsGraphBuilder.this.upperBoundGraph.addAdditionEdge(op.getOtherVar(), instruction.getDef(), value);
                    }
                }

                @Override
                public void visitPhi(SSAPhiInstruction instruction) {
                    int phi = instruction.getDef();
                    ArrayBoundsGraphBuilder.this.lowerBoundGraph.addPhi(phi);
                    ArrayBoundsGraphBuilder.this.upperBoundGraph.addPhi(phi);
                    for (int i = 0; i < instruction.getNumberOfUses(); ++i) {
                        int use = instruction.getUse(i);
                        todo.push(use);
                        ArrayBoundsGraphBuilder.this.lowerBoundGraph.addEdge(use, phi);
                        ArrayBoundsGraphBuilder.this.upperBoundGraph.addEdge(use, phi);
                    }
                }

                @Override
                public void visitPi(SSAPiInstruction instruction) {
                    SSAConditionalBranchInstruction branch = (SSAConditionalBranchInstruction)instruction.getCause();
                    assert (branch.getNumberOfUses() == 2);
                    Integer piVar = instruction.getDef();
                    Integer piParent = instruction.getUse(0);
                    ConditionNormalizer cnd = new ConditionNormalizer(branch, piParent, ArrayBoundsGraphBuilder.this.isBranchTaken(instruction, branch));
                    Integer piRestrictor = cnd.getRhs();
                    todo.push(piParent);
                    todo.push(piRestrictor);
                    ArrayBoundsGraphBuilder.this.addPiStructure(piVar, piParent, piRestrictor, cnd.getOp());
                }
            });
        }
    }

    private void exploreIr() {
        HashSet<Integer> variablesUsedAsIndex = new HashSet<Integer>();
        for (Set<Integer> variables : this.lowerBoundGraph.getArrayAccess().values()) {
            variablesUsedAsIndex.addAll(variables);
        }
        for (Integer variable : variablesUsedAsIndex) {
            this.startDFS(variable);
        }
    }

    private void findArrayAccess() {
        this.ir.visitNormalInstructions(new SSAInstruction.Visitor(){

            @Override
            public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
                ArrayBoundsGraphBuilder.this.lowerBoundGraph.markAsArrayAccess(instruction.getArrayRef(), instruction.getIndex());
                ArrayBoundsGraphBuilder.this.upperBoundGraph.markAsArrayAccess(instruction.getArrayRef(), instruction.getIndex());
                ArrayBoundsGraphBuilder.this.arrayReferenceInstructions.add(instruction);
            }

            @Override
            public void visitArrayStore(SSAArrayStoreInstruction instruction) {
                ArrayBoundsGraphBuilder.this.lowerBoundGraph.markAsArrayAccess(instruction.getArrayRef(), instruction.getIndex());
                ArrayBoundsGraphBuilder.this.upperBoundGraph.markAsArrayAccess(instruction.getArrayRef(), instruction.getIndex());
                ArrayBoundsGraphBuilder.this.arrayReferenceInstructions.add(instruction);
            }
        });
    }

    public Set<SSAArrayReferenceInstruction> getArrayReferenceInstructions() {
        return this.arrayReferenceInstructions;
    }

    public ArrayBoundsGraph getLowerBoundGraph() {
        return this.lowerBoundGraph;
    }

    public ArrayBoundsGraph getUpperBoundGraph() {
        return this.upperBoundGraph;
    }

    private boolean isBranchTaken(SSAPiInstruction pi, SSAConditionalBranchInstruction cnd) {
        SSACFG.BasicBlock branchTargetBlock = this.ir.getControlFlowGraph().getBlockForInstruction(cnd.getTarget());
        return branchTargetBlock.getNumber() == pi.getSuccessor();
    }

    private void startDFS(int index) {
        ArrayDeque<Integer> todo = new ArrayDeque<Integer>();
        todo.push(index);
        while (!todo.isEmpty()) {
            int next = (Integer)todo.pop();
            if (!this.foundVariables.add(next)) continue;
            this.lowerBoundGraph.addNode(next);
            this.upperBoundGraph.addNode(next);
            this.discoverPredecessors(todo, next);
        }
    }
}

