/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.dg.pdg;

import codetoolkit.janalysis.common.antlrparser.JavaBaseVisitor;
import codetoolkit.janalysis.common.antlrparser.JavaLexer;
import codetoolkit.janalysis.common.antlrparser.JavaParser;
import codetoolkit.janalysis.common.graph.Edge;
import codetoolkit.janalysis.dg.DEPEdge;
import codetoolkit.janalysis.dg.DEPNode;
import codetoolkit.janalysis.dg.cfg.CFGBuilder;
import codetoolkit.janalysis.dg.cfg.ControlFlowGraph;
import codetoolkit.janalysis.dg.pdg.CFPathTraversal;
import codetoolkit.janalysis.dg.pdg.JavaClass;
import codetoolkit.janalysis.dg.pdg.JavaClassExtractor;
import codetoolkit.janalysis.dg.pdg.JavaField;
import codetoolkit.janalysis.dg.pdg.JavaMethod;
import codetoolkit.janalysis.dg.pdg.MethodDefInfo;
import codetoolkit.janalysis.dg.pdg.ProgramDependenceGraph;
import codetoolkit.janalysis.utils.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PDGBuilder {
    private static Map<String, JavaClass> allClassInfos;
    private static Map<String, List<MethodDefInfo>> methodDEFs;

    public static List<ProgramDependenceGraph> buildWithCode(String code) throws IOException {
        Logger.info("Parsing source code ... ");
        ANTLRInputStream input = new ANTLRInputStream(code);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext parseTree = parser.compilationUnit();
        return PDGBuilder.build(parseTree);
    }

    public static List<ProgramDependenceGraph> build(String file) throws IOException {
        Logger.info("Parsing source file ... ");
        FileInputStream inFile = new FileInputStream(file);
        ANTLRInputStream input = new ANTLRInputStream(inFile);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext parseTree = parser.compilationUnit();
        return PDGBuilder.build(parseTree);
    }

    public static List<ProgramDependenceGraph> build(ParseTree parseTree) {
        boolean changed;
        Logger.info("Extracting class-infos ... ");
        allClassInfos = new HashMap<String, JavaClass>();
        List<JavaClass> classesList = JavaClassExtractor.extractInfo(parseTree);
        for (JavaClass cls : classesList) {
            allClassInfos.put(cls.NAME, cls);
        }
        Logger.info("Initializing method-DEF infos ... ");
        methodDEFs = new HashMap<String, List<MethodDefInfo>>();
        for (JavaClass cls : classesList) {
            for (JavaMethod mtd : cls.getAllMethods()) {
                List<MethodDefInfo> list = methodDEFs.get(mtd.NAME);
                if (list == null) {
                    list = new ArrayList<MethodDefInfo>();
                    list.add(new MethodDefInfo(mtd.RET_TYPE, mtd.NAME, cls.PACKAGE, cls.NAME, mtd.ARG_TYPES));
                    methodDEFs.put(mtd.NAME, list);
                    continue;
                }
                list.add(new MethodDefInfo(mtd.RET_TYPE, mtd.NAME, cls.PACKAGE, cls.NAME, mtd.ARG_TYPES));
            }
        }
        IdentityHashMap<ParserRuleContext, DEPNode> dataNodes = new IdentityHashMap<ParserRuleContext, DEPNode>();
        IdentityHashMap<ParserRuleContext, List<DEPNode>> entry2params = new IdentityHashMap<ParserRuleContext, List<DEPNode>>();
        Logger.info("Iterative DEF-USE analysis ... ");
        int iteration = 0;
        do {
            changed = false;
            DefUseVisitor defUse = new DefUseVisitor(++iteration, classesList.toArray(new JavaClass[classesList.size()]), dataNodes, entry2params);
            defUse.visit(parseTree);
            Logger.debug("Iteration #" + iteration + ": " + ((changed |= defUse.changed) ? "CHANGED" : "NO-CHANGE"));
            Logger.debug("\n========================================\n");
        } while (changed);
        Logger.info("Extracting CFGs ... ");
        List<ControlFlowGraph> cfgs = CFGBuilder.build(parseTree);
        Logger.info("Adding data-flow edges ... ");
        ArrayList<ProgramDependenceGraph> pdgs = new ArrayList<ProgramDependenceGraph>();
        for (ControlFlowGraph cfg : cfgs) {
            ProgramDependenceGraph pdg = new ProgramDependenceGraph(cfg.getName());
            pdg.attachCFG(cfg);
            List params = (List)entry2params.get(cfg.getEntry().getRuleCtx());
            pdg.addParams(params);
            PDGBuilder.updateDataDependence(pdg, dataNodes);
            pdgs.add(pdg);
        }
        return pdgs;
    }

    private static void updateDataDependence(ProgramDependenceGraph pdg, Map<ParserRuleContext, DEPNode> dataNodes) {
        Iterator allNodes = pdg.allVerticesIterator();
        while (allNodes.hasNext()) {
            DEPNode node = (DEPNode)allNodes.next();
            DEPNode dataNode = dataNodes.get(node.getRuleCtx());
            if (dataNode == null) continue;
            node.setAbstract(dataNode.getAbstract());
            for (String def : dataNode.getAllDEFs()) {
                node.addDEF(def);
            }
            for (String use : dataNode.getAllUSEs()) {
                node.addUSE(use);
            }
            for (String selfFlow : dataNode.getAllSelfFlows()) {
                node.addSelfFlow(selfFlow);
            }
        }
        DEPNode entry = pdg.getEntry();
        for (DEPNode param : pdg.getParams()) {
            if (param.getAllDEFs().length == 0) continue;
            for (String flow : param.getAllSelfFlows()) {
                pdg.addEdge(new Edge<DEPNode, DEPEdge>(param, new DEPEdge(DEPEdge.Type.DATA, flow), param));
            }
            LinkedHashSet<DEPNode> visitedUses = new LinkedHashSet<DEPNode>();
            String[] stringArray = param.getAllDEFs();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String def = stringArray[i];
                CFPathTraversal useTraversal = new CFPathTraversal(pdg, entry);
                visitedUses.clear();
                DEPNode useNode = useTraversal.next();
                visitedUses.add(useNode);
                while (useTraversal.hasNext()) {
                    useNode = useTraversal.next();
                    if (useNode.hasDEF(def)) {
                        useTraversal.continueNextPath();
                    }
                    if (!visitedUses.add(useNode)) {
                        useTraversal.continueNextPath();
                        continue;
                    }
                    if (!useNode.hasUSE(def)) continue;
                    pdg.addEdge(new Edge<DEPNode, DEPEdge>(param, new DEPEdge(DEPEdge.Type.DATA, def), useNode));
                }
            }
        }
        LinkedHashSet<DEPNode> visitedDefs = new LinkedHashSet<DEPNode>();
        CFPathTraversal defTraversal = new CFPathTraversal(pdg, entry);
        while (defTraversal.hasNext()) {
            DEPNode defNode = defTraversal.next();
            if (!visitedDefs.add(defNode)) {
                defTraversal.continueNextPath();
                continue;
            }
            if (defNode.getAllDEFs().length == 0) continue;
            for (String flow : defNode.getAllSelfFlows()) {
                pdg.addEdge(new Edge<DEPNode, DEPEdge>(defNode, new DEPEdge(DEPEdge.Type.DATA, flow), defNode));
            }
            LinkedHashSet<DEPNode> visitedUses = new LinkedHashSet<DEPNode>();
            for (String def : defNode.getAllDEFs()) {
                CFPathTraversal useTraversal = new CFPathTraversal(pdg, defNode);
                visitedUses.clear();
                DEPNode useNode = useTraversal.next();
                visitedUses.add(useNode);
                while (useTraversal.hasNext()) {
                    useNode = useTraversal.next();
                    if (useNode.hasDEF(def)) {
                        useTraversal.continueNextPath();
                    }
                    if (!visitedUses.add(useNode)) {
                        useTraversal.continueNextPath();
                        continue;
                    }
                    if (!useNode.hasUSE(def)) continue;
                    pdg.addEdge(new Edge<DEPNode, DEPEdge>(defNode, new DEPEdge(DEPEdge.Type.DATA, def), useNode));
                }
            }
        }
    }

    private static class DefUseVisitor
    extends JavaBaseVisitor<String> {
        private static final int PARAM = 1;
        private static final int FIELD = 101;
        private static final int LOCAL = 202;
        private static final int OUTER = 303;
        private int iteration;
        private boolean changed = false;
        private boolean analysisVisit;
        private JavaClass[] classInfos;
        private Set<String> defList;
        private Set<String> useList;
        private Set<String> selfFlowList;
        private Map<ParserRuleContext, DEPNode> dataNodes;
        private Map<ParserRuleContext, List<DEPNode>> entry2params;
        private Deque<JavaClass> activeClasses;
        private MethodDefInfo methodDefInfo;
        private JavaField[] methodParams;
        private List<JavaField> localVars;

        public DefUseVisitor(int iter, JavaClass[] classInfos, Map<ParserRuleContext, DEPNode> dataNodes, Map<ParserRuleContext, List<DEPNode>> entry2params) {
            this.iteration = iter;
            this.analysisVisit = false;
            this.dataNodes = dataNodes;
            this.entry2params = entry2params;
            this.classInfos = classInfos;
            this.defList = new LinkedHashSet<String>();
            this.useList = new LinkedHashSet<String>();
            this.selfFlowList = new LinkedHashSet<String>();
            this.activeClasses = new ArrayDeque<JavaClass>();
            this.methodDefInfo = null;
            this.methodParams = new JavaField[0];
            this.localVars = new ArrayList<JavaField>();
        }

        /*
         * WARNING - void declaration
         */
        private void analyseDefUse(DEPNode node, ParseTree expression) {
            int status;
            Logger.debug("--- ANALYSIS ---");
            Logger.debug(node.toString());
            this.analysisVisit = true;
            String expr = (String)this.visit(expression);
            node.setAbstract(expr);
            Logger.debug(expr);
            StringBuilder locVarsStr = new StringBuilder(256);
            locVarsStr.append("LOCAL VARS = [");
            for (JavaField javaField : this.localVars) {
                locVarsStr.append(javaField.TYPE).append(' ').append(javaField.NAME).append(", ");
            }
            locVarsStr.append("]");
            Logger.debug(locVarsStr.toString());
            if (this.isUsableExpression(expr)) {
                this.useList.add(expr);
                Logger.debug("USABLE");
            }
            this.analysisVisit = false;
            Logger.debug("Changed = " + this.changed);
            Logger.debug("DEFs = " + Arrays.toString(node.getAllDEFs()));
            Logger.debug("USEs = " + Arrays.toString(node.getAllUSEs()));
            for (String string : this.defList) {
                status = this.isDefined(string);
                if (status > -1) {
                    void var6_12;
                    if (status < 100) {
                        this.methodDefInfo.setArgDEF(status, true);
                        Logger.debug("Method defines argument #" + status);
                    } else if (status == 101) {
                        void var6_10;
                        this.methodDefInfo.setStateDEF(true);
                        if (string.startsWith("this.")) {
                            String string2 = string.substring(5);
                        }
                        String string3 = "$THIS." + (String)var6_10;
                        Logger.debug("Method defines object state.");
                    }
                    this.changed |= node.addDEF((String)var6_12);
                    continue;
                }
                Logger.debug(string + " is not defined!");
            }
            Logger.debug("Changed = " + this.changed);
            Logger.debug("DEFs = " + Arrays.toString(node.getAllDEFs()));
            for (String string : this.useList) {
                status = this.isDefined(string);
                if (status > -1) {
                    void var6_18;
                    if (status == 101) {
                        void var6_16;
                        if (string.startsWith("this.")) {
                            String string4 = string.substring(5);
                        }
                        String string5 = "$THIS." + (String)var6_16;
                    }
                    this.changed |= node.addUSE((String)var6_18);
                    continue;
                }
                Logger.debug(string + " is not defined!");
            }
            Logger.debug("Changed = " + this.changed);
            Logger.debug("USEs = " + Arrays.toString(node.getAllUSEs()));
            for (String string : this.selfFlowList) {
                status = this.isDefined(string);
                if (status > -1) {
                    void var6_24;
                    if (status == 101) {
                        void var6_22;
                        if (string.startsWith("this.")) {
                            String string6 = string.substring(5);
                        }
                        String string7 = "$THIS." + (String)var6_22;
                    }
                    this.changed |= node.addSelfFlow((String)var6_24);
                    continue;
                }
                Logger.debug(string + " is not defined!");
            }
            Logger.debug("Changed = " + this.changed);
            Logger.debug("SELF_FLOWS = " + Arrays.toString(node.getAllSelfFlows()));
            this.defList.clear();
            this.useList.clear();
            this.selfFlowList.clear();
            Logger.debug("----------------");
        }

        private int isDefined(String id) {
            for (int i = 0; i < this.methodParams.length; ++i) {
                if (!this.methodParams[i].NAME.equals(id)) continue;
                return i;
            }
            for (JavaField local : this.localVars) {
                if (!local.NAME.equals(id)) continue;
                return 202;
            }
            if (id.startsWith("this.")) {
                id = id.substring(5);
            }
            for (JavaField field : this.activeClasses.peek().getAllFields()) {
                if (!field.NAME.equals(id)) continue;
                return 101;
            }
            for (JavaClass cls : this.activeClasses) {
                for (JavaField field : cls.getAllFields()) {
                    if (!field.NAME.equals(id)) continue;
                    return 303;
                }
            }
            return -1;
        }

        private String getType(String id) {
            if (this.isUsableExpression(id)) {
                for (JavaField param : this.methodParams) {
                    if (!param.NAME.equals(id)) continue;
                    return param.TYPE;
                }
                for (JavaField local : this.localVars) {
                    if (!local.NAME.equals(id)) continue;
                    return local.TYPE;
                }
                if (id.startsWith("this.")) {
                    id = id.substring(4);
                }
                for (JavaField field : this.activeClasses.peek().getAllFields()) {
                    if (!field.NAME.equals(id)) continue;
                    return field.TYPE;
                }
                for (JavaClass cls : this.activeClasses) {
                    for (JavaField field : cls.getAllFields()) {
                        if (!field.NAME.equals(id)) continue;
                        return field.TYPE;
                    }
                }
                Logger.debug("getType(" + id + ") : is USABLE but NOT DEFINED");
                return null;
            }
            Logger.debug("getType(" + id + ") : is NOT USABLE");
            return null;
        }

        private JavaClass findClass(String type) {
            return null;
        }

        private MethodDefInfo findDefInfo(String callee, String name, JavaParser.ExpressionListContext ctx) {
            List<MethodDefInfo> list = methodDEFs.get(name);
            Logger.debug("METHOD NAME: " + name);
            Logger.debug("# found = " + (list == null ? 0 : list.size()));
            if (list == null) {
                return null;
            }
            if (list.size() == 1) {
                Logger.debug("SINGLE CANDIDATE");
                MethodDefInfo mtd = list.get(0);
                if (ctx != null && mtd.PARAM_TYPES != null && mtd.PARAM_TYPES.length != ctx.expression().size()) {
                    return null;
                }
                Logger.debug("WITH MATCHING PARAMS COUNT");
                return mtd;
            }
            if (callee == null) {
                Logger.debug("NO CALLEE");
                block0: for (MethodDefInfo mtd : list) {
                    if (!mtd.PACKAGE.equals(this.activeClasses.peek().PACKAGE)) continue;
                    boolean classNameMatch = false;
                    for (JavaClass cls : this.activeClasses) {
                        if (!mtd.CLASS_NAME.equals(cls.NAME)) continue;
                        classNameMatch = true;
                        break;
                    }
                    if (!classNameMatch || ctx != null && mtd.PARAM_TYPES != null && mtd.PARAM_TYPES.length != ctx.expression().size()) continue;
                    if (ctx != null) {
                        int i;
                        String[] argTypes = new String[ctx.expression().size()];
                        for (i = 0; i < argTypes.length; ++i) {
                            String arg = (String)this.visit(ctx.expression(i));
                            argTypes[i] = this.getType(arg);
                        }
                        if (mtd.PARAM_TYPES != null) {
                            for (i = 0; i < argTypes.length; ++i) {
                                if (argTypes[i] != null && !argTypes[i].equals(mtd.PARAM_TYPES[i])) continue block0;
                            }
                        }
                    }
                    return mtd;
                }
            } else if (this.isDefined(callee) > -1) {
                Logger.debug("DEFINED CALLEE");
                String type = this.getType(callee);
                JavaClass cls = allClassInfos.get(type);
                if (cls != null && cls.hasMethod(name)) {
                    block4: for (MethodDefInfo mtd : list) {
                        if (!mtd.PACKAGE.equals(cls.PACKAGE) || !mtd.CLASS_NAME.equals(cls.NAME) || ctx != null && mtd.PARAM_TYPES != null && mtd.PARAM_TYPES.length != ctx.expression().size()) continue;
                        if (ctx != null) {
                            int i;
                            String[] argTypes = new String[ctx.expression().size()];
                            for (i = 0; i < argTypes.length; ++i) {
                                String arg = (String)this.visit(ctx.expression(i));
                                argTypes[i] = this.getType(arg);
                            }
                            if (mtd.PARAM_TYPES != null) {
                                for (i = 0; i < argTypes.length; ++i) {
                                    if (argTypes[i] != null && !argTypes[i].equals(mtd.PARAM_TYPES[i])) continue block4;
                                }
                            }
                        }
                        return mtd;
                    }
                    Logger.debug("METHOD DEF INFO NOT FOUND!");
                } else {
                    Logger.debug((String)(cls == null ? "CLASS OF TYPE " + type + " NOT FOUND!" : "CLASS HAS NO SUCH METHOD!"));
                }
            } else {
                Logger.debug("UNDEFINED CALLEE.");
            }
            return null;
        }

        private MethodDefInfo findDefInfo(String name, String type, JavaField[] params) {
            List<MethodDefInfo> infoList = methodDEFs.get(name);
            if (infoList.size() > 1) {
                block0: for (MethodDefInfo info : infoList) {
                    if (!info.PACKAGE.equals(this.activeClasses.peek().PACKAGE) || !info.CLASS_NAME.equals(this.activeClasses.peek().NAME) || info.RET_TYPE == null && type != null || info.RET_TYPE != null && type == null || type != null && !type.startsWith(info.RET_TYPE)) continue;
                    if (info.PARAM_TYPES != null) {
                        if (info.PARAM_TYPES.length != params.length) continue;
                        for (int i = 0; i < params.length; ++i) {
                            if (!params[i].TYPE.startsWith(info.PARAM_TYPES[i])) continue block0;
                        }
                    } else if (params.length > 0) continue;
                    return info;
                }
            } else if (infoList.size() == 1) {
                return infoList.get(0);
            }
            return null;
        }

        @Override
        public String visitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            for (JavaClass cls : this.classInfos) {
                if (!cls.NAME.equals(ctx.Identifier().getText())) continue;
                this.activeClasses.push(cls);
                this.visit(ctx.classBody());
                this.activeClasses.pop();
                break;
            }
            return null;
        }

        @Override
        public String visitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            return null;
        }

        @Override
        public String visitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            return null;
        }

        @Override
        public String visitClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx) {
            if (ctx.block() != null) {
                this.localVars.clear();
                this.methodParams = new JavaField[0];
                this.methodDefInfo = new MethodDefInfo(null, "static-block", "", this.activeClasses.peek().NAME, null);
                return null;
            }
            return (String)this.visitChildren(ctx);
        }

        @Override
        public String visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            DEPNode entry;
            if (this.iteration == 1) {
                entry = new DEPNode();
                ArrayList<DEPNode> params = new ArrayList<DEPNode>();
                this.entry2params.put(ctx, params);
                entry.setLineOfCode(ctx.getStart().getLine());
                entry.setCode(ctx.Identifier().getText() + " " + this.getOriginalCodeText(ctx.formalParameters()));
                entry.setProperty("name", ctx.Identifier().getText());
                this.dataNodes.put(ctx, entry);
                entry.setRuleCtx(ctx);
                ArrayList<String> paramIDs = new ArrayList<String>();
                ArrayList<String> paramTypes = new ArrayList<String>();
                if (ctx.formalParameters().formalParameterList() != null) {
                    for (JavaParser.FormalParameterContext prm : ctx.formalParameters().formalParameterList().formalParameter()) {
                        paramTypes.add(this.visitType(prm.typeType()));
                        paramIDs.add(prm.variableDeclaratorId().Identifier().getText());
                        DEPNode param = new DEPNode();
                        this.changed |= param.addDEF(prm.variableDeclaratorId().Identifier().getText());
                        param.setLineOfCode(prm.getStart().getLine());
                        param.setCode(this.getOriginalCodeText(prm));
                        param.setProperty("type", prm.typeType().getText());
                        param.setProperty("name", prm.variableDeclaratorId().Identifier().getText());
                        this.dataNodes.put(prm, param);
                        param.setRuleCtx(prm);
                        params.add(param);
                    }
                    JavaParser.LastFormalParameterContext lastParam = ctx.formalParameters().formalParameterList().lastFormalParameter();
                    if (lastParam != null) {
                        paramTypes.add(this.visitType(lastParam.typeType()));
                        paramIDs.add(lastParam.variableDeclaratorId().Identifier().getText());
                        DEPNode param = new DEPNode();
                        this.changed |= param.addDEF(lastParam.variableDeclaratorId().Identifier().getText());
                        param.setLineOfCode(lastParam.getStart().getLine());
                        param.setCode(this.getOriginalCodeText(lastParam));
                        param.setProperty("type", lastParam.typeType().getText());
                        param.setProperty("name", lastParam.variableDeclaratorId().Identifier().getText());
                        this.dataNodes.put(lastParam, param);
                        param.setRuleCtx(lastParam);
                        params.add(param);
                    }
                }
                this.methodParams = new JavaField[paramIDs.size()];
                for (int i = 0; i < this.methodParams.length; ++i) {
                    this.methodParams[i] = new JavaField(null, false, (String)paramTypes.get(i), (String)paramIDs.get(i));
                }
                entry.setProperty("params", this.methodParams);
            } else {
                entry = this.dataNodes.get(ctx);
                this.methodParams = (JavaField[])entry.getProperty("params");
            }
            this.methodDefInfo = this.findDefInfo((String)entry.getProperty("name"), null, this.methodParams);
            if (this.methodDefInfo == null) {
                Logger.error("Constructor NOT FOUND!");
                Logger.error("NAME = " + (String)entry.getProperty("name"));
                Logger.error("TYPE = null");
                Logger.error("PARAMS = " + Arrays.toString(this.methodParams));
                Logger.error("CLASS = " + this.activeClasses.peek().NAME);
                Logger.error("PACKAGE = " + this.activeClasses.peek().PACKAGE);
                List<MethodDefInfo> list = methodDEFs.get((String)entry.getProperty("name"));
                for (int i = 0; i < list.size(); ++i) {
                    Logger.error(((Object)list.get(i)).toString());
                }
            }
            this.localVars.clear();
            this.visit(ctx.constructorBody());
            this.localVars.clear();
            this.methodParams = new JavaField[0];
            return null;
        }

        @Override
        public String visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            DEPNode entry;
            if (this.iteration == 1) {
                entry = new DEPNode();
                ArrayList<DEPNode> params = new ArrayList<DEPNode>();
                this.entry2params.put(ctx, params);
                entry.setLineOfCode(ctx.getStart().getLine());
                String retType = "void";
                if (ctx.typeType() != null) {
                    retType = ctx.typeType().getText();
                }
                String args = this.getOriginalCodeText(ctx.formalParameters());
                entry.setCode(retType + " " + ctx.Identifier().getText() + args);
                entry.setProperty("name", ctx.Identifier().getText());
                entry.setProperty("type", retType);
                this.dataNodes.put(ctx, entry);
                entry.setRuleCtx(ctx);
                ArrayList<String> paramIDs = new ArrayList<String>();
                ArrayList<String> paramTypes = new ArrayList<String>();
                if (ctx.formalParameters().formalParameterList() != null) {
                    for (JavaParser.FormalParameterContext prm : ctx.formalParameters().formalParameterList().formalParameter()) {
                        paramTypes.add(this.visitType(prm.typeType()));
                        paramIDs.add(prm.variableDeclaratorId().Identifier().getText());
                        DEPNode param = new DEPNode();
                        this.changed |= param.addDEF(prm.variableDeclaratorId().Identifier().getText());
                        param.setLineOfCode(prm.getStart().getLine());
                        param.setCode(this.getOriginalCodeText(prm));
                        param.setProperty("type", prm.typeType().getText());
                        param.setProperty("name", prm.variableDeclaratorId().Identifier().getText());
                        this.dataNodes.put(prm, param);
                        param.setRuleCtx(prm);
                        params.add(param);
                    }
                    JavaParser.LastFormalParameterContext lastParam = ctx.formalParameters().formalParameterList().lastFormalParameter();
                    if (lastParam != null) {
                        paramTypes.add(this.visitType(lastParam.typeType()));
                        paramIDs.add(lastParam.variableDeclaratorId().Identifier().getText());
                        DEPNode param = new DEPNode();
                        this.changed |= param.addDEF(lastParam.variableDeclaratorId().Identifier().getText());
                        param.setLineOfCode(lastParam.getStart().getLine());
                        param.setCode(this.getOriginalCodeText(lastParam));
                        param.setProperty("type", lastParam.typeType().getText());
                        param.setProperty("name", lastParam.variableDeclaratorId().Identifier().getText());
                        this.dataNodes.put(lastParam, param);
                        param.setRuleCtx(lastParam);
                        params.add(param);
                    }
                }
                this.methodParams = new JavaField[paramIDs.size()];
                for (int i = 0; i < this.methodParams.length; ++i) {
                    this.methodParams[i] = new JavaField(null, false, (String)paramTypes.get(i), (String)paramIDs.get(i));
                }
                entry.setProperty("params", this.methodParams);
            } else {
                entry = this.dataNodes.get(ctx);
                this.methodParams = (JavaField[])entry.getProperty("params");
            }
            this.methodDefInfo = this.findDefInfo((String)entry.getProperty("name"), (String)entry.getProperty("type"), this.methodParams);
            if (this.methodDefInfo == null) {
                Logger.error("Method NOT FOUND!");
                Logger.error("NAME = " + (String)entry.getProperty("name"));
                Logger.error("TYPE = " + (String)entry.getProperty("type"));
                Logger.error("PARAMS = " + Arrays.toString(this.methodParams));
                Logger.error("CLASS = " + this.activeClasses.peek().NAME);
                Logger.error("PACKAGE = " + this.activeClasses.peek().PACKAGE);
                List<MethodDefInfo> list = methodDEFs.get((String)entry.getProperty("name"));
                for (int i = 0; i < list.size(); ++i) {
                    Logger.error(((Object)list.get(i)).toString());
                }
            }
            this.localVars.clear();
            if (ctx.methodBody() != null) {
                this.visit(ctx.methodBody());
            }
            this.localVars.clear();
            this.methodParams = new JavaField[0];
            return null;
        }

        private String visitType(JavaParser.TypeTypeContext ctx) {
            return ctx.getText();
        }

        @Override
        public String visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
            DEPNode declr;
            for (JavaParser.VariableDeclaratorContext var : ctx.variableDeclarators().variableDeclarator()) {
                this.localVars.add(new JavaField(null, false, this.visitType(ctx.typeType()), var.variableDeclaratorId().Identifier().getText()));
            }
            if (this.analysisVisit) {
                return (String)this.visit(ctx.variableDeclarators());
            }
            if (this.iteration == 1) {
                declr = new DEPNode();
                declr.setLineOfCode(ctx.getStart().getLine());
                declr.setCode(this.getOriginalCodeText(ctx));
                this.dataNodes.put(ctx, declr);
                declr.setRuleCtx(ctx);
            } else {
                declr = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(declr, ctx.variableDeclarators());
            return null;
        }

        @Override
        public String visitBlock(JavaParser.BlockContext ctx) {
            int entrySize = this.localVars.size();
            this.visitChildren(ctx);
            if (this.localVars.size() > entrySize) {
                this.localVars.subList(entrySize, this.localVars.size()).clear();
            }
            return null;
        }

        @Override
        public String visitStatementExpression(JavaParser.StatementExpressionContext ctx) {
            DEPNode expr;
            if (this.analysisVisit) {
                return (String)this.visit(ctx.expression());
            }
            if (this.iteration == 1) {
                expr = new DEPNode();
                expr.setLineOfCode(ctx.getStart().getLine());
                expr.setCode(this.getOriginalCodeText(ctx));
                this.dataNodes.put(ctx, expr);
                expr.setRuleCtx(ctx);
            } else {
                expr = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(expr, ctx.expression());
            return null;
        }

        @Override
        public String visitIfStatement(JavaParser.IfStatementContext ctx) {
            DEPNode ifNode;
            if (this.iteration == 1) {
                ifNode = new DEPNode();
                ifNode.setLineOfCode(ctx.getStart().getLine());
                ifNode.setCode("if " + this.getOriginalCodeText(ctx.parExpression()));
                this.dataNodes.put(ctx, ifNode);
                ifNode.setRuleCtx(ctx);
            } else {
                ifNode = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(ifNode, ctx.parExpression().expression());
            for (JavaParser.StatementContext stmnt : ctx.statement()) {
                this.visit(stmnt);
            }
            return null;
        }

        @Override
        public String visitForStatement(JavaParser.ForStatementContext ctx) {
            DEPNode forExpr;
            int entrySize = this.localVars.size();
            if (ctx.forControl().enhancedForControl() != null) {
                if (this.iteration == 1) {
                    forExpr = new DEPNode();
                    forExpr.setLineOfCode(ctx.forControl().getStart().getLine());
                    forExpr.setCode("for (" + this.getOriginalCodeText(ctx.forControl()) + ")");
                    this.dataNodes.put(ctx.forControl().enhancedForControl(), forExpr);
                    forExpr.setRuleCtx(ctx.forControl().enhancedForControl());
                } else {
                    forExpr = this.dataNodes.get(ctx.forControl().enhancedForControl());
                }
                String type = this.visitType(ctx.forControl().enhancedForControl().typeType());
                String var = ctx.forControl().enhancedForControl().variableDeclaratorId().Identifier().getText();
                this.localVars.add(new JavaField(null, false, type, var));
                this.changed |= forExpr.addDEF(var);
                this.analyseDefUse(forExpr, ctx.forControl().enhancedForControl().expression());
            } else {
                if (ctx.forControl().forInit() != null) {
                    DEPNode forInit;
                    if (this.iteration == 1) {
                        forInit = new DEPNode();
                        forInit.setLineOfCode(ctx.forControl().forInit().getStart().getLine());
                        forInit.setCode(this.getOriginalCodeText(ctx.forControl().forInit()));
                        this.dataNodes.put(ctx.forControl().forInit(), forInit);
                        forInit.setRuleCtx(ctx.forControl().forInit());
                    } else {
                        forInit = this.dataNodes.get(ctx.forControl().forInit());
                    }
                    if (ctx.forControl().forInit().expressionList() != null) {
                        this.analyseDefUse(forInit, ctx.forControl().forInit().expressionList());
                    } else {
                        this.analyseDefUse(forInit, ctx.forControl().forInit().localVariableDeclaration());
                    }
                }
                if (ctx.forControl().expression() != null) {
                    if (this.iteration == 1) {
                        forExpr = new DEPNode();
                        forExpr.setLineOfCode(ctx.forControl().expression().getStart().getLine());
                        forExpr.setCode("for (" + this.getOriginalCodeText(ctx.forControl().expression()) + ")");
                        this.dataNodes.put(ctx.forControl().expression(), forExpr);
                        forExpr.setRuleCtx(ctx.forControl().expression());
                    } else {
                        forExpr = this.dataNodes.get(ctx.forControl().expression());
                    }
                    this.analyseDefUse(forExpr, ctx.forControl().expression());
                }
                if (ctx.forControl().forUpdate() != null) {
                    DEPNode forUpdate;
                    if (this.iteration == 1) {
                        forUpdate = new DEPNode();
                        forUpdate.setCode(this.getOriginalCodeText(ctx.forControl().forUpdate()));
                        forUpdate.setLineOfCode(ctx.forControl().forUpdate().getStart().getLine());
                        this.dataNodes.put(ctx.forControl().forUpdate(), forUpdate);
                        forUpdate.setRuleCtx(ctx.forControl().forUpdate());
                    } else {
                        forUpdate = this.dataNodes.get(ctx.forControl().forUpdate());
                    }
                    this.analyseDefUse(forUpdate, ctx.forControl().forUpdate().expressionList());
                }
            }
            String visit = (String)this.visit(ctx.statement());
            if (this.localVars.size() > entrySize) {
                this.localVars.subList(entrySize, this.localVars.size()).clear();
            }
            return visit;
        }

        @Override
        public String visitWhileStatement(JavaParser.WhileStatementContext ctx) {
            DEPNode whileNode;
            if (this.iteration == 1) {
                whileNode = new DEPNode();
                whileNode.setLineOfCode(ctx.getStart().getLine());
                whileNode.setCode("while " + this.getOriginalCodeText(ctx.parExpression()));
                this.dataNodes.put(ctx, whileNode);
                whileNode.setRuleCtx(ctx);
            } else {
                whileNode = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(whileNode, ctx.parExpression().expression());
            return (String)this.visit(ctx.statement());
        }

        @Override
        public String visitDoWhileStatement(JavaParser.DoWhileStatementContext ctx) {
            DEPNode whileNode;
            this.visit(ctx.statement());
            if (this.iteration == 1) {
                whileNode = new DEPNode();
                whileNode.setLineOfCode(ctx.parExpression().getStart().getLine());
                whileNode.setCode("while " + this.getOriginalCodeText(ctx.parExpression()));
                this.dataNodes.put(ctx, whileNode);
                whileNode.setRuleCtx(ctx);
            } else {
                whileNode = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(whileNode, ctx.parExpression().expression());
            return null;
        }

        @Override
        public String visitSwitchStatement(JavaParser.SwitchStatementContext ctx) {
            DEPNode switchNode;
            if (this.iteration == 1) {
                switchNode = new DEPNode();
                switchNode.setLineOfCode(ctx.getStart().getLine());
                switchNode.setCode("switch " + this.getOriginalCodeText(ctx.parExpression()));
                this.dataNodes.put(ctx, switchNode);
                switchNode.setRuleCtx(ctx);
            } else {
                switchNode = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(switchNode, ctx.parExpression().expression());
            for (JavaParser.SwitchBlockStatementGroupContext switchBlockStatementGroupContext : ctx.switchBlockStatementGroup()) {
                this.visit(switchBlockStatementGroupContext);
            }
            for (JavaParser.SwitchLabelContext switchLabelContext : ctx.switchLabel()) {
                this.visit(switchLabelContext);
            }
            return null;
        }

        @Override
        public String visitReturnStatement(JavaParser.ReturnStatementContext ctx) {
            DEPNode ret;
            if (this.iteration == 1) {
                ret = new DEPNode();
                ret.setLineOfCode(ctx.getStart().getLine());
                ret.setCode(this.getOriginalCodeText(ctx));
                this.dataNodes.put(ctx, ret);
                ret.setRuleCtx(ctx);
            } else {
                ret = this.dataNodes.get(ctx);
            }
            if (ctx.expression() != null) {
                this.analyseDefUse(ret, ctx.expression());
            }
            return null;
        }

        @Override
        public String visitSynchBlockStatement(JavaParser.SynchBlockStatementContext ctx) {
            DEPNode syncStmt;
            if (this.iteration == 1) {
                syncStmt = new DEPNode();
                syncStmt.setLineOfCode(ctx.getStart().getLine());
                syncStmt.setCode("synchronized " + this.getOriginalCodeText(ctx.parExpression()));
                this.dataNodes.put(ctx, syncStmt);
                syncStmt.setRuleCtx(ctx);
            } else {
                syncStmt = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(syncStmt, ctx.parExpression().expression());
            return (String)this.visit(ctx.block());
        }

        @Override
        public String visitThrowStatement(JavaParser.ThrowStatementContext ctx) {
            DEPNode throwNode;
            if (this.iteration == 1) {
                throwNode = new DEPNode();
                throwNode.setLineOfCode(ctx.getStart().getLine());
                throwNode.setCode("throw " + this.getOriginalCodeText(ctx.expression()));
                this.dataNodes.put(ctx, throwNode);
                throwNode.setRuleCtx(ctx);
            } else {
                throwNode = this.dataNodes.get(ctx);
            }
            this.analyseDefUse(throwNode, ctx.expression());
            return null;
        }

        @Override
        public String visitTryStatement(JavaParser.TryStatementContext ctx) {
            this.visit(ctx.block());
            if (ctx.catchClause() != null && ctx.catchClause().size() > 0) {
                for (JavaParser.CatchClauseContext cx : ctx.catchClause()) {
                    DEPNode catchNode;
                    if (this.iteration == 1) {
                        catchNode = new DEPNode();
                        catchNode.setLineOfCode(cx.getStart().getLine());
                        catchNode.setCode("catch (" + cx.catchType().getText() + " " + cx.Identifier().getText() + ")");
                        this.dataNodes.put(cx, catchNode);
                        catchNode.setRuleCtx(cx);
                    } else {
                        catchNode = this.dataNodes.get(cx);
                    }
                    String type = cx.catchType().getText();
                    String var = cx.Identifier().getText();
                    JavaField exceptionVar = new JavaField(null, false, type, var);
                    this.localVars.add(exceptionVar);
                    this.changed |= catchNode.addDEF(var);
                    this.visit(cx.block());
                    this.localVars.remove(exceptionVar);
                }
            }
            if (ctx.finallyBlock() != null) {
                this.visit(ctx.finallyBlock().block());
            }
            return null;
        }

        @Override
        public String visitTryWithResourceStatement(JavaParser.TryWithResourceStatementContext ctx) {
            String var;
            String type;
            int entrySize = this.localVars.size();
            for (JavaParser.ResourceContext rsrx : ctx.resourceSpecification().resources().resource()) {
                DEPNode resource;
                if (this.iteration == 1) {
                    resource = new DEPNode();
                    resource.setLineOfCode(rsrx.getStart().getLine());
                    resource.setCode(this.getOriginalCodeText(rsrx));
                    this.dataNodes.put(rsrx, resource);
                    resource.setRuleCtx(rsrx);
                } else {
                    resource = this.dataNodes.get(rsrx);
                }
                type = rsrx.classOrInterfaceType().getText();
                var = rsrx.variableDeclaratorId().getText();
                this.localVars.add(new JavaField(null, false, type, var));
                resource.addDEF(var);
                this.analyseDefUse(resource, rsrx);
            }
            this.visit(ctx.block());
            if (ctx.catchClause() != null && ctx.catchClause().size() > 0) {
                for (JavaParser.CatchClauseContext cx : ctx.catchClause()) {
                    DEPNode catchNode;
                    if (this.iteration == 1) {
                        catchNode = new DEPNode();
                        catchNode.setLineOfCode(cx.getStart().getLine());
                        catchNode.setCode("catch (" + cx.catchType().getText() + " " + cx.Identifier().getText() + ")");
                        this.dataNodes.put(cx, catchNode);
                        catchNode.setRuleCtx(cx);
                    } else {
                        catchNode = this.dataNodes.get(cx);
                    }
                    type = cx.catchType().getText();
                    var = cx.Identifier().getText();
                    JavaField exception = new JavaField(null, false, type, var);
                    this.localVars.add(exception);
                    this.changed |= catchNode.addDEF(var);
                    this.visit(cx.block());
                    this.localVars.remove(exception);
                }
            }
            if (ctx.finallyBlock() != null) {
                this.visit(ctx.finallyBlock().block());
            }
            if (this.localVars.size() > entrySize) {
                this.localVars.subList(entrySize, this.localVars.size()).clear();
            }
            return null;
        }

        @Override
        public String visitExprPrimary(JavaParser.ExprPrimaryContext ctx) {
            JavaParser.PrimaryContext primary = ctx.primary();
            if (primary.getText().startsWith("(") && primary.getText().endsWith(")")) {
                return "(" + (String)this.visit(primary.expression()) + ")";
            }
            if (primary.getText().equals("this")) {
                return "this";
            }
            if (primary.getText().equals("super")) {
                return "super";
            }
            if (primary.literal() != null) {
                if (primary.literal().IntegerLiteral() != null) {
                    return "$INT";
                }
                if (primary.literal().FloatingPointLiteral() != null) {
                    return "$DBL";
                }
                if (primary.literal().CharacterLiteral() != null) {
                    return "$CHR";
                }
                if (primary.literal().StringLiteral() != null) {
                    return "$STR";
                }
                if (primary.literal().BooleanLiteral() != null) {
                    return "$BOL";
                }
                return "$NUL";
            }
            if (primary.Identifier() != null) {
                return primary.Identifier().getText();
            }
            if (primary.getText().endsWith(".class")) {
                return "$CLS";
            }
            return primary.getText();
        }

        @Override
        public String visitExprDotID(JavaParser.ExprDotIDContext ctx) {
            return (String)this.visit(ctx.expression()) + "." + ctx.Identifier().getText();
        }

        @Override
        public String visitExprDotThis(JavaParser.ExprDotThisContext ctx) {
            return (String)this.visit(ctx.expression()) + ".this";
        }

        @Override
        public String visitExprCasting(JavaParser.ExprCastingContext ctx) {
            return "$CAST(" + this.visitType(ctx.typeType()) + ") " + (String)this.visit(ctx.expression());
        }

        @Override
        public String visitExpressionList(JavaParser.ExpressionListContext ctx) {
            StringBuilder expList = new StringBuilder((String)this.visit(ctx.expression(0)));
            for (int i = 1; i < ctx.expression().size(); ++i) {
                expList.append(", ").append((String)this.visit(ctx.expression(i)));
            }
            return expList.toString();
        }

        private boolean isUsableExpression(String expr) {
            if (expr.startsWith("$")) {
                return false;
            }
            if (expr.endsWith(")")) {
                return false;
            }
            if (expr.endsWith("]")) {
                return false;
            }
            if (expr.endsWith("++") || expr.endsWith("--")) {
                return false;
            }
            if (expr.startsWith("+") || expr.startsWith("-") || expr.startsWith("!") || expr.startsWith("~")) {
                return false;
            }
            if (expr.endsWith("}")) {
                return false;
            }
            return !expr.startsWith("<");
        }

        private String visitMethodArgs(JavaParser.ExpressionListContext ctx, MethodDefInfo defInfo) {
            if (ctx != null) {
                StringBuilder args = new StringBuilder();
                List<JavaParser.ExpressionContext> argsList = ctx.expression();
                String arg = (String)this.visit(argsList.get(0));
                args.append(arg);
                if (this.isUsableExpression(arg)) {
                    this.useList.add(arg);
                    if (defInfo != null && defInfo.argDEFs()[0]) {
                        this.defList.add(arg);
                    }
                }
                for (int i = 1; i < argsList.size(); ++i) {
                    arg = (String)this.visit(argsList.get(i));
                    args.append(", ").append(arg);
                    if (!this.isUsableExpression(arg)) continue;
                    this.useList.add(arg);
                    if (defInfo == null || !defInfo.argDEFs()[i]) continue;
                    this.defList.add(arg);
                }
                return args.toString();
            }
            return "";
        }

        @Override
        public String visitExprMethodInvocation(JavaParser.ExprMethodInvocationContext ctx) {
            String callExpression;
            String callee = null;
            String methodName = callExpression = (String)this.visit(ctx.expression());
            Logger.debug("---");
            Logger.debug("CALL EXPR : " + methodName);
            int start = 0;
            int lastDot = callExpression.lastIndexOf(46);
            if (lastDot > 0) {
                callee = callExpression.substring(start, lastDot);
                Logger.debug("HAS CALLEE : " + callee);
                if (this.isUsableExpression(callee)) {
                    this.useList.add(callee);
                    Logger.debug("CALLEE IS USABLE");
                }
                methodName = callExpression.substring(lastDot + 1);
            } else {
                Logger.debug("NO CALLEE");
                methodName = callExpression;
            }
            MethodDefInfo defInfo = this.findDefInfo(callee, methodName, ctx.expressionList());
            Logger.debug("FIND DEF RESULT: " + defInfo);
            Logger.debug("---");
            if (callee != null && defInfo != null && defInfo.doesStateDEF()) {
                this.defList.add(callee);
            }
            return callExpression + "(" + this.visitMethodArgs(ctx.expressionList(), defInfo) + ")";
        }

        @Override
        public String visitExprNewCreator(JavaParser.ExprNewCreatorContext ctx) {
            Object rest;
            String creator = null;
            if (ctx.creator().createdName().primitiveType() != null) {
                creator = ctx.creator().createdName().primitiveType().getText();
            } else {
                for (TerminalNode id : ctx.creator().createdName().Identifier()) {
                    creator = id.getText();
                }
            }
            if (ctx.creator().arrayCreatorRest() != null) {
                if (ctx.creator().arrayCreatorRest().arrayInitializer() != null) {
                    JavaParser.ArrayInitializerContext arrayInitCtx = ctx.creator().arrayCreatorRest().arrayInitializer();
                    StringBuilder arrayInit = new StringBuilder();
                    for (JavaParser.VariableInitializerContext initCtx : arrayInitCtx.variableInitializer()) {
                        String init = (String)this.visit(initCtx);
                        if (this.isUsableExpression(init)) {
                            this.useList.add(init);
                        }
                        arrayInit.append(init).append(", ");
                    }
                    rest = "{ " + arrayInit.toString() + " }";
                } else {
                    StringBuilder arrayCreate = new StringBuilder();
                    for (JavaParser.ExpressionContext exprCtx : ctx.creator().arrayCreatorRest().expression()) {
                        String expr = (String)this.visit(exprCtx);
                        if (this.isUsableExpression(expr)) {
                            this.useList.add(expr);
                        }
                        arrayCreate.append('[').append(expr).append(']');
                    }
                    rest = arrayCreate.toString();
                }
            } else {
                JavaParser.ArgumentsContext argsCtx = ctx.creator().classCreatorRest().arguments();
                MethodDefInfo defInfo = this.findDefInfo(null, creator, argsCtx.expressionList());
                rest = "(" + this.visitMethodArgs(argsCtx.expressionList(), defInfo) + ")";
            }
            return "$NEW " + creator + (String)rest;
        }

        @Override
        public String visitExprDotNewInnerCreator(JavaParser.ExprDotNewInnerCreatorContext ctx) {
            String expression = (String)this.visit(ctx.expression());
            if (this.isUsableExpression(expression)) {
                this.useList.add(expression);
            }
            String creator = ctx.innerCreator().Identifier().getText();
            JavaParser.ArgumentsContext argsCtx = ctx.innerCreator().classCreatorRest().arguments();
            MethodDefInfo defInfo = this.findDefInfo(null, creator, argsCtx.expressionList());
            String rest = "(" + this.visitMethodArgs(argsCtx.expressionList(), defInfo) + ")";
            return expression + ".$NEW " + creator + rest;
        }

        @Override
        public String visitExprDotSuper(JavaParser.ExprDotSuperContext ctx) {
            StringBuilder result = new StringBuilder();
            String expr = (String)this.visit(ctx.expression());
            if (this.isUsableExpression(expr)) {
                this.useList.add(expr);
            }
            result.append(expr).append(".super");
            if (ctx.superSuffix().arguments() != null) {
                this.useList.add(result.toString());
                if (ctx.superSuffix().getText().startsWith(".")) {
                    result.append('.').append(ctx.superSuffix().Identifier().getText()).append('(');
                }
                result.append(this.visitMethodArgs(ctx.superSuffix().arguments().expressionList(), null));
                result.append(')');
            } else {
                result.append('.').append(ctx.superSuffix().Identifier().getText());
            }
            return result.toString();
        }

        @Override
        public String visitExprDotGenInvok(JavaParser.ExprDotGenInvokContext ctx) {
            Object invocSuffix;
            JavaParser.ExplicitGenericInvocationSuffixContext suffixContext;
            String expression = (String)this.visit(ctx.expression());
            if (this.isUsableExpression(expression)) {
                this.useList.add(expression);
            }
            if ((suffixContext = ctx.explicitGenericInvocation().explicitGenericInvocationSuffix()).Identifier() != null) {
                invocSuffix = suffixContext.Identifier().getText();
                invocSuffix = (String)invocSuffix + "(" + this.visitMethodArgs(suffixContext.arguments().expressionList(), null) + ")";
            } else {
                invocSuffix = "super";
                if (suffixContext.superSuffix().Identifier() != null) {
                    invocSuffix = (String)invocSuffix + "." + suffixContext.superSuffix().Identifier().getText();
                }
                if (suffixContext.superSuffix().arguments() != null) {
                    invocSuffix = (String)invocSuffix + "(" + this.visitMethodArgs(suffixContext.superSuffix().arguments().expressionList(), null) + ")";
                }
            }
            return expression + "." + ctx.explicitGenericInvocation().nonWildcardTypeArguments().getText() + (String)invocSuffix;
        }

        @Override
        public String visitExprArrayIndexing(JavaParser.ExprArrayIndexingContext ctx) {
            String index;
            String array = (String)this.visit(ctx.expression(0));
            if (this.isUsableExpression(array)) {
                this.useList.add(array);
            }
            if (this.isUsableExpression(index = (String)this.visit(ctx.expression(1)))) {
                this.useList.add(index);
            }
            return array + "[" + index + "]";
        }

        @Override
        public String visitExprConditional(JavaParser.ExprConditionalContext ctx) {
            String retFalse;
            String retTrue;
            String prdct = (String)this.visit(ctx.expression(0));
            if (this.isUsableExpression(prdct)) {
                this.useList.add(prdct);
            }
            if (this.isUsableExpression(retTrue = (String)this.visit(ctx.expression(1)))) {
                this.useList.add(retTrue);
            }
            if (this.isUsableExpression(retFalse = (String)this.visit(ctx.expression(2)))) {
                this.useList.add(retFalse);
            }
            return prdct + " ? " + retTrue + " : " + retFalse;
        }

        @Override
        public String visitExprPostUnaryOp(JavaParser.ExprPostUnaryOpContext ctx) {
            String expr = (String)this.visit(ctx.expression());
            if (this.isUsableExpression(expr)) {
                this.useList.add(expr);
                this.defList.add(expr);
            }
            if (ctx.getText().endsWith("++")) {
                return expr + "++";
            }
            return expr + "--";
        }

        @Override
        public String visitExprPreUnaryOp(JavaParser.ExprPreUnaryOpContext ctx) {
            String expr = (String)this.visit(ctx.expression());
            if (this.isUsableExpression(expr)) {
                this.useList.add(expr);
                if (ctx.getText().startsWith("--") || ctx.getText().startsWith("++")) {
                    this.defList.add(expr);
                    this.selfFlowList.add(expr);
                }
            }
            if (ctx.getText().charAt(0) == '+') {
                if (ctx.getText().startsWith("++")) {
                    return "++" + expr;
                }
                return "+" + expr;
            }
            if (ctx.getText().startsWith("--")) {
                return "--" + expr;
            }
            return "-" + expr;
        }

        @Override
        public String visitExprNegation(JavaParser.ExprNegationContext ctx) {
            String expr = (String)this.visit(ctx.expression());
            if (this.isUsableExpression(expr)) {
                this.useList.add(expr);
            }
            if (ctx.getText().startsWith("~")) {
                return "~" + expr;
            }
            return "!" + expr;
        }

        @Override
        public String visitExprMulDivMod(JavaParser.ExprMulDivModContext ctx) {
            String op;
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            switch (ctx.getChild(1).getText().charAt(0)) {
                case '*': {
                    op = " $MUL ";
                    break;
                }
                case '/': {
                    op = " $DIV ";
                    break;
                }
                default: {
                    op = " $MOD ";
                }
            }
            return "(" + expr1 + op + expr2 + ")";
        }

        @Override
        public String visitExprAddSub(JavaParser.ExprAddSubContext ctx) {
            String op;
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            switch (ctx.getChild(1).getText().charAt(0)) {
                case '+': {
                    op = " $ADD ";
                    break;
                }
                default: {
                    op = " $SUB ";
                }
            }
            return "(" + expr1 + op + expr2 + ")";
        }

        @Override
        public String visitExprBitShift(JavaParser.ExprBitShiftContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " $SHIFT " + expr2 + ")";
        }

        @Override
        public String visitExprComparison(JavaParser.ExprComparisonContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " $COMP " + expr2 + ")";
        }

        @Override
        public String visitExprInstanceOf(JavaParser.ExprInstanceOfContext ctx) {
            String expr = (String)this.visit(ctx.expression());
            return "(" + expr + " $INSTANCE " + ctx.typeType().getText() + ")";
        }

        @Override
        public String visitExprEquality(JavaParser.ExprEqualityContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " $EQL " + expr2 + ")";
        }

        @Override
        public String visitExprBitAnd(JavaParser.ExprBitAndContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " & " + expr2 + ")";
        }

        @Override
        public String visitExprBitXOR(JavaParser.ExprBitXORContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " ^ " + expr2 + ")";
        }

        @Override
        public String visitExprBitOr(JavaParser.ExprBitOrContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " | " + expr2 + ")";
        }

        @Override
        public String visitExprLogicAnd(JavaParser.ExprLogicAndContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " && " + expr2 + ")";
        }

        @Override
        public String visitExprLogicOr(JavaParser.ExprLogicOrContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                this.useList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " || " + expr2 + ")";
        }

        @Override
        public String visitExprAssignment(JavaParser.ExprAssignmentContext ctx) {
            String expr1 = (String)this.visit(ctx.expression(0));
            String expr2 = (String)this.visit(ctx.expression(1));
            if (this.isUsableExpression(expr1)) {
                if (!ctx.getChild(1).getText().equals("=")) {
                    this.useList.add(expr1);
                }
                this.defList.add(expr1);
            }
            if (this.isUsableExpression(expr2)) {
                this.useList.add(expr2);
            }
            return "(" + expr1 + " $ASSIGN " + expr2 + ")";
        }

        @Override
        public String visitVariableDeclarators(JavaParser.VariableDeclaratorsContext ctx) {
            StringBuilder vars = new StringBuilder();
            vars.append((String)this.visit(ctx.variableDeclarator(0)));
            for (int i = 1; i < ctx.variableDeclarator().size(); ++i) {
                vars.append(", ").append((String)this.visit(ctx.variableDeclarator(i)));
            }
            return vars.toString();
        }

        @Override
        public String visitVariableDeclarator(JavaParser.VariableDeclaratorContext ctx) {
            Object init = "";
            String varID = ctx.variableDeclaratorId().Identifier().getText();
            if (ctx.variableInitializer() != null) {
                init = (String)this.visit(ctx.variableInitializer());
                if (this.isUsableExpression((String)init)) {
                    this.useList.add((String)init);
                }
                this.defList.add(varID);
                init = " $INIT " + (String)init;
            }
            return "$VAR " + varID + (String)init;
        }

        @Override
        public String visitVariableInitializer(JavaParser.VariableInitializerContext ctx) {
            if (ctx.expression() != null) {
                return (String)this.visit(ctx.expression());
            }
            StringBuilder arrayInit = new StringBuilder();
            for (JavaParser.VariableInitializerContext initCtx : ctx.arrayInitializer().variableInitializer()) {
                String init = (String)this.visit(initCtx);
                if (this.isUsableExpression(init)) {
                    this.useList.add(init);
                }
                arrayInit.append(init).append(", ");
            }
            return "{ " + arrayInit.toString() + " }";
        }

        private String getOriginalCodeText(ParserRuleContext ctx) {
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStopIndex();
            Interval interval = new Interval(start, stop);
            return ctx.start.getInputStream().getText(interval);
        }
    }
}

