/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.dg.pdg;

import java.util.Arrays;
import java.util.Objects;

public class JavaMethod {
    public final String NAME;
    public final boolean STATIC;
    public final boolean ABSTRACT;
    public final String MODIFIER;
    public final String RET_TYPE;
    public final int LINE_OF_CODE;
    public final String[] ARG_TYPES;

    public JavaMethod(String modifier, boolean isStatic, boolean isAbstract, String retType, String name, String[] argTypes, int line) {
        this.NAME = name;
        this.STATIC = isStatic;
        this.ABSTRACT = isAbstract;
        this.MODIFIER = modifier;
        this.RET_TYPE = retType;
        this.ARG_TYPES = argTypes;
        this.LINE_OF_CODE = line;
    }

    public String toString() {
        Object modifier;
        Object object = modifier = this.MODIFIER == null ? "null" : this.MODIFIER;
        if (this.STATIC) {
            modifier = ((String)modifier).equals("null") ? "static" : (String)modifier + " static";
        }
        if (this.ABSTRACT) {
            modifier = ((String)modifier).equals("null") ? "abstract" : (String)modifier + " abstract";
        }
        String retType = this.RET_TYPE == null ? "null" : this.RET_TYPE;
        String args = this.ARG_TYPES == null ? "null" : Arrays.toString(this.ARG_TYPES);
        StringBuilder str = new StringBuilder();
        str.append("{ MODIFIER : \"").append((String)modifier).append("\", ");
        str.append("TYPE : \"").append(retType).append("\", ");
        str.append("NAME : \"").append(this.NAME).append("\", ");
        str.append("ARGS : ").append(args).append(", ");
        str.append("LINE : \"").append(this.LINE_OF_CODE).append("\" }");
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaMethod)) {
            return false;
        }
        JavaMethod m = (JavaMethod)obj;
        return this.NAME.equals(m.NAME) && this.RET_TYPE.equals(m.RET_TYPE) && this.LINE_OF_CODE == m.LINE_OF_CODE && Arrays.equals(this.ARG_TYPES, m.ARG_TYPES);
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.NAME);
        hash = 31 * hash + Objects.hashCode(this.RET_TYPE);
        hash = 31 * hash + this.LINE_OF_CODE;
        hash = 31 * hash + Arrays.deepHashCode(this.ARG_TYPES);
        return hash;
    }
}

