/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.common.graph;

import codetoolkit.janalysis.common.collections.IdentityLinkedHashSet;
import codetoolkit.janalysis.common.graph.AbstractPropertyGraph;
import codetoolkit.janalysis.common.graph.Digraph;
import codetoolkit.janalysis.common.graph.Edge;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class IdentityDigraph<V, E>
extends Digraph<V, E> {
    protected Set<V> allVerticesEq;
    protected Set<Edge<V, E>> allEdgesEq;

    public IdentityDigraph() {
        this.allEdges = new IdentityLinkedHashSet(32);
        this.allVertices = new IdentityLinkedHashSet();
        this.inEdges = new IdentityHashMap();
        this.outEdges = new IdentityHashMap();
        this.allEdgesEq = new LinkedHashSet<Edge<V, E>>(32);
        this.allVerticesEq = new LinkedHashSet<V>();
    }

    public IdentityDigraph(AbstractPropertyGraph<V, E> graph) {
        this.allEdges = new IdentityLinkedHashSet(graph.allEdges);
        this.allVertices = new IdentityLinkedHashSet(graph.allVertices);
        if (graph instanceof IdentityDigraph) {
            IdentityDigraph idgraph = (IdentityDigraph)graph;
            this.allEdgesEq = new LinkedHashSet<Edge<V, Edge<V, E>>>(idgraph.allEdgesEq);
            this.allVerticesEq = new LinkedHashSet<V>(idgraph.allVerticesEq);
        }
        this.inEdges = new IdentityHashMap();
        for (Object v : graph.inEdges.keySet()) {
            this.inEdges.put(v, new IdentityLinkedHashSet(graph.inEdges.get(v)));
        }
        this.outEdges = new IdentityHashMap();
        for (Object v : graph.outEdges.keySet()) {
            this.outEdges.put(v, new IdentityLinkedHashSet(graph.outEdges.get(v)));
        }
    }

    @Override
    public boolean addVertex(V v) {
        if (this.allVertices.add(v)) {
            this.inEdges.put(v, new IdentityLinkedHashSet());
            this.outEdges.put(v, new IdentityLinkedHashSet());
            return true;
        }
        return false;
    }

    @Override
    public Set<Edge<V, E>> removeEdges(V src, V trgt) {
        if (!this.allVertices.contains(src)) {
            throw new IllegalArgumentException("No such source-vertex in this graph!");
        }
        if (!this.allVertices.contains(trgt)) {
            throw new IllegalArgumentException("No such target-vertex in this graph!");
        }
        IdentityLinkedHashSet<Edge<V, Edge>> removed = new IdentityLinkedHashSet<Edge<V, Edge>>();
        if (((Set)this.inEdges.get(trgt)).size() > ((Set)this.outEdges.get(src)).size()) {
            Set iterSet = (Set)this.outEdges.get(src);
            Iterator it = iterSet.iterator();
            while (it.hasNext()) {
                Edge next = (Edge)it.next();
                if (!next.target.equals(trgt)) continue;
                it.remove();
                this.allEdges.remove(next);
                ((Set)this.inEdges.get(trgt)).remove(next);
                removed.add(next);
            }
        } else {
            Set iterSet = (Set)this.inEdges.get(trgt);
            Iterator it = iterSet.iterator();
            while (it.hasNext()) {
                Edge next = (Edge)it.next();
                if (!next.source.equals(src)) continue;
                it.remove();
                this.allEdges.remove(next);
                ((Set)this.outEdges.get(src)).remove(next);
                removed.add(next);
            }
        }
        return removed;
    }

    @Override
    public Set<Edge<V, E>> copyEdgeSet() {
        return new IdentityLinkedHashSet<Edge<V, E>>(this.allEdges);
    }

    @Override
    public Set<V> copyVertexSet() {
        return new IdentityLinkedHashSet(this.allVertices);
    }

    @Override
    public Set<Edge<V, E>> copyIncomingEdges(V v) {
        if (!this.allVertices.contains(v)) {
            throw new IllegalArgumentException("No such vertex in this graph!");
        }
        return new IdentityLinkedHashSet<Edge<V, E>>((Set)this.inEdges.get(v));
    }

    @Override
    public Set<Edge<V, E>> copyOutgoingEdges(V v) {
        if (!this.allVertices.contains(v)) {
            throw new IllegalArgumentException("No such vertex in this graph!");
        }
        return new IdentityLinkedHashSet<Edge<V, E>>((Set)this.outEdges.get(v));
    }

    @Override
    public boolean containsVertex(V v) {
        return this.allVerticesEq.contains(v);
    }

    public boolean hasVertex(V v) {
        return this.allVertices.contains(v);
    }

    @Override
    public boolean containsEdge(Edge<V, E> e) {
        return this.allEdgesEq.contains(e);
    }

    public boolean hasEdge(Edge<V, E> e) {
        return this.allEdges.contains(e);
    }

    @Override
    public boolean containsEdge(V src, V trg) {
        if (!this.allVerticesEq.contains(src) || !this.allVerticesEq.contains(trg)) {
            return false;
        }
        for (Object v : this.outEdges.keySet()) {
            if (!v.equals(src)) continue;
            for (Edge edge : (Set)this.outEdges.get(v)) {
                if (!edge.target.equals(trg)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasEdge(V src, V trg) {
        for (Edge edge : (Set)this.outEdges.get(src)) {
            if (edge.target != trg) continue;
            return true;
        }
        return false;
    }
}

