/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.common.graph;

import codetoolkit.janalysis.common.graph.Edge;
import codetoolkit.janalysis.common.graph.Graph;
import codetoolkit.janalysis.common.graph.Matcher;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractPropertyGraph<V, E>
implements Graph<V, E> {
    protected Set<V> allVertices;
    protected Set<Edge<V, E>> allEdges;
    protected Map<V, Set<Edge<V, E>>> inEdges;
    protected Map<V, Set<Edge<V, E>>> outEdges;
    protected final Map<String, String> properties;

    public AbstractPropertyGraph() {
        this.properties = new HashMap<String, String>();
    }

    public AbstractPropertyGraph(AbstractPropertyGraph graph) {
        this.properties = new HashMap<String, String>(graph.properties);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String putProperty(String name, String value) {
        return this.properties.put(name, value);
    }

    public String removeProperty(String name) {
        return this.properties.remove(name);
    }

    protected abstract Matcher<V> getVertexMatcher();

    protected abstract Matcher<Edge<V, E>> getEdgesMatcher();

    @Override
    public int vertexCount() {
        return this.allVertices.size();
    }

    @Override
    public int edgeCount() {
        return this.allEdges.size();
    }

    @Override
    public Iterator<Edge<V, E>> allEdgesIterator() {
        return Collections.unmodifiableSet(this.allEdges).iterator();
    }

    @Override
    public Iterator<V> allVerticesIterator() {
        return Collections.unmodifiableSet(this.allVertices).iterator();
    }

    @Override
    public Iterator<Edge<V, E>> incomingEdgesIterator(V v) {
        return Collections.unmodifiableSet(this.inEdges.get(v)).iterator();
    }

    @Override
    public Iterator<Edge<V, E>> outgoingEdgesIterator(V v) {
        return Collections.unmodifiableSet(this.outEdges.get(v)).iterator();
    }

    @Override
    public boolean addGraph(AbstractPropertyGraph<V, E> graph) {
        boolean modified = false;
        for (V v : graph.allVertices) {
            modified |= this.addVertex(v);
        }
        for (Edge edge : graph.allEdges) {
            modified |= this.addEdge(edge);
        }
        return modified;
    }

    @Override
    public int getInDegree(V v) {
        if (this.inEdges.get(v) == null) {
            throw new IllegalArgumentException("No such vertex in this graph!");
        }
        return this.inEdges.get(v).size();
    }

    @Override
    public int getOutDegree(V v) {
        if (this.outEdges.get(v) == null) {
            throw new IllegalArgumentException("No such vertex in this graph!");
        }
        return this.outEdges.get(v).size();
    }

    @Override
    public Set<Edge<V, E>> getEdgesWithLabel(E label) {
        LinkedHashSet<Edge<V, Edge<V, E>>> edges = new LinkedHashSet<Edge<V, Edge<V, E>>>();
        if (label == null) {
            for (Edge<V, E> e : this.allEdges) {
                if (e.label != null) continue;
                edges.add(e);
            }
        } else {
            for (Edge<V, E> e : this.allEdges) {
                if (!label.equals(e.label)) continue;
                edges.add(e);
            }
        }
        return edges;
    }

    @Override
    public boolean containsVertex(V v) {
        return this.allVertices.contains(v);
    }

    @Override
    public boolean containsAllEdges(Set<Edge<V, E>> set) {
        for (Edge<V, E> edge : set) {
            if (this.containsEdge(edge)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAllVertices(Set<V> set) {
        for (V v : set) {
            if (this.containsVertex(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubgraphOf(Graph<V, E> base) {
        if (this.isDirected() != base.isDirected()) {
            return false;
        }
        if (this.vertexCount() > base.vertexCount() || this.edgeCount() > base.edgeCount()) {
            return false;
        }
        if (base.containsAllVertices(this.allVertices)) {
            for (Edge<V, E> edge : this.allEdges) {
                if (base.containsEdge(edge)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isProperSubgraphOf(Graph<V, E> base) {
        if (this.vertexCount() == base.vertexCount() && this.edgeCount() == base.edgeCount()) {
            return false;
        }
        return this.isSubgraphOf(base);
    }

    @Override
    public boolean isConnected() {
        HashSet visited = new HashSet();
        ArrayDeque visiting = new ArrayDeque();
        visiting.add(this.allVertices.iterator().next());
        while (!visiting.isEmpty()) {
            Object next = visiting.remove();
            visited.add(next);
            for (Edge<V, E> out : this.outEdges.get(next)) {
                if (visited.contains(out.target)) continue;
                visiting.add(out.target);
            }
            for (Edge<V, E> in : this.inEdges.get(next)) {
                if (visited.contains(in.source)) continue;
                visiting.add(in.source);
            }
        }
        return visited.size() == this.allVertices.size();
    }

    public String toOneLineString() {
        StringBuilder str = new StringBuilder("{ ");
        for (V vrtx : this.allVertices) {
            str.append(vrtx).append(": [ ");
            if (!this.outEdges.get(vrtx).isEmpty()) {
                for (Edge<V, E> edge : this.outEdges.get(vrtx)) {
                    if (edge.label == null) {
                        str.append("(->").append(edge.target).append(") ");
                        continue;
                    }
                    str.append("(").append(edge.label).append("->").append(edge.target).append(") ");
                }
            }
            str.append("]; ");
        }
        str.append("}");
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (V vrtx : this.allVertices) {
            str.append(vrtx).append(":\n");
            for (Edge<V, E> edge : this.outEdges.get(vrtx)) {
                if (edge.label == null) {
                    str.append("  --> ").append(edge.target).append("\n");
                    continue;
                }
                str.append("  --(").append(edge.label).append(")--> ").append(edge.target).append("\n");
            }
        }
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Objects.equals(this.getClass(), obj.getClass())) {
            return false;
        }
        AbstractPropertyGraph other = (AbstractPropertyGraph)obj;
        return this.isDirected() == other.isDirected() && this.vertexCount() == other.vertexCount() && this.edgeCount() == other.edgeCount() && this.allVertices.containsAll(other.allVertices) && this.allEdges.containsAll(other.allEdges);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.isDirected() ? 1 : 0);
        for (V v : this.allVertices) {
            hash = 31 * hash + Objects.hashCode(v);
        }
        for (Edge edge : this.allEdges) {
            hash = 31 * hash + Objects.hashCode(edge);
        }
        return hash;
    }
}

